/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageProvider;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementGetter;
import com.fr.report.fun.ExportEncodeProvider;
import com.fr.report.report.ECReport;
import com.fr.report.report.ResultReport;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.web.core.ReportRepositoryDeal;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.util.Iterator;
import java.util.List;

public class CSVExporter
extends AbstractAppExporter {
    public void exportReport(OutputStream outputStream, ElementGetter elementGetter, int n2, int n3) throws Exception {
        PrintWriter printWriter = new PrintWriter(this.getOutputWriter(outputStream));
        int n4 = elementGetter.getColumnCount();
        int n5 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = elementGetter.getRow(i2);
            n5 = 0;
            while (iterator.hasNext()) {
                Style style;
                Format format;
                CellElement cellElement = (CellElement)iterator.next();
                int n6 = cellElement.getColumn();
                while (n5 < n6) {
                    if ((n5 * i2 & 0x1FFF) == 0) {
                        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
                    }
                    stringBuffer.append(',');
                    stringBuffer.append("");
                    ++n5;
                }
                Object object = this.getCellValue(cellElement);
                String string = Style.valueToText(object, format = (style = cellElement.getStyle()).getFormat());
                if (string.indexOf(",") != -1 || string.indexOf("\uff0c") != -1) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(string);
            }
            while (n5 < n4) {
                if (n5 != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("");
                ++n5;
            }
            printWriter.println(stringBuffer.toString());
        }
        printWriter.flush();
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(ReportFunctionProcessor.CSV_EXPORT);
        }
    }

    private OutputStreamWriter getOutputWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        ExportEncodeProvider exportEncodeProvider = ExtraReportClassManager.getInstance().getCsvExportEncodeProvider();
        if (exportEncodeProvider != null) {
            return exportEncodeProvider.getCsvOutputStreamWriter(outputStream);
        }
        return new OutputStreamWriter(outputStream, ConfigManager.getProviderInstance().getServerCharset());
    }

    private Object getCellValue(CellElement cellElement) {
        Object object = cellElement.getValue();
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        if (cellGUIAttr != null && !cellGUIAttr.isPrintContent()) {
            object = "";
        }
        return object == null ? "" : object;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        List<PaperSettingProvider> list = ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook);
        int n2 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.export(outputStream, resultWorkBook.getResultReport(i2), list.get(i2));
        }
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater, ReportRepositoryDeal reportRepositoryDeal, int[] nArray) throws Exception {
        this.export(outputStream, pageSetCreater.createPageSet());
    }

    private void export(OutputStream outputStream, ResultReport resultReport, PaperSettingProvider paperSettingProvider) throws Exception {
        if (resultReport != null) {
            FRContext.getLogger().info("UnLayerReport start export");
            this.exportReport(outputStream, (ECReport)((Object)resultReport), 0, ((ECReport)((Object)resultReport)).getRowCount());
        }
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        ReportPageProvider reportPageProvider;
        ClippedPageProvider clippedPageProvider;
        for (int i2 = 0; i2 < pageSetProvider.size() && (clippedPageProvider = ExporterUtils.support(reportPageProvider = pageSetProvider.getPage(i2))) != null; ++i2) {
            this.exportReport(outputStream, (ElementGetter)((Object)clippedPageProvider), 0, ((ElementGetter)((Object)clippedPageProvider)).getRowCount());
        }
    }
}

