/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.attr;

import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class ExcelExportAttr
implements XMLable,
Cloneable,
Serializable {
    private boolean isExportHidedRow = false;
    private boolean isExportHidedColumn = false;
    private String password = null;
    private String protectedWord = null;

    public boolean isExportHidedRow() {
        return this.isExportHidedRow;
    }

    public void setExportHidedRow(boolean bl) {
        this.isExportHidedRow = bl;
    }

    public boolean isExportHidedColumn() {
        return this.isExportHidedColumn;
    }

    public void setExportHidedColumn(boolean bl) {
        this.isExportHidedColumn = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExcelExportAttr");
        if (!this.isExportHidedColumn()) {
            xMLPrintWriter.attr("hideColumn", this.isExportHidedColumn);
        }
        if (!this.isExportHidedRow()) {
            xMLPrintWriter.attr("hideRow", this.isExportHidedRow);
        }
        if (StringUtils.isNotBlank(this.getPassword())) {
            xMLPrintWriter.attr("pwd", CodeUtils.passwordEncode(this.password));
        }
        if (StringUtils.isNotBlank(this.getProtectedWord())) {
            xMLPrintWriter.attr("protectedWord", CodeUtils.passwordEncode(this.getProtectedWord()));
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isAttr()) {
            this.setExportHidedRow(xMLableReader.getAttrAsBoolean("hideRow", true));
            this.setExportHidedColumn(xMLableReader.getAttrAsBoolean("hideColumn", true));
            string = xMLableReader.getAttrAsString("pwd", null);
            if (string != null) {
                this.setPassword(CodeUtils.passwordDecode(string));
            }
            if ((string = xMLableReader.getAttrAsString("protectedWord", null)) != null) {
                this.setProtectedWord(CodeUtils.passwordDecode(string));
            }
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if ("ExportHidedRow".equals(string2)) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.setExportHidedRow(Boolean.valueOf(string));
                }
            } else if ("ExportHidedColumn".equals(string2) && (string = xMLableReader.getElementValue()) != null) {
                this.setExportHidedColumn(Boolean.valueOf(string));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExcelExportAttr excelExportAttr = (ExcelExportAttr)super.clone();
        excelExportAttr.setExportHidedColumn(this.isExportHidedColumn());
        excelExportAttr.setExportHidedRow(this.isExportHidedRow());
        return excelExportAttr;
    }

    public String getProtectedWord() {
        return this.protectedWord;
    }

    public void setProtectedWord(String string) {
        this.protectedWord = string;
    }
}

