/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.process;

import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.process.ExecuteResult;
import com.fr.general.process.LocalCommandExecutorService;
import com.fr.general.process.StreamWrapperThread;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCommandExecutorServiceImpl
implements LocalCommandExecutorService {
    static ExecutorService pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult executeCommand(String[] stringArray, long l2) {
        if (ArrayUtils.getLength(stringArray) == 0 || l2 < 0L) {
            return new ExecuteResult(-1, "");
        }
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        StreamWrapperThread streamWrapperThread = null;
        StreamWrapperThread streamWrapperThread2 = null;
        Future<Integer> future = null;
        try {
            if (FRLogger.getLogger().isLoggable(Level.CONFIG)) {
                FRLogger.getLogger().info(Inter.getLocText("FR-Base_Get_Machine_Info_Prompt", StringUtils.join(" ", stringArray)));
            }
            final Process process2 = process = Runtime.getRuntime().exec(stringArray);
            process2.getOutputStream().close();
            inputStream = process.getInputStream();
            streamWrapperThread = new StreamWrapperThread(inputStream);
            streamWrapperThread.start();
            inputStream2 = process.getErrorStream();
            streamWrapperThread2 = new StreamWrapperThread(inputStream2);
            streamWrapperThread2.start();
            Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    process2.waitFor();
                    return process2.exitValue();
                }
            };
            future = pool.submit(callable);
            int n2 = future.get(l2, TimeUnit.MILLISECONDS);
            ExecuteResult executeResult = new ExecuteResult(n2, streamWrapperThread.getContent());
            Object var15_15 = null;
            this.closeAll(future, streamWrapperThread2, streamWrapperThread, inputStream, inputStream2, process);
            return executeResult;
        }
        catch (Exception exception) {
            try {
                ExecuteResult executeResult = new ExecuteResult(-1, "");
                Object var15_16 = null;
                this.closeAll(future, streamWrapperThread2, streamWrapperThread, inputStream, inputStream2, process);
                return executeResult;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                this.closeAll(future, streamWrapperThread2, streamWrapperThread, inputStream, inputStream2, process);
                throw throwable;
            }
        }
    }

    private void closeAll(Future<Integer> future, StreamWrapperThread streamWrapperThread, StreamWrapperThread streamWrapperThread2, InputStream inputStream, InputStream inputStream2, Process process) {
        if (future != null) {
            try {
                future.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeThread(inputStream, streamWrapperThread2);
        this.closeThread(inputStream2, streamWrapperThread);
        if (process != null) {
            process.destroy();
        }
    }

    private void closeThread(InputStream inputStream, StreamWrapperThread streamWrapperThread) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (streamWrapperThread != null && !streamWrapperThread.isInterrupted()) {
                streamWrapperThread.interrupt();
            }
        }
    }
}

