/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.stable.ArrayProvider;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FArray<T>
implements ArrayProvider<T>,
XMLWriter,
XMLReadable,
Serializable,
Iterable {
    private List<T> list = new ArrayList<T>();
    private static final String SEPARATOR = ",";

    public FArray() {
    }

    public FArray(T[] TArray) {
        this(Arrays.asList(TArray));
    }

    public FArray(Collection<T> collection) {
        this.list.addAll(collection);
    }

    @Override
    public Object[] asObjects() {
        return this.list.toArray();
    }

    @Override
    public T elementAt(int n2) {
        return this.list.get(n2);
    }

    @Override
    public int length() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public void removeElement(int n2) {
        if (n2 > -1 && n2 < this.length()) {
            this.list.remove(n2);
        }
    }

    public void setElement(int n2, T t2) {
        if (n2 > -1 && n2 < this.length()) {
            this.list.set(n2, t2);
        }
    }

    @Override
    public ArrayProvider<T> add(T t2) {
        if (t2 instanceof FArray) {
            this.list.addAll(((FArray)t2).list);
        } else {
            this.list.add(t2);
        }
        return this;
    }

    public ArrayProvider<T> simpleAdd(T t2) {
        this.list.add(t2);
        return this;
    }

    @Override
    public List<T> toList() {
        return Collections.unmodifiableList(this.list);
    }

    public String toString() {
        return StableUtils.join(this.list, SEPARATOR);
    }

    public FArray cjkEncode() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i2 = 0; i2 < this.length(); ++i2) {
            T t2 = this.list.get(i2);
            if (t2 instanceof String) {
                arrayList.add(i2, CodeUtils.cjkEncode((String)t2));
                continue;
            }
            if (t2 instanceof JSONArray) {
                arrayList.add(((JSONArray)t2).cjkEncode());
                continue;
            }
            arrayList.add(t2);
        }
        this.list = arrayList;
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FArray)) {
            return false;
        }
        FArray fArray = (FArray)object;
        if (this.length() != fArray.length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (ComparatorUtils.equals(this.elementAt(i2), fArray.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FARRAY");
        int n2 = this.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("FARRAYVALUE");
            GeneralXMLTools.writeObject(xMLPrintWriter, this.elementAt(i2));
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "FARRAYVALUE".equals(string = xMLableReader.getTagName())) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "O".equals(xMLableReader.getTagName())) {
                        Object object = GeneralXMLTools.readObject(xMLableReader);
                        FArray.this.add(object);
                    }
                }
            });
        }
    }
}

