/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.cache.list.IntList;
import com.fr.general.DesUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogger;
import com.fr.general.FUNC;
import com.fr.general.GeneralContext;
import com.fr.stable.LicUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;

public class AppContentGenerator {
    public static final long TWO_DAY = 172800000L;
    private static int THIRTY = 30;
    private static int THIRD = 3;
    private static int ITEARTOR_TIMES = 4;
    private static int PROJECT_CONTENT_SIZE = 24;
    private static Timer SCHEDULE_GENERATE_APPCONTENT;
    private static String app_content;

    private static void initTimer() {
        if (SCHEDULE_GENERATE_APPCONTENT != null) {
            return;
        }
        SCHEDULE_GENERATE_APPCONTENT = new Timer();
        SCHEDULE_GENERATE_APPCONTENT.schedule(new TimerTask(){

            public void run() {
                app_content = null;
                LicUtils.resetBytes();
                FUNC.refreshFuntions();
            }
        }, 172800000L, 172800000L);
    }

    public static String generateAppContent() {
        if (app_content != null) {
            return app_content;
        }
        AppContentGenerator.initAppContent();
        return app_content;
    }

    private static void initAppContent() {
        String string = AppContentGenerator.getReportletsPath();
        try {
            ContentInfo contentInfo = new ContentInfo();
            AppContentGenerator.initProjectContentStr(string, contentInfo);
            String string2 = AppContentGenerator.getReduceProjectContentStr(contentInfo.getContent());
            app_content = DesUtils.encodeWithHex(string2 + contentInfo.getTotalSize());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public static String getReportletsPath() {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        String[] stringArray = new String[]{envProvider.getPath(), "reportlets"};
        return StableUtils.pathJoin(stringArray);
    }

    private static void initProjectContentStr(String string, ContentInfo contentInfo) throws Exception {
        File[] fileArray;
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            String string2 = file2.getName();
            if (file2.isDirectory()) {
                AppContentGenerator.initProjectContentStr(file2.getAbsolutePath(), contentInfo);
            }
            if (!file2.isFile()) continue;
            AppContentGenerator.appendFileContent(string2, contentInfo, file2);
        }
    }

    public static boolean invalidSuffix(String string) {
        return !string.endsWith(".cpt") && !string.endsWith(".frm");
    }

    private static void appendFileContent(String string, ContentInfo contentInfo, File file) throws Exception {
        if (AppContentGenerator.invalidSuffix(string)) {
            return;
        }
        contentInfo.append(string);
        contentInfo.add(file.length());
        String string2 = AppContentGenerator.getTheAppointedStr(file);
        if (StringUtils.isNotEmpty(string2)) {
            contentInfo.append(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getTheAppointedStr(File file) throws Exception {
        String string;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        block4: {
            String string2;
            block3: {
                inputStreamReader = new InputStreamReader(new FileInputStream(file));
                bufferedReader = new BufferedReader(inputStreamReader);
                string = "";
                int n2 = 0;
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        int n3;
                        if (++n2 < THIRTY || (n3 = Math.min(string.length(), THIRD)) <= 0) continue;
                        string2 = String.valueOf(string.charAt(n3 - 1));
                        Object var8_7 = null;
                        break block3;
                    }
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    bufferedReader.close();
                    inputStreamReader.close();
                    throw throwable;
                }
            }
            bufferedReader.close();
            inputStreamReader.close();
            return string2;
        }
        Object var8_8 = null;
        bufferedReader.close();
        inputStreamReader.close();
        return string;
    }

    public static void getStrPositions(int n2, int n3, IntList intList, int n4) {
        if (n4 != ITEARTOR_TIMES) {
            int n5 = (n2 + n3) / 2;
            intList.add(n5);
            intList.add(n5 - 1);
            intList.add(n5 + 1);
            AppContentGenerator.getStrPositions(n2, n5, intList, ++n4);
        }
    }

    public static String getReduceProjectContentStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        IntList intList = new IntList();
        int n2 = string.length();
        if (n2 < PROJECT_CONTENT_SIZE) {
            return stringBuffer.toString();
        }
        int n3 = n2 / 2;
        int n4 = 0;
        AppContentGenerator.getStrPositions(0, n3, intList, n4);
        AppContentGenerator.getStrPositions(n3, n2, intList, n4);
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            String string2 = String.valueOf(string.charAt(intList.get(i2)));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                if (SCHEDULE_GENERATE_APPCONTENT != null) {
                    SCHEDULE_GENERATE_APPCONTENT.cancel();
                    SCHEDULE_GENERATE_APPCONTENT = null;
                }
            }

            public void onServletStart() {
                AppContentGenerator.initTimer();
            }
        });
    }

    private static class ContentInfo {
        private StringBuffer content = new StringBuffer();
        private long totalSize = 0L;

        public String getContent() {
            return this.content.toString();
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void append(String string) {
            this.content.append(string);
        }

        public void add(long l2) {
            this.totalSize += l2;
        }
    }
}

