/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.tree;

import com.fr.json.JSONString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<T extends JSONString>
implements JSONString {
    private static final String CHILDREN_STR = "ChildNodes";
    private T value;
    private boolean valid = false;
    private LinkedList<Node<T>> children = new LinkedList();

    public Node(T t2) {
        this.value = t2;
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public void addChild(Node<T> node) {
        this.children.add(node);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid() {
        this.valid = true;
    }

    public void setAllValid() {
        this.setValid();
        for (Node<T> node : this.getChildren()) {
            node.setAllValid();
        }
    }

    public boolean hasValidChildren() {
        boolean bl = false;
        for (Node node : this.children) {
            if (!node.isValid()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T t2) {
        this.value = t2;
    }

    @Override
    public String toJSONString() {
        return this.toJSONString(CHILDREN_STR);
    }

    public String toJSONString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.value) {
            stringBuilder.append(this.value.toJSONString());
        } else {
            stringBuilder.append("{}");
        }
        if (this.hasValidChildren()) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(",\"" + string + "\": [");
            for (Node node : this.children) {
                if (!node.isValid()) continue;
                stringBuilder.append(node.toJSONString()).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("]}");
        }
        return stringBuilder.toString();
    }
}

