/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container.cardlayout;

import com.fr.form.ui.Label;
import com.fr.form.ui.container.WBorderLayout;
import com.fr.form.ui.container.cardlayout.CardNextTabButton;
import com.fr.form.ui.container.cardlayout.CardPreviousTabButton;
import com.fr.form.ui.container.cardlayout.WCardTagLayout;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.core.UUID;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class WCardTitleLayout
extends WBorderLayout {
    private static final int SWITCH_SIZE = 15;
    private static final int NORTH_SIZE = 5;
    private static final String XML_TAG = "CardTitleLayout";
    private static final String NAME_TAG = "layoutName";
    private static final int ADDBUTON_WIDTH = 25;
    private String cardName;
    private transient String preBtnName;
    private transient String nextBtnName;

    public WCardTitleLayout() {
        this("");
    }

    public WCardTitleLayout(String string) {
        this.cardName = string;
        this.setEastSize(25);
        this.preBtnName = UUID.randomUUID().toString();
        this.nextBtnName = UUID.randomUUID().toString();
        this.clearMargin();
    }

    public String getCardName() {
        return this.cardName;
    }

    public void setCardName(String string) {
        this.cardName = string;
    }

    public WCardTagLayout getTagPart() {
        return (WCardTagLayout)this.getLayoutWidget("Center");
    }

    public String getPreBtnName() {
        return this.preBtnName;
    }

    public String getNextBtnName() {
        return this.nextBtnName;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.initWebStyle();
        return super.createJSONConfig(repository, calculator, nodeVisitor);
    }

    private void initNorthSize() {
        this.setNorthSize(5);
        Label label = new Label();
        label.setBackground(this.getBackground());
        this.addNorth(label);
    }

    private void initEastSize() {
        this.setEastSize(15);
        CardNextTabButton cardNextTabButton = new CardNextTabButton(this.cardName);
        cardNextTabButton.setWidgetName(this.nextBtnName);
        this.addEast(cardNextTabButton);
    }

    private void initWestSize() {
        this.setWestSize(15);
        CardPreviousTabButton cardPreviousTabButton = new CardPreviousTabButton(this.cardName);
        cardPreviousTabButton.setWidgetName(this.preBtnName);
        this.addWest(cardPreviousTabButton);
    }

    private void initWebStyle() {
        this.initNorthSize();
        this.initEastSize();
        this.initWestSize();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty(this.cardName)) {
            xMLPrintWriter.attr(NAME_TAG, this.cardName);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.cardName = xMLableReader.getAttrAsString(NAME_TAG, "");
        }
    }
}

