/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.base.ParameterMapNameSpace;
import com.fr.base.background.ColorBackground;
import com.fr.data.TableDataSource;
import com.fr.form.main.ExtraFormClassManager;
import com.fr.form.main.Form;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.parameter.FormSubmitButton;
import com.fr.form.ui.Label;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.container.WAbsoluteLayout;
import com.fr.general.ComparatorUtils;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.fun.MobileJSONProcessor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WParameterLayout
extends WAbsoluteLayout {
    private HashMap<String, String> nameTagMap = new HashMap();
    private HashMap<String, Boolean> nameTagModified = new HashMap();
    private boolean delayDisplayContent = true;
    private boolean display = true;
    private int position = 0;
    private int design_width = 960;

    public WParameterLayout() {
        this.setBackground(ColorBackground.getInstance());
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean bl) {
        this.display = bl;
    }

    public boolean isDelayDisplayContent() {
        return this.delayDisplayContent;
    }

    public void setDelayDisplayContent(boolean bl) {
        this.delayDisplayContent = bl;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getDesignWidth() {
        return this.design_width;
    }

    public void setDesignWidth(int n2) {
        this.design_width = n2;
    }

    @Override
    public String getXType() {
        return "parameter";
    }

    @Override
    public Dimension getMinDesignSize() {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidgetCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)this.getWidget(i2);
            if (!boundsWidget.isVisible()) continue;
            Rectangle rectangle = boundsWidget.getBounds();
            n2 = rectangle.x + rectangle.width > n2 ? rectangle.x + rectangle.width : n2;
            n3 = rectangle.y + rectangle.height > n3 ? rectangle.y + rectangle.height : n3;
        }
        return new Dimension(n2, n3);
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("paraDisplay", this.display);
        jSONObject.put("delayDisplayContent", this.delayDisplayContent);
        jSONObject.put("position", this.asPositionString(this.position));
        jSONObject.put("width", this.design_width);
        jSONObject.put("parambg", jSONObject.opt("widgetBackground"));
        jSONObject.put("widgetBackground", "");
        return jSONObject;
    }

    private String asPositionString(int n2) {
        switch (n2) {
            case 2: {
                return "right";
            }
            case 1: {
                return "center";
            }
        }
        return "left";
    }

    public String[][] getWidgetNameTag() {
        this.refreshTagList();
        int n2 = this.getMobileWidgetListSize();
        String[][] stringArray = new String[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getMobileWidget(i2);
            String string2 = this.nameTagMap.get(string);
            stringArray[i2][1] = string;
            stringArray[i2][0] = string2 == null ? "" : string2;
        }
        return stringArray;
    }

    public void refreshTagList() {
        HashMap<Double, HashMap<Double, ArrayList<String>>> hashMap = new HashMap<Double, HashMap<Double, ArrayList<String>>>();
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)this.getWidget(i2);
            if (boundsWidget == null || this.shouldIgnoureSubmitButtonJSON(boundsWidget)) continue;
            this.initXYMap(boundsWidget, hashMap);
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray);
        if (!this.isSorted()) {
            this.clearMobileWidgetList();
        }
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            HashMap<Double, ArrayList<String>> hashMap2 = hashMap.get(objectArray[n2]);
            Object[] objectArray2 = hashMap2.keySet().toArray();
            Arrays.sort(objectArray2);
            int n4 = objectArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                ArrayList<String> arrayList = hashMap2.get(objectArray2[i3]);
                for (String string : arrayList) {
                    this.addToMobileList(string);
                    this.traversePreWidget(i3, hashMap2, objectArray2, string);
                }
            }
        }
        this.arrangeMobileWidgetList();
        this.arrangeNameTapMap();
    }

    private void arrangeMobileWidgetList() {
        Iterator<String> iterator = this.getMobileWidgetIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.getWidget(string) != null) continue;
            iterator.remove();
        }
    }

    private void arrangeNameTapMap() {
        Iterator<String> iterator = this.nameTagMap.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.isContainsMoibleWidget(string)) continue;
            arrayList.add(string);
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            this.nameTagMap.remove(arrayList.get(i2));
            if (!this.nameTagModified.containsKey(arrayList.get(i2))) continue;
            this.nameTagModified.remove(arrayList.get(i2));
        }
    }

    public void setNameTagModified(String string, Boolean bl) {
        if (!this.nameTagModified.containsKey(string)) {
            this.nameTagModified.put(string, bl);
        }
    }

    private boolean shouldIgnoureSubmitButtonJSON(WAbsoluteLayout.BoundsWidget boundsWidget) {
        MobileJSONProcessor mobileJSONProcessor = (MobileJSONProcessor)ExtraFormClassManager.getInstance().getSingle("MobileJSONProcessor");
        return boundsWidget.getWidget().acceptType(FormSubmitButton.class) && (mobileJSONProcessor == null || !mobileJSONProcessor.shouldCreateSubmitBtnJSON());
    }

    @Override
    public void addToMobileList(int n2, String string) {
        Widget widget = this.getWidget(string);
        if (widget == null || widget.acceptType(Label.class)) {
            return;
        }
        if (this.isContainsMoibleWidget(string)) {
            return;
        }
        if (n2 == -1) {
            this.addMobileWidget(string);
        } else if (n2 > this.getMobileWidgetListSize()) {
            this.addMobileWidget(this.getMobileWidgetListSize(), string);
        } else {
            this.addMobileWidget(n2, string);
        }
    }

    private void traversePreWidget(int n2, HashMap<Double, ArrayList<String>> hashMap, Object[] objectArray, final String string) {
        if (n2 == 0) {
            return;
        }
        if (this.nameTagModified.containsKey(string) && this.nameTagModified.get(string).booleanValue()) {
            return;
        }
        final String string2 = hashMap.get(objectArray[n2 - 1]).get(0);
        Form.traversalWidget(this, new WidgetGatherAdapter(){

            public void dealWith(Widget widget) {
                WidgetValue widgetValue;
                if (ComparatorUtils.equals(string2, widget.getWidgetName()) && StringUtils.isNotEmpty((widgetValue = ((Label)widget).getWidgetValue()).toString())) {
                    WParameterLayout.this.nameTagMap.put(string, widgetValue.toString());
                }
            }
        }, Label.class);
    }

    public void add2NameTagMap(String string, String string2) {
        if (StringUtils.isNotEmpty(string)) {
            this.nameTagMap.put(string2, string);
        } else if (this.nameTagMap.containsKey(string2)) {
            this.nameTagMap.remove(string2);
        }
    }

    private void initXYMap(WAbsoluteLayout.BoundsWidget boundsWidget, HashMap<Double, HashMap<Double, ArrayList<String>>> hashMap) {
        Rectangle rectangle = boundsWidget.getBounds();
        HashMap<Double, ArrayList<String>> hashMap2 = hashMap.get(rectangle.getY());
        if (hashMap2 != null) {
            ArrayList<String> arrayList = hashMap2.get(rectangle.getX());
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (!arrayList.contains(boundsWidget.getWidgetName())) {
                arrayList.add(boundsWidget.getWidgetName());
            }
            hashMap2.put(rectangle.getX(), arrayList);
            return;
        }
        hashMap2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(boundsWidget.getWidgetName());
        hashMap2.put(rectangle.getX(), arrayList);
        hashMap.put(rectangle.getY(), hashMap2);
    }

    private Calculator initCalculator(Repository repository, Form form) {
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
        sessionIDInfor.setAttribute("paramsheet", (Object)form);
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.KEY, (Object)sessionIDInfor.getTableDataSource());
        calculator.setAttribute(AbstractJavaScript.RECALCULATE_TAG, (Object)Boolean.TRUE);
        return calculator;
    }

    @Override
    public void createPara4Mobile(Repository repository, JSONObject jSONObject, Form form) throws JSONException {
        Calculator calculator = this.initCalculator(repository, form);
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor((String)repository.getSessionID());
        if (sessionIDInfor != null) {
            calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        }
        if (!form.initWidgetData(this, repository, calculator)) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("parameter", jSONArray);
        if (!jSONObject.has("delay")) {
            jSONObject.put("delay", this.delayDisplayContent);
        }
        if (!jSONObject.has("isShowWindow")) {
            jSONObject.put("isShowWindow", this.display);
        }
        String[][] stringArray = this.getWidgetNameTag();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject2 = new JSONObject();
            String string = stringArray[i2][0];
            String string2 = stringArray[i2][1];
            if (StringUtils.isNotEmpty(string)) {
                jSONObject2.put("label", string);
            }
            if (StringUtils.isNotEmpty(string2)) {
                JSONObject jSONObject3 = form.getWidgetByName(string2).createJSONConfig(repository, calculator, null);
                jSONObject2.put("widget", jSONObject3);
            }
            jSONArray.put(jSONObject2);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Display")) {
                this.setDisplay(xMLableReader.getAttrAsBoolean("display", true));
            } else if (string.equals("DelayDisplayContent")) {
                this.setDelayDisplayContent(xMLableReader.getAttrAsBoolean("delay", true));
            } else if (string.equals("Position")) {
                this.setPosition(xMLableReader.getAttrAsInt("position", 0));
            } else if (string.equals("Design_Width")) {
                this.setDesignWidth(xMLableReader.getAttrAsInt("design_width", 0));
            } else if (string.equals("NameTagModified")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("TagModified".equals(xMLableReader.getTagName())) {
                            WParameterLayout.this.nameTagModified.put(xMLableReader.getAttrAsString("tag", ""), xMLableReader.getAttrAsBoolean("modified", false));
                        }
                    }
                });
            } else if (string.equals("WidgetNameTagMap")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("NameTag".equals(xMLableReader.getTagName())) {
                            WParameterLayout.this.nameTagMap.put(xMLableReader.getAttrAsString("name", ""), xMLableReader.getAttrAsString("tag", ""));
                        }
                    }
                });
            }
        }
    }

    @Override
    protected void writeScalingAttrXML(XMLPrintWriter xMLPrintWriter) {
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Display").attr("display", this.display).end();
        xMLPrintWriter.startTAG("DelayDisplayContent").attr("delay", this.delayDisplayContent).end();
        xMLPrintWriter.startTAG("Position").attr("position", this.position).end();
        xMLPrintWriter.startTAG("Design_Width").attr("design_width", this.design_width).end();
        xMLPrintWriter.startTAG("NameTagModified");
        for (Map.Entry<String, Boolean> object : this.nameTagModified.entrySet()) {
            xMLPrintWriter.startTAG("TagModified").attr("tag", object.getKey()).attr("modified", object.getValue()).end();
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("WidgetNameTagMap");
        for (Map.Entry<String, String> entry : this.nameTagMap.entrySet()) {
            xMLPrintWriter.startTAG("NameTag").attr("name", entry.getKey()).attr("tag", entry.getValue()).end();
        }
        xMLPrintWriter.end();
    }
}

