/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.main.ExtraFormClassManager;
import com.fr.form.stable.FormWidgetBoundCorrectionProcessor;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WHorizontalBoxLayout;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;

public class WBorderLayout
extends WLayout {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String[] DEFAULT_DIRECTIONS = new String[]{"North", "South", "East", "West"};
    public static final int DEFAULT_SIZE = 65;
    private Widget north;
    private int northSize = 65;
    private String northTitle;
    private Widget south;
    private int southSize = 65;
    private String southTitle;
    private Widget east;
    private int eastSize = 65;
    private String eastTitle;
    private Widget west;
    private int westSize = 65;
    private String westTitle;
    private Widget center;
    private String centerTitle;
    private String[] directions;

    public WBorderLayout() {
        this(0, 0);
    }

    public WBorderLayout(String string) {
        this(0, 0);
        this.setWidgetName(string);
    }

    public WBorderLayout(int n2, int n3) {
        this(n2, n3, DEFAULT_DIRECTIONS);
    }

    public WBorderLayout(int n2, int n3, String[] stringArray) {
        this.setHgap(n2);
        this.setVgap(n3);
        this.directions = stringArray;
        this.clearMargin();
    }

    public String getXType() {
        return "border";
    }

    public String[] getDirections() {
        return this.directions == null ? ArrayUtils.EMPTY_STRING_ARRAY : this.directions;
    }

    public void setDirections(String[] stringArray) {
        this.directions = stringArray;
    }

    public void refreshDirections(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.directions = stringArray;
        if (ArrayUtils.indexOf(stringArray, NORTH) == -1) {
            this.north = null;
        }
        if (ArrayUtils.indexOf(stringArray, SOUTH) == -1) {
            this.south = null;
        }
        if (ArrayUtils.indexOf(stringArray, EAST) == -1) {
            this.east = null;
        }
        if (ArrayUtils.indexOf(stringArray, WEST) == -1) {
            this.west = null;
        }
    }

    public void addNorth(Widget widget) {
        this.north = widget;
    }

    public void addSouth(Widget widget) {
        this.south = widget;
    }

    public void addWest(Widget widget) {
        this.west = widget;
    }

    public void addEast(Widget widget) {
        this.east = widget;
    }

    public void addCenter(Widget widget) {
        this.center = widget;
    }

    public int getEastSize() {
        return ArrayUtils.contains(this.directions, EAST) ? this.eastSize : 0;
    }

    public void setEastSize(int n2) {
        this.eastSize = n2;
    }

    public int getNorthSize() {
        return ArrayUtils.contains(this.directions, NORTH) ? this.northSize : 0;
    }

    public void setNorthSize(int n2) {
        this.northSize = n2;
    }

    public int getSouthSize() {
        return ArrayUtils.contains(this.directions, SOUTH) ? this.southSize : 0;
    }

    public void setSouthSize(int n2) {
        this.southSize = n2;
    }

    public int getWestSize() {
        return ArrayUtils.contains(this.directions, WEST) ? this.westSize : 0;
    }

    public void setWestSize(int n2) {
        this.westSize = n2;
    }

    public String getCenterTitle() {
        return this.centerTitle;
    }

    public void setCenterTitle(String string) {
        this.centerTitle = string;
    }

    public String getEastTitle() {
        return this.eastTitle;
    }

    public void setEastTitle(String string) {
        this.eastTitle = string;
    }

    public String getNorthTitle() {
        return this.northTitle;
    }

    public void setNorthTitle(String string) {
        this.northTitle = string;
    }

    public String getSouthTitle() {
        return this.southTitle;
    }

    public void setSouthTitle(String string) {
        this.southTitle = string;
    }

    public String getWestTitle() {
        return this.westTitle;
    }

    public void setWestTitle(String string) {
        this.westTitle = string;
    }

    public Object getConstraints(Widget widget) {
        if (ComparatorUtils.equals(widget, this.north)) {
            return NORTH;
        }
        if (ComparatorUtils.equals(widget, this.south)) {
            return SOUTH;
        }
        if (ComparatorUtils.equals(widget, this.east)) {
            return EAST;
        }
        if (ComparatorUtils.equals(widget, this.west)) {
            return WEST;
        }
        if (ComparatorUtils.equals(widget, this.center)) {
            return CENTER;
        }
        return null;
    }

    public Widget getLayoutWidget(Object object) {
        if (ComparatorUtils.equals((Object)NORTH, object)) {
            return ArrayUtils.contains(this.directions, NORTH) ? this.north : null;
        }
        if (ComparatorUtils.equals((Object)SOUTH, object)) {
            return ArrayUtils.contains(this.directions, SOUTH) ? this.south : null;
        }
        if (ComparatorUtils.equals((Object)WEST, object)) {
            return ArrayUtils.contains(this.directions, WEST) ? this.west : null;
        }
        if (ComparatorUtils.equals((Object)EAST, object)) {
            return ArrayUtils.contains(this.directions, EAST) ? this.east : null;
        }
        return this.center;
    }

    public int getWidgetCount() {
        int n2 = 0;
        if (this.north != null) {
            ++n2;
        }
        if (this.south != null) {
            ++n2;
        }
        if (this.east != null) {
            ++n2;
        }
        if (this.west != null) {
            ++n2;
        }
        if (this.center != null) {
            ++n2;
        }
        return n2;
    }

    public Widget getWidget(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " is less than 0");
        }
        if (this.north != null && n2-- == 0) {
            return this.north;
        }
        if (this.south != null && n2-- == 0) {
            return this.south;
        }
        if (this.east != null && n2-- == 0) {
            return this.east;
        }
        if (this.west != null && n2-- == 0) {
            return this.west;
        }
        if (this.center != null && n2-- == 0) {
            return this.center;
        }
        throw new IndexOutOfBoundsException();
    }

    public void removeWidget(Widget widget) {
        if (ComparatorUtils.equals(this.north, widget)) {
            this.north = null;
        } else if (ComparatorUtils.equals(this.south, widget)) {
            this.south = null;
        } else if (ComparatorUtils.equals(this.east, widget)) {
            this.east = null;
        } else if (ComparatorUtils.equals(this.west, widget)) {
            this.west = null;
        } else if (ComparatorUtils.equals(this.center, widget)) {
            this.center = null;
        }
    }

    public void removeAll() {
        super.removeAll();
        this.north = null;
        this.south = null;
        this.east = null;
        this.west = null;
        this.center = null;
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("FR-Designer_WLayout-Border-ToolTips");
    }

    public Dimension getMinDesignSize() {
        Dimension dimension = this.center instanceof WLayout && this.center.isVisible() ? ((WLayout)this.center).getMinDesignSize() : new Dimension();
        return new Dimension(dimension.width + this.getWestSize() + this.getEastSize(), dimension.height + this.getNorthSize() + this.getSouthSize());
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject;
        JSONArray jSONArray = new JSONArray();
        if (this.north != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "north");
            jSONObject.put("height", this.getNorthSize());
            jSONObject.put("el", this.north.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        if (this.south != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "south");
            jSONObject.put("height", this.getSouthSize());
            jSONObject.put("el", this.south.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        if (this.east != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "east");
            jSONObject.put("width", this.getEastSize());
            jSONObject.put("el", this.east.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        if (this.west != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "west");
            jSONObject.put("width", this.getWestSize());
            jSONObject.put("el", this.west.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        jSONObject = new JSONObject();
        jSONObject.put("region", "center");
        jSONObject.put("el", this.center == null ? new WHorizontalBoxLayout().createJSONConfig(repository, calculator, nodeVisitor) : this.center.createJSONConfig(repository, calculator, nodeVisitor));
        jSONArray.put(jSONObject);
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(NORTH)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WBorderLayout.this.addNorth(WidgetXmlUtils.readWidget(xMLableReader));
                    }
                });
            } else if (string.equals("NorthAttr")) {
                this.setNorthSize(xMLableReader.getAttrAsInt("size", 65));
                this.setNorthTitle(xMLableReader.getAttrAsString("title", ""));
            } else if (string.equals(SOUTH)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WBorderLayout.this.addSouth(WidgetXmlUtils.readWidget(xMLableReader));
                    }
                });
            } else if (string.equals("SouthAttr")) {
                this.setSouthSize(xMLableReader.getAttrAsInt("size", 65));
                this.setSouthTitle(xMLableReader.getAttrAsString("title", ""));
            } else if (string.equals(EAST)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WBorderLayout.this.addEast(WidgetXmlUtils.readWidget(xMLableReader));
                    }
                });
            } else if (string.equals("EastAttr")) {
                this.setEastSize(xMLableReader.getAttrAsInt("size", 65));
                this.setEastTitle(xMLableReader.getAttrAsString("title", ""));
            } else if (string.equals(WEST)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WBorderLayout.this.addWest(WidgetXmlUtils.readWidget(xMLableReader));
                    }
                });
            } else if (string.equals("WestAttr")) {
                this.setWestSize(xMLableReader.getAttrAsInt("size", 65));
                this.setWestTitle(xMLableReader.getAttrAsString("title", ""));
            } else if (string.equals(CENTER)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        Widget widget = WidgetXmlUtils.readWidget(xMLableReader);
                        FormWidgetBoundCorrectionProcessor formWidgetBoundCorrectionProcessor = (FormWidgetBoundCorrectionProcessor)ExtraFormClassManager.getInstance().getSingle("FormWidgetBoundCorrectionProcessor");
                        if (null != formWidgetBoundCorrectionProcessor) {
                            formWidgetBoundCorrectionProcessor.processWidgetLocation(widget);
                        }
                        WBorderLayout.this.addCenter(widget);
                    }
                });
            } else if (string.equals("CenterAttr")) {
                this.setCenterTitle(xMLableReader.getAttrAsString("title", ""));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.widgetList.clear();
        super.writeXML(xMLPrintWriter);
        this.writeNorthSouth(xMLPrintWriter);
        this.writeEastWest(xMLPrintWriter);
        if (this.center != null) {
            if (StringUtils.isNotEmpty(this.centerTitle)) {
                xMLPrintWriter.startTAG("CenterAttr").attr("title", this.centerTitle).end();
            }
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.center, CENTER);
        }
    }

    private void writeNorthSouth(XMLPrintWriter xMLPrintWriter) {
        if (this.north != null) {
            xMLPrintWriter.startTAG("NorthAttr");
            if (this.northSize != 65) {
                xMLPrintWriter.attr("size", this.northSize);
            }
            if (StringUtils.isNotEmpty(this.northTitle)) {
                xMLPrintWriter.attr("title", this.northTitle);
            }
            xMLPrintWriter.end();
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.north, NORTH);
        }
        if (this.south != null) {
            xMLPrintWriter.startTAG("SouthAttr");
            if (this.southSize != 65) {
                xMLPrintWriter.attr("size", this.southSize);
            }
            if (StringUtils.isNotEmpty(this.southTitle)) {
                xMLPrintWriter.attr("title", this.southTitle);
            }
            xMLPrintWriter.end();
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.south, SOUTH);
        }
    }

    private void writeEastWest(XMLPrintWriter xMLPrintWriter) {
        if (this.west != null) {
            xMLPrintWriter.startTAG("WestAttr");
            if (this.westSize != 65) {
                xMLPrintWriter.attr("size", this.westSize);
            }
            if (StringUtils.isNotEmpty(this.westTitle)) {
                xMLPrintWriter.attr("title", this.westTitle);
            }
            xMLPrintWriter.end();
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.west, WEST);
        }
        if (this.east != null) {
            xMLPrintWriter.startTAG("EastAttr");
            if (this.eastSize != 65) {
                xMLPrintWriter.attr("size", this.eastSize);
            }
            if (StringUtils.isNotEmpty(this.eastTitle)) {
                xMLPrintWriter.attr("title", this.eastTitle);
            }
            xMLPrintWriter.end();
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.east, EAST);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WBorderLayout wBorderLayout = (WBorderLayout)super.clone();
        if (this.north != null) {
            wBorderLayout.north = (Widget)this.north.clone();
        }
        if (this.south != null) {
            wBorderLayout.south = (Widget)this.south.clone();
        }
        if (this.west != null) {
            wBorderLayout.west = (Widget)this.west.clone();
        }
        if (this.east != null) {
            wBorderLayout.east = (Widget)this.east.clone();
        }
        if (this.center != null) {
            wBorderLayout.center = (Widget)this.center.clone();
        }
        return wBorderLayout;
    }
}

