/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.main.Form;
import com.fr.form.ui.Connector;
import com.fr.form.ui.PaddingMargin;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WSortLayout;
import com.fr.form.ui.widget.CRBoundsWidget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRScreen;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;

public class WAbsoluteLayout
extends WSortLayout {
    public static final int STATE_FIT = 0;
    public static final int STATE_FIXED = 1;
    private static final double DEFAULT_SLIDER = 100.0;
    private static final Dimension DEFAULT_RESOLUTION = new Dimension(1440, 900);
    private static final Dimension DEFAULT_ABSOLUTE_LAYOUT_SIZE = new Dimension(0, 0);
    private int compState = 0;
    private Dimension designingResolution = DEFAULT_RESOLUTION;
    private ArrayList connectorList = new ArrayList();
    private boolean hasResize = false;

    public WAbsoluteLayout() {
        this.margin = new PaddingMargin(0, 0, 0, 0);
    }

    public WAbsoluteLayout(String string) {
        this();
        if (StringUtils.isNotEmpty(string)) {
            this.setWidgetName(string);
        }
    }

    public void setDesigningResolution(Dimension dimension) {
        this.designingResolution = dimension;
    }

    public Dimension getDesigningResolution() {
        return this.designingResolution;
    }

    public void setBounds(Widget widget, Rectangle rectangle) {
        CRBoundsWidget cRBoundsWidget = this.getBoundsWidget(widget);
        if (cRBoundsWidget != null) {
            cRBoundsWidget.setBounds(rectangle);
        }
    }

    public String getXType() {
        return "absolute";
    }

    public void addConnector(Connector connector) {
        this.connectorList.add(connector);
    }

    public int connectorCount() {
        return this.connectorList.size();
    }

    public void removeConnector(Connector connector) {
        this.connectorList.remove(connector);
    }

    public void clearLinkLine() {
        this.connectorList.clear();
    }

    public Connector getConnectorIndex(int n2) {
        return (Connector)this.connectorList.get(n2);
    }

    public Connector[] getConnector() {
        return this.connectorList.toArray(new Connector[0]);
    }

    public Connector[] getCoveredConnectors(Rectangle rectangle) {
        ArrayList<Connector> arrayList = new ArrayList<Connector>();
        for (int i2 = 0; i2 < this.connectorList.size(); ++i2) {
            Connector connector = (Connector)this.connectorList.get(i2);
            if (!connector.coveredByRectangle(rectangle)) continue;
            arrayList.add(connector);
        }
        return arrayList.toArray(new Connector[arrayList.size()]);
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("FR-Designer_WLayout-Absolute-ToolTips");
    }

    public CRBoundsWidget getBoundsWidget(Widget widget) {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            if (!ComparatorUtils.equals(cRBoundsWidget.getWidget(), widget)) continue;
            return cRBoundsWidget;
        }
        return null;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.margin = new PaddingMargin(0, 0, 0, 0);
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("absoluteCompState", this.compState);
        if (repository.getDevice().isMobile()) {
            return this.createMobileJSONConfig(jSONObject);
        }
        double d2 = FRScreen.getByDimension(this.getDesigningResolution()).getValue() / FRScreen.p1440.getValue();
        jSONObject.put("absoluteResolutionScaleW", d2);
        jSONObject.put("absoluteResolutionScaleH", d2);
        jSONObject.put("hasResize", this.hasResize);
        return jSONObject;
    }

    private JSONObject createMobileJSONConfig(JSONObject jSONObject) throws JSONException {
        jSONObject.put("designingResolutionW", this.getDesigningResolution().getWidth());
        jSONObject.put("designingResolutionH", this.getDesigningResolution().getHeight());
        return jSONObject;
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        Collections.reverse(this.widgetList);
        JSONArray jSONArray = super.createJSONItems(repository, calculator, nodeVisitor);
        Collections.reverse(this.widgetList);
        return jSONArray;
    }

    public Dimension getMinDesignSize() {
        return DEFAULT_ABSOLUTE_LAYOUT_SIZE;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("connector".equals(string)) {
                Connector connector = new Connector();
                xMLableReader.readXMLObject(connector);
                this.addConnector(connector);
            } else if ("WidgetScalingAttr".equals(string)) {
                this.setCompState(xMLableReader.getAttrAsInt("compState", 0));
            } else if ("DesignResolution".equals(string)) {
                this.setDesigningResolution(new Dimension(xMLableReader.getAttrAsInt("absoluteResolutionScaleW", WAbsoluteLayout.DEFAULT_RESOLUTION.width), xMLableReader.getAttrAsInt("absoluteResolutionScaleH", WAbsoluteLayout.DEFAULT_RESOLUTION.height)));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        this.writeScalingAttrXML(xMLPrintWriter);
        Connector[] connectorArray = this.getConnector();
        int n2 = connectorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("connector");
            connectorArray[i2].writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    protected void writeScalingAttrXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("WidgetScalingAttr").attr("compState", this.compState).end();
        xMLPrintWriter.startTAG("DesignResolution").attr("absoluteResolutionScaleW", this.designingResolution.width).attr("absoluteResolutionScaleH", this.designingResolution.height).end();
    }

    public int getCompState() {
        return this.compState;
    }

    public void setCompState(int n2) {
        this.compState = n2;
    }

    public void setCompVisible(Widget widget, JSONObject jSONObject, boolean bl, Form form, int n2, int n3) throws Exception {
        BoundsWidget boundsWidget = (BoundsWidget)this.getBoundsWidget(widget);
        boundsWidget.setBeforeScaleBounds(new Rectangle(boundsWidget.getBounds()));
        if (boundsWidget != null) {
            if (!bl) {
                Rectangle rectangle = boundsWidget.getBounds();
                boundsWidget.setBounds(new Rectangle(rectangle.x, rectangle.y, 0, 0));
                boundsWidget.setVisible(false);
                jSONObject.put("layout", "absolute");
            } else {
                boundsWidget.setBounds(boundsWidget.getBeforeScaleBounds());
                boundsWidget.setVisible(true);
                jSONObject.put("layout", "absolute");
            }
        }
    }

    public void resize(double d2, double d3, double d4) {
        d4 = d4 == 1.0 ? -1.0 : d4;
        super.resize(d2, d3, d4);
    }

    public boolean isHasResize() {
        return this.hasResize;
    }

    public void setHasResize(boolean bl) {
        this.hasResize = bl;
    }

    public void dealInvisible() throws Exception {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            BoundsWidget boundsWidget = (BoundsWidget)this.getWidget(i2);
            Widget widget = boundsWidget.getWidget();
            Rectangle rectangle = boundsWidget.getBounds();
            if (!widget.isVisible()) {
                boundsWidget.setBounds(new Rectangle(rectangle.x, rectangle.y, 0, 0));
                continue;
            }
            widget.dealInvisible();
        }
    }

    @Deprecated
    public static class BoundsWidget
    extends CRBoundsWidget {
        public BoundsWidget() {
        }

        public BoundsWidget(Widget widget, Rectangle rectangle) {
            super(widget, rectangle);
        }
    }
}

