/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.Utils;
import com.fr.form.ui.TextEditor;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.Nameable;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexWidget
implements XMLable,
Nameable {
    public static final String XML_TAG = "IndexWidget";
    private int index;
    private boolean clickShow = false;
    private Widget widget;

    public IndexWidget() {
        this(0, new TextEditor());
    }

    public IndexWidget(int n2, Widget widget) {
        this.index = n2;
        this.widget = widget;
    }

    public String getName() {
        return this.index + "";
    }

    public void setName(String string) {
        Number number;
        Pattern pattern = Pattern.compile("^0+[^\\.]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = string.substring(matcher.end() - 1);
        }
        if ((number = Utils.string2Number(string)) != null) {
            this.setIndex(number.intValue());
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        if (this.widget == null) {
            return null;
        }
        JSONObject jSONObject = this.widget.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("clickShow", this.clickShow);
        jSONObject.put("columnIndex", this.index - 1);
        return jSONObject;
    }

    public void setClickShow(boolean bl) {
        this.clickShow = bl;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    public void readXML(XMLableReader xMLableReader) {
        this.setIndex(xMLableReader.getAttrAsInt("index", 0));
        this.setClickShow(xMLableReader.getAttrAsBoolean("clickShow", false));
        if (xMLableReader.isChildNode()) {
            Object object = new Object();
            XMLObject xMLObject = new XMLObject(object){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && "Widget".equals(string = xMLableReader.getTagName())) {
                        this.obj = WidgetXmlUtils.readWidget(xMLableReader);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            this.setWidget((Widget)xMLObject.getObject());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("index", this.index).attr("clickShow", this.clickShow);
        GeneralXMLTools.writeXMLable(xMLPrintWriter, this.widget, "Widget");
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof IndexWidget && this.index == ((IndexWidget)object).index && this.clickShow == ((IndexWidget)object).clickShow && ComparatorUtils.equals(this.widget, ((IndexWidget)object).widget);
    }

    public Object clone() throws CloneNotSupportedException {
        IndexWidget indexWidget = (IndexWidget)super.clone();
        indexWidget.setIndex(this.index);
        indexWidget.setClickShow(this.clickShow);
        indexWidget.setWidget((Widget)this.widget.clone());
        return indexWidget;
    }
}

