/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.form.ui.AbstractMarginWidget;
import com.fr.form.ui.LayoutBorderStyle;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;

public abstract class AbstractBorderStyleWidget
extends AbstractMarginWidget {
    protected LayoutBorderStyle borderStyle = new LayoutBorderStyle();
    protected Background background;

    public abstract String getXType();

    public abstract boolean isEditor();

    public abstract String[] supportedEvents();

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public LayoutBorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(LayoutBorderStyle layoutBorderStyle) {
        this.borderStyle = layoutBorderStyle;
        this.setBackground(layoutBorderStyle.getBackground());
    }

    public void setBorderStyleNoBackground(LayoutBorderStyle layoutBorderStyle) {
        this.borderStyle = layoutBorderStyle;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.background != null) {
            if (repository.getDevice().isMobile()) {
                jSONObject.put("widgetBackground", this.background.toJSONObject());
            } else {
                jSONObject.put("widgetBackground", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            }
        }
        if (this.borderStyle != null) {
            this.borderStyle.createJSONConfig(repository, jSONObject);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Border".equals(string)) {
                final LayoutBorderStyle layoutBorderStyle = new LayoutBorderStyle();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        xMLableReader.readXMLObject(layoutBorderStyle);
                    }
                });
                this.setBorderStyle(layoutBorderStyle);
            } else if ("Background".equals(string)) {
                this.background = BaseXMLUtils.readBackground(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.borderStyle != null) {
            this.borderStyle.writeXML(xMLPrintWriter);
        }
        if (this.background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractBorderStyleWidget abstractBorderStyleWidget = (AbstractBorderStyleWidget)super.clone();
        if (this.background != null) {
            abstractBorderStyleWidget.background = (Background)this.background.clone();
        }
        abstractBorderStyleWidget.borderStyle = (LayoutBorderStyle)this.borderStyle.clone();
        return abstractBorderStyleWidget;
    }
}

