/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.base.ConfigManager;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class WebXmlConfigManager {
    private ConfigManager mgr;
    private File webXmlFile;
    private static final String servletClass = "com.fr.web.ReportServlet";
    private static boolean isBackUp = false;

    public WebXmlConfigManager(ConfigManager configManager, File file) {
        this.mgr = configManager;
        this.webXmlFile = file;
    }

    private void backUpWebXml() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.webXmlFile);
        FileOutputStream fileOutputStream = new FileOutputStream(this.webXmlFile + ".FR.bak");
        byte[] byArray = new byte[1024];
        int n2 = -1;
        while ((n2 = fileInputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n2);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public void saveServletMapping() throws IOException {
        String string = this.analysisServlet();
        this.ModifyServletMapping(string);
    }

    private void ModifyServletMapping(String string) throws IOException {
        if (string == null || StringUtils.isEmpty(string)) {
            return;
        }
        String string2 = this.mgr.getServletMapping();
        FileReader fileReader = new FileReader(this.webXmlFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string3 = null;
        String string4 = "";
        while ((string3 = bufferedReader.readLine()) != null) {
            string4 = string4 + string3;
            string4 = string4 + "\n";
        }
        StartEnd startEnd = new StartEnd(string2);
        this.getUrlPatternPosition(string4, string, startEnd, 0);
        if (startEnd.getStart() == -1 || startEnd.getEnd() == -1) {
            return;
        }
        if (!isBackUp) {
            this.backUpWebXml();
            isBackUp = true;
        }
        string4 = string4.substring(0, startEnd.getStart()) + "/" + string2 + string4.substring(startEnd.getEnd(), string4.length());
        bufferedReader.close();
        fileReader.close();
        FileOutputStream fileOutputStream = new FileOutputStream(this.webXmlFile);
        fileOutputStream.write(string4.getBytes());
        fileOutputStream.close();
    }

    private void getUrlPatternPosition(String string, String string2, StartEnd startEnd, int n2) {
        if (string.indexOf("<url-pattern>") != -1) {
            String string3 = string.substring(0, string.indexOf("<url-pattern>"));
            if (string3.lastIndexOf("<servlet-name>") != -1 && string3.lastIndexOf("</servlet-name>") != -1 && string3.substring(string3.lastIndexOf("<servlet-name>") + "<servlet-name>".length(), string3.lastIndexOf("</servlet-name>")).trim().equals(string2)) {
                if (!string.substring(string.indexOf("<url-pattern>") + "<url-pattern>".length(), string.indexOf("</url-pattern>")).trim().equals("/" + startEnd.getNewServletMap())) {
                    startEnd.setStart(n2 + string.indexOf("<url-pattern>") + "<url-pattern>".length());
                    startEnd.setEnd(n2 + string.indexOf("</url-pattern>"));
                }
                return;
            }
            n2 += string.substring(0, string.indexOf("</url-pattern>") + "</url-pattern>".length()).length();
            string = string.substring(string.indexOf("</url-pattern>") + "</url-pattern>".length());
            this.getUrlPatternPosition(string, string2, startEnd, n2);
        }
    }

    private String analysisServlet() throws IOException {
        FileReader fileReader = new FileReader(this.webXmlFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = null;
        String string2 = "";
        boolean bl = false;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
                if (string.indexOf(servletClass) == -1 || !string2.substring(string2.lastIndexOf("<servlet-class>") + "<servlet-class>".length(), string2.lastIndexOf("</servlet-class>") == -1 ? string2.length() : string2.lastIndexOf("</servlet-class>")).trim().equals(servletClass)) continue;
                bl = true;
                break;
            }
            bufferedReader.close();
            fileReader.close();
            if (!bl) {
                return null;
            }
            string2 = string2.substring(string2.lastIndexOf("<servlet-name>"), string2.lastIndexOf("</servlet-name>"));
            string2 = string2.substring("<servlet-name>".length());
        }
        catch (Exception exception) {
            return null;
        }
        return string2.trim();
    }

    private class StartEnd {
        private int start;
        private int end;
        private String newServletMap;

        public StartEnd(String string) {
            this.setNewServletMap(string);
            this.setStart(-1);
            this.setEnd(-1);
        }

        public void setStart(int n2) {
            this.start = n2;
        }

        public int getStart() {
            return this.start;
        }

        public void setEnd(int n2) {
            this.end = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public void setNewServletMap(String string) {
            this.newServletMap = string;
        }

        public String getNewServletMap() {
            return this.newServletMap;
        }
    }
}

