/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.cache.CacheConfiguration;
import com.fr.cache.CacheEventAdapter;
import com.fr.cache.CacheException;
import com.fr.cache.CacheProvider;
import com.fr.cache.FRCache;
import com.fr.cache.MemoryStore;
import com.fr.cache.Status;
import com.fr.cache.Unity;
import com.fr.cluster.rpc.RPC;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.BaseClusterHelper;
import com.fr.file.CacheManagerProvider;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.script.Calculator;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.EnvSignOutListener;
import com.fr.stable.ParameterProvider;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager
extends XMLFileManager
implements CacheProvider,
CacheManagerProvider {
    private static CacheManagerProvider cacheManager = null;
    private File cacheDirectory = null;
    private int maxMemSize = 0x400000;
    private CacheConfiguration dbConfig = new CacheConfiguration();
    private CacheConfiguration cptConfig = new CacheConfiguration();
    private Thread shutdownHook;
    private Status status = Status.STATUS_ALIVE;
    private FRCache db_cache = this.createDBCache();
    private boolean alwaysReloadTpl = true;

    public static synchronized CacheManager getInstance() {
        return (CacheManager)CacheManager.getProviderInstance();
    }

    public static synchronized CacheManagerProvider getProviderInstance() {
        if (cacheManager == null) {
            if (CacheManager.isClusterMember()) {
                return cacheManager;
            }
            cacheManager.readXMLFile();
        }
        return cacheManager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                cacheManager = new CacheManager();
                RPC.registerSkeleton(cacheManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                cacheManager = (CacheManagerProvider)RPC.getProxy(CacheManager.class, string);
                return true;
            }
        }
        cacheManager = new CacheManager();
        return false;
    }

    @Override
    public void readFromInputStream(InputStream inputStream) throws Exception {
        CacheManager cacheManager = new CacheManager();
        XMLTools.readInputStreamXML(cacheManager, inputStream);
        CacheManager.cacheManager = cacheManager;
        GeneralContext.getEnvProvider().writeResource(CacheManager.cacheManager);
    }

    private static synchronized void envChanged() {
        cacheManager = null;
    }

    private CacheManager() {
    }

    @Override
    public void doWhenSignOutEnv() {
        StableUtils.deleteFile(new File(StableUtils.pathJoin(this.getCacheDirectory().getPath(), "ServerSvgs")));
    }

    @Override
    public String fileName() {
        return "cache.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractDBDataModel get(Connection connection, String string, long l2) {
        AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)this.db_cache.getObject(new DBKey(connection, string));
        if (abstractDBDataModel != null && abstractDBDataModel.isCheckRowOver()) {
            FRLogger.getLogger().info(Inter.getLocText("FR-Engine_getDataFromCache") + string);
        } else {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                FRLogger.getLogger().info("SQL: " + string);
                abstractDBDataModel = DBTableData.createCacheableDBResultSet(connection, string, l2);
                this.db_cache.put(new DBKey(connection, string), abstractDBDataModel);
            }
        }
        return abstractDBDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getProcedureDataModel(Connection connection, String string, Object object, CalculatorProvider calculatorProvider) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            DBKey4Procedure dBKey4Procedure = new DBKey4Procedure(connection, string, this.createStoreProcedureParas((StoreProcedure)object, calculatorProvider));
            Object[] objectArray = (ProcedureDataModel[])this.db_cache.getObject(dBKey4Procedure);
            if (objectArray != null && objectArray.length > 0) {
                FRLogger.getLogger().info(Inter.getLocText("FR-Engine_getDataFromCache") + string);
                return objectArray;
            }
            FRLogger.getLogger().info("SQL: " + string);
            objectArray = ((StoreProcedure)object).creatCacheableDataModel(calculatorProvider, true);
            this.db_cache.put(new DBKey4Procedure(connection, string, this.createStoreProcedureParas((StoreProcedure)object, calculatorProvider)), objectArray);
            return objectArray;
        }
    }

    private Map<String, Object> createStoreProcedureParas(StoreProcedure storeProcedure, CalculatorProvider calculatorProvider) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (storeProcedure != null) {
            Parameter[] parameterArray;
            ParameterProvider[] parameterProviderArray = storeProcedure.get_IN_Parameters();
            for (Parameter parameter : parameterArray = Parameter.providers2Parameter(Calculator.processParameters(calculatorProvider, parameterProviderArray))) {
                String string = parameter.getName();
                Object object = parameter.getValue();
                if (StableUtils.canBeFormula(object)) {
                    try {
                        hashMap.put(string.toString(), calculatorProvider.eval(object.toString()));
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                    continue;
                }
                hashMap.put(string.toString(), object);
            }
        }
        return hashMap;
    }

    @Override
    public File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = this.getApplicationDefaultCacheFolder();
            try {
                StableUtils.mkdirs(this.cacheDirectory);
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't create or access the directory: " + this.cacheDirectory + ", please check your Permissions.", exception);
            }
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    private void setCacheDirectory(File file) {
        this.cacheDirectory = file;
    }

    @Override
    public int getMaxMemSize() {
        return this.maxMemSize;
    }

    @Override
    public void setMaxMemSize(int n2) {
        this.maxMemSize = n2;
    }

    @Override
    public CacheConfiguration getDbConfig() {
        return this.dbConfig;
    }

    @Override
    public void setDbConfig(CacheConfiguration cacheConfiguration) {
        this.dbConfig = cacheConfiguration;
    }

    @Override
    public CacheConfiguration getCptConfig() {
        return this.cptConfig;
    }

    @Override
    public void setAlwaysReloadTpl(boolean bl) {
        this.alwaysReloadTpl = bl;
    }

    @Override
    public boolean isAlwaysReloadTpl() {
        return this.alwaysReloadTpl;
    }

    @Override
    public FRCache createDBCache() {
        final FRCache fRCache = new FRCache(this.dbConfig);
        fRCache.getCacheEventNotificationService().registerListener(new CacheEventAdapter(){

            public void notifyElementRemoved(FRCache fRCache2, Unity unity) throws CacheException {
                Object object = unity.getObjectValue();
                if (object instanceof AbstractDBDataModel) {
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }

            public void notifyElementExpired(FRCache fRCache2, Unity unity) {
                Object object = unity.getObjectValue();
                if (object instanceof AbstractDBDataModel) {
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }

            public void dispose() {
                MemoryStore memoryStore = fRCache.getStore();
                Object[] objectArray = memoryStore.getKeyArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Unity unity = memoryStore.get(objectArray[i2]);
                    Object object = unity.getObjectValue();
                    if (!(object instanceof AbstractDBDataModel)) continue;
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }
        });
        return fRCache;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("Basic".equals(string)) {
                String string3 = xMLableReader.getAttrAsString("cacheDirectory", null);
                if (string3 != null) {
                    this.setCacheDirectory(new File(string3));
                }
                if ((string3 = xMLableReader.getAttrAsString("maxMemSize", null)) != null) {
                    this.setMaxMemSize(Integer.parseInt(string3));
                }
            } else if ("DBConfig".equals(string)) {
                if (this.dbConfig == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getDbConfig());
                }
            } else if ("AlwaysReloadTpl".equals(string)) {
                this.setAlwaysReloadTpl(Boolean.valueOf(xMLableReader.getElementValue()));
            } else if ("CPTConfig".equals(string)) {
                if (this.getCptConfig() == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getCptConfig());
                }
            }
        }
    }

    private File getApplicationDefaultCacheFolder() {
        return new File(ProductConstants.getEnvHome(), "cache");
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CacheParameters");
        xMLPrintWriter.startTAG("Basic");
        if (!this.getApplicationDefaultCacheFolder().equals(this.cacheDirectory)) {
            xMLPrintWriter.attr("cacheDirectory", this.getCacheDirectory().getAbsolutePath());
        }
        xMLPrintWriter.attr("maxMemSize", this.getMaxMemSize());
        xMLPrintWriter.end();
        if (this.dbConfig != null) {
            xMLPrintWriter.startTAG("DBConfig");
            this.dbConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.cptConfig != null) {
            xMLPrintWriter.startTAG("CPTConfig");
            this.cptConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("AlwaysReloadTpl").textNode(String.valueOf(this.isAlwaysReloadTpl())).end();
        xMLPrintWriter.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (ComparatorUtils.equals(this.status, Status.STATUS_SHUTDOWN)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.db_cache != null) {
                this.db_cache.dispose();
            }
            StableUtils.deleteFile(this.cacheDirectory);
            this.status = Status.STATUS_SHUTDOWN;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource(CacheManager.getProviderInstance());
    }

    public static void reinit() {
        CacheManager.envChanged();
        CacheManager.getProviderInstance();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CacheManager.envChanged();
            }
        });
        GeneralContext.addEnvSignOutListener(new EnvSignOutListener(){

            public void envExited() {
                CacheManager.getProviderInstance().doWhenSignOutEnv();
            }
        });
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                if (cacheManager != null) {
                    cacheManager.shutdown();
                }
            }
        });
    }

    private static interface PoolKey
    extends Serializable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DBKey4Procedure
    extends DBKey {
        private Map<String, Object> paraValues = new HashMap<String, Object>();

        public DBKey4Procedure(Connection connection, String string, Map<String, Object> map) {
            super(connection, string);
            this.paraValues = map;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.paraValues.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DBKey4Procedure && ComparatorUtils.equals(((DBKey4Procedure)object).database, this.database) && ComparatorUtils.equals(((DBKey4Procedure)object).query, this.query) && this.isParaValueMatched(((DBKey4Procedure)object).paraValues);
        }

        private boolean isParaValueMatched(Map<String, Object> map) {
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (ComparatorUtils.equals(this.paraValues.get(entry.getKey()), entry.getValue())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class DBKey
    implements PoolKey {
        protected Connection database;
        protected String query;

        public DBKey(Connection connection, String string) {
            this.database = connection;
            this.query = string;
        }

        public int hashCode() {
            return this.database.hashCode() + this.query.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof DBKey && ComparatorUtils.equals(((DBKey)object).database, this.database) && ComparatorUtils.equals(((DBKey)object).query, this.query);
        }
    }
}

