/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.load;

import com.fr.data.load.LazyExecutionCondition;
import com.fr.data.load.LazyExecutionException;
import com.fr.data.load.LazyExecutionJob;
import com.fr.general.FRLogger;
import java.util.LinkedList;
import java.util.List;

public class LazyExecutionManager {
    private static List<LazyExecutionJob> lazyExecutionJobList = new LinkedList<LazyExecutionJob>();

    public static void addJob(LazyExecutionJob lazyExecutionJob) {
        LazyExecutionManager.addJob(lazyExecutionJob, LazyExecutionCondition.PRIVILEGE);
    }

    public static void addJob(LazyExecutionJob lazyExecutionJob, LazyExecutionCondition lazyExecutionCondition) {
        if (lazyExecutionCondition.willRunLater()) {
            lazyExecutionJobList.add(lazyExecutionJob);
        } else {
            try {
                lazyExecutionJob.waitForRun();
            }
            catch (LazyExecutionException lazyExecutionException) {
                FRLogger.getLogger().error(lazyExecutionException.getMessage(), lazyExecutionException);
            }
        }
    }

    public static void executeJobQueue() throws LazyExecutionException {
        int n2 = lazyExecutionJobList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            LazyExecutionJob lazyExecutionJob = lazyExecutionJobList.get(i2);
            lazyExecutionJob.waitForRun();
        }
        lazyExecutionJobList.clear();
    }
}

