/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.index;

import com.fr.data.index.AbstractIndex;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.data.index.IndexException;
import java.util.Arrays;

public class BinarySearchIndex
extends AbstractIndex {
    public BinarySearchIndex() {
    }

    public BinarySearchIndex(DataModel dataModel, int n2) {
        super(dataModel, n2);
    }

    public void buildIndex() throws IndexException {
        try {
            this.extractIndex();
            this.sort();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (TableDataException tableDataException) {
            throw new IndexException(tableDataException.getMessage(), tableDataException);
        }
    }

    private void sort() {
        Arrays.sort(this.indexes, this.entryComparator);
    }

    protected int search(Object object) {
        int n2 = Arrays.binarySearch(this.indexes, object, this.entryComparator);
        if (this.isValid(n2)) {
            return this.indexes[n2].row;
        }
        return -1;
    }

    protected int[] searchAll(Object object) {
        int n2 = Arrays.binarySearch(this.indexes, object, this.entryComparator);
        if (!this.isValid(n2)) {
            return new int[0];
        }
        int n3 = this.findBegin(object, n2);
        int n4 = this.findEnd(object, n2);
        return this.getRowsByRange(n3, n4);
    }

    private int[] getRowsByRange(int n2, int n3) {
        int[] nArray = new int[n3 - n2 + 1];
        for (int i2 = n2; i2 <= n3; ++i2) {
            nArray[i2 - n2] = this.indexes[i2].row;
        }
        return nArray;
    }

    private int findBegin(Object object, int n2) {
        return this.findSideRow(object, n2, -1);
    }

    private int findEnd(Object object, int n2) {
        return this.findSideRow(object, n2, 1);
    }

    private int findSideRow(Object object, int n2, int n3) {
        int n4 = n2;
        while (this.isValid(n4 + n3) && this.entryComparator.compare(object, this.indexes[n4 + n3]) == 0) {
            n4 += n3;
        }
        return n4;
    }

    private boolean isValid(int n2) {
        return n2 >= 0 && n2 < this.indexes.length;
    }
}

