/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.storeproc;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.StoreProcedureParameter;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.Oracle10gDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.Connection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.storeproc.DiskCacheProcereDataModel;
import com.fr.data.impl.storeproc.MemCachedProcedureDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.performance.PerformanceManager;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoreProcedure
extends AbstractParameterTableData
implements XMLable {
    private static final int PARAMETER_PROPERTY_COUNT = 4;
    public static final String XML_TAG = "StoreProcedure";
    public static final String SPLIT = "_";
    private List dataModelList = new ArrayList();
    private boolean share = false;
    private int maxMemRowCount = -1;
    private String query;
    private StoreProcedureParameter[] parameters = new StoreProcedureParameter[0];
    private ArrayList resultNames = new ArrayList();
    private transient java.sql.Connection connection;
    private transient CallableStatement statement;
    private Connection database;
    private boolean isCalculating;
    private boolean isFirstExpand = true;
    private static final int MAX_IGNORE_COUNT = 100;
    private static final long serialVersionUID = 1L;

    public static StoreProcedureParameter[] getSortPara(StoreProcedureParameter[] storeProcedureParameterArray) {
        int n2;
        int n3 = storeProcedureParameterArray.length;
        StoreProcedureParameter[] storeProcedureParameterArray2 = new StoreProcedureParameter[n3];
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = storeProcedureParameterArray[n2].getName();
        }
        Arrays.sort(stringArray, Collator.getInstance(Locale.CHINA));
        block1: for (n2 = 0; n2 < n3; ++n2) {
            String string = stringArray[n2];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!ComparatorUtils.equals(string, storeProcedureParameterArray[i2].getName())) continue;
                storeProcedureParameterArray2[n2] = storeProcedureParameterArray[i2];
                continue block1;
            }
        }
        return storeProcedureParameterArray2;
    }

    public void setCalculating(boolean bl) {
        this.isCalculating = bl;
    }

    public boolean isCalculating() {
        return this.isCalculating;
    }

    public String[] getStoreProcedureColumnNames(Calculator calculator, String string) {
        ProcedureDataModel procedureDataModel = this.getProcedureDataModel(calculator, string);
        if (procedureDataModel != null) {
            return procedureDataModel.getColumnName();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public ArrayList getResultNames() {
        return this.resultNames;
    }

    public ProcedureDataModel getProcedureDataModel(Calculator calculator, String string) {
        string = string.substring(string.indexOf(SPLIT) + 1);
        ProcedureDataModel[] procedureDataModelArray = this.creatDataModel(calculator);
        int n2 = procedureDataModelArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(string, procedureDataModelArray[i2].getName())) continue;
            return procedureDataModelArray[i2];
        }
        return procedureDataModelArray[0];
    }

    public int getDataModelSize() {
        return this.dataModelList.size();
    }

    public void resetDataModelList() {
        this.dataModelList.clear();
    }

    public ProcedureDataModel[] creatLazyDataModel() {
        return this.dataModelList.toArray(new ProcedureDataModel[this.dataModelList.size()]);
    }

    public ProcedureDataModel[] creatDataModel(Calculator calculator) {
        if (this.isShareTableData()) {
            return (ProcedureDataModel[])ManagerFactory.getCacheProvider().getProcedureDataModel(this.database, this.query, this, calculator);
        }
        return this.creatCacheableDataModel(calculator);
    }

    public ProcedureDataModel[] creatCacheableDataModel(CalculatorProvider calculatorProvider) {
        try {
            this.prepareCall(calculatorProvider);
            return this.creatDataModels(false);
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        this.release();
        return new ProcedureDataModel[0];
    }

    public ProcedureDataModel[] creatCacheableDataModel(CalculatorProvider calculatorProvider, boolean bl) {
        try {
            this.prepareCall(calculatorProvider);
            return this.creatDataModels(bl);
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        this.release();
        return new ProcedureDataModel[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCall(CalculatorProvider calculatorProvider) throws SQLException, TableDataException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            try {
                this.connection = this.database.createConnection();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                return;
            }
            if (this.query == null) {
                return;
            }
            Dialect dialect = DialectFactory.generateDialect(this.connection);
            Parameter[] parameterArray = Parameter.providers2Parameter(this.processParameters(calculatorProvider, this.parameters));
            String string = this.getNewQuery(dialect, parameterArray);
            this.statement = this.connection.prepareCall(string);
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                StoreProcedureParameter storeProcedureParameter = this.parameters[i2];
                SQLTypeHandler sQLTypeHandler = dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(storeProcedureParameter.getType()));
                if (storeProcedureParameter.getSchema() != 0x7FFFFFFD) {
                    try {
                        sQLTypeHandler.setValue(this.statement, i2 + 1, this.calculateHandlerValue(parameterArray[i2].getValue(), calculatorProvider), storeProcedureParameter.getType());
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                if (storeProcedureParameter.getSchema() == 0x7FFFFFFE) continue;
                this.statement.registerOutParameter(i2 + 1, storeProcedureParameter.getType());
            }
            this.statement.executeQuery();
            FRLogger.getLogger().info("SQL:\n" + string);
            this.dataModelList.clear();
        }
    }

    private ParameterProvider[] processParameters(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray) {
        if (parameterProviderArray == null) {
            return new ParameterProvider[0];
        }
        ParameterProvider[] parameterProviderArray2 = new ParameterProvider[parameterProviderArray.length];
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            parameterProviderArray2[i2] = parameterProviderArray[i2];
            if (parameterProviderArray2[i2] == null || calculatorProvider == null) continue;
            Object object = calculatorProvider.resolveVariable(parameterProviderArray2[i2].getName());
            if (object == null || object == Primitive.NULL) {
                object = calculatorProvider.resolveVariable(parameterProviderArray2[i2].getValue());
            }
            try {
                parameterProviderArray2[i2] = (ParameterProvider)parameterProviderArray2[i2].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            if (object == null || ((StoreProcedureParameter)parameterProviderArray2[i2]).getType() == 31) continue;
            parameterProviderArray2[i2].setValue(object);
        }
        return parameterProviderArray2;
    }

    private Object calculateHandlerValue(Object object, CalculatorProvider calculatorProvider) throws UtilEvalError {
        if (object instanceof FormulaProvider) {
            return this.calFormula(calculatorProvider, (FormulaProvider)object);
        }
        if (object instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(object);
        }
        return object;
    }

    private Object calFormula(CalculatorProvider calculatorProvider, FormulaProvider formulaProvider) throws UtilEvalError {
        Object object = calculatorProvider.eval(formulaProvider);
        if (object != null && object != Primitive.NULL) {
            return object;
        }
        return formulaProvider.getResult();
    }

    private String getNewQuery(Dialect dialect, Parameter[] parameterArray) {
        return ParameterHelper.analyzeCurrentContextTableData4Templatee(this.getCallQuery(dialect, parameterArray.length), parameterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcedureDataModel[] creatDataModels(boolean bl) throws TableDataException, SQLException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            int n2;
            if (this.statement == null) {
                return null;
            }
            String string = this.database.getOriginalCharsetName();
            String string2 = this.database.getNewCharsetName();
            boolean bl2 = DialectFactory.generateDialect(this.connection) instanceof Oracle10gDialect;
            ResultSet resultSet = this.statement.getResultSet();
            if (resultSet != null) {
                this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl2, "Table", string2, string, bl));
                n2 = 0;
                while (this.statement.getMoreResults()) {
                    resultSet = this.statement.getResultSet();
                    this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl2, "Table" + ++n2, string2, string, bl));
                }
            }
            for (n2 = 0; n2 < this.parameters.length; ++n2) {
                StoreProcedureParameter storeProcedureParameter = this.parameters[n2];
                if (storeProcedureParameter.getSchema() == 0x7FFFFFFE) continue;
                Object object = this.statement.getObject(n2 + 1);
                if (object instanceof ResultSet) {
                    resultSet = (ResultSet)object;
                    this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl2, storeProcedureParameter.getName(), string2, string, bl));
                    continue;
                }
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
                arrayList.add(new Object[]{object});
                this.dataModelList.add(new MemCachedProcedureDataModel(arrayList, new String[]{storeProcedureParameter.getName()}, storeProcedureParameter.getName()));
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeConnection(this.connection);
            DBUtils.closeStatement(this.statement);
            return this.dataModelList.toArray(new ProcedureDataModel[this.dataModelList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcedureDataModel createDataModeByResultSet(ResultSet resultSet, boolean bl, String string, String string2, String string3, boolean bl2) throws SQLException, TableDataException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            if (!this.resultNames.contains(string) && !bl) {
                this.resultNames.add(string);
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            List list = this.createRowList(resultSet, resultSetMetaData, bl, string2, string3);
            if (this.maxMemRowCount > 0 && list.size() > this.maxMemRowCount) {
                return new DiskCacheProcereDataModel(list, this.creatColumnName(resultSetMetaData), string);
            }
            return new MemCachedProcedureDataModel(list, this.creatColumnName(resultSetMetaData), string, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createRowList(ResultSet resultSet, ResultSetMetaData resultSetMetaData, boolean bl, String string, String string2) throws TableDataException, SQLException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            int n2 = resultSetMetaData.getColumnCount();
            try {
                int n3;
                int[] nArray = new int[n2];
                if (resultSetMetaData != null) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        nArray[n3] = resultSetMetaData.getColumnType(n3 + 1);
                    }
                }
                n3 = 1;
                long l2 = 0L;
                long l3 = 0L;
                int n4 = 0;
                while (true) {
                    long l4 = System.nanoTime();
                    if (!resultSet.next()) break;
                    long l5 = System.nanoTime();
                    if (n3 == 0) {
                        l2 += l5 - l4;
                    } else {
                        PerformanceManager.getRecorder().recordSqlExecuteTime(l5 - l4);
                        n3 = 0;
                    }
                    Object[] objectArray = new Object[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        try {
                            objectArray[i2] = bl ? (nArray[i2] == 91 ? resultSet.getTimestamp(i2 + 1) : resultSet.getObject(i2 + 1)) : resultSet.getObject(i2 + 1);
                            boolean bl2 = StringUtils.isNotEmpty(string2);
                            if (!bl2 || !(objectArray[i2] instanceof String)) continue;
                            objectArray[i2] = DBUtils.changeCharset((String)objectArray[i2], string2, string);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            objectArray[i2] = null;
                        }
                    }
                    arrayList.add(objectArray);
                    long l6 = System.nanoTime();
                    l3 += l6 - l5;
                    if (n4 > 100) {
                        PerformanceManager.getRuntimeMonitor().addMemoryAndCheck(n2 * 100 * 65);
                        n4 = 0;
                        continue;
                    }
                    ++n4;
                }
                PerformanceManager.getRecorder().recordTransferTime(l2);
                PerformanceManager.getRecorder().recordBuildDataTime(l3);
            }
            catch (Exception exception) {
                try {
                    this.release();
                }
                catch (Exception exception2) {
                    FRLogger.getLogger().error("Error happens while releaseConnection");
                }
                if (exception.getCause() != null) {
                    FRLogger.getLogger().error("Caused By:" + exception.getCause().getMessage(), exception.getCause());
                }
                throw new TableDataException(exception.getMessage(), exception);
            }
            return arrayList;
        }
    }

    public boolean isFirstExpand() {
        return this.isFirstExpand;
    }

    public void setFirstExpand(boolean bl) {
        this.isFirstExpand = bl;
    }

    private String[] creatColumnName(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = resultSetMetaData.getColumnName(i2 + 1);
            String string2 = ComparatorUtils.equals(string, "") ? "Column" + (i2 == 0 ? "" : String.valueOf(i2)) : (stringArray[i2] = string);
            stringArray[i2] = ComparatorUtils.equals(string, "") ? "Column" + (i2 == 0 ? "" : String.valueOf(i2)) : string;
        }
        return stringArray;
    }

    public void release() {
        DBUtils.closeStatement(this.statement);
        DBUtils.closeConnection(this.connection);
    }

    public Connection getDatabaseConnection() {
        return this.database;
    }

    public void setDatabaseConnection(Connection connection) {
        this.database = connection;
    }

    private Table initTable() {
        String[] stringArray = this.query.split("\\.");
        if (ArrayUtils.getLength(stringArray) <= 1) {
            return new Table(stringArray[0]);
        }
        return new Table(stringArray[stringArray.length - 2], stringArray[stringArray.length - 1]);
    }

    private String getCallQuery(Dialect dialect, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{call ");
        Table table = this.initTable();
        stringBuffer.append(dialect.table2SQL(table) + "(");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('?');
            if (i2 == n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public StoreProcedureParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public ParameterProvider[] getParameters(Calculator calculator) {
        return this.parameters;
    }

    public void setParameters(StoreProcedureParameter[] storeProcedureParameterArray) {
        this.parameters = storeProcedureParameterArray;
    }

    public StoreProcedureParameter[] get_IN_Parameters() {
        StoreProcedureParameter[] storeProcedureParameterArray = new StoreProcedureParameter[]{};
        int n2 = this.parameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parameters[i2].getSchema() == 0x7FFFFFFD) continue;
            storeProcedureParameterArray = ArrayUtils.add(storeProcedureParameterArray, this.parameters[i2]);
        }
        return storeProcedureParameterArray;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean isShareTableData() {
        return this.share;
    }

    public int getMaxMemRowCount() {
        return this.maxMemRowCount;
    }

    public void setMaxMemRowCount(int n2) {
        this.maxMemRowCount = n2;
    }

    @Override
    public void registerNoPrivilege(ArrayList<String> arrayList, String string, String string2) {
        String string3;
        Connection connection = this.getDatabaseConnection();
        if (connection instanceof NameDatabaseConnection && ComparatorUtils.equals(string, string3 = ((NameDatabaseConnection)connection).getName())) {
            arrayList.add(string2);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.setShare(xMLableReader.getAttrAsBoolean("share", false));
                this.setMaxMemRowCount(xMLableReader.getAttrAsInt("maxMemRowCount", -1));
            }
            if ("Connection".equals(string)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                    this.setDatabaseConnection(connection);
                }
            } else if ("Query".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setQuery(string2);
                }
            } else if ("ParamterList".equals(string)) {
                this.readParameters(xMLableReader);
            } else if ("ResultNames".equals(string)) {
                this.readResultNames(xMLableReader);
            }
        }
    }

    private void readResultNames(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                String string2;
                if (xMLableReader.isAttr()) {
                    StoreProcedure.this.resultNames.clear();
                }
                if (xMLableReader.isChildNode() && "Name".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
                    StoreProcedure.this.resultNames.add(string);
                }
            }
        });
    }

    private void readParameters(XMLableReader xMLableReader) {
        Object object;
        if (xMLableReader.getXMLVersion().isBefore711_FOR_STOREPROCEDURE_PARA() && (object = xMLableReader.getElementValue()) != null) {
            this.setParameterList((String)object);
            return;
        }
        object = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable((ArrayList)object){
            final /* synthetic */ ArrayList val$list;
            {
                this.val$list = arrayList;
            }

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.getTagName().equals("para")) {
                    StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter();
                    xMLableReader.readXMLObject(storeProcedureParameter);
                    this.val$list.add(storeProcedureParameter);
                }
            }
        });
        this.parameters = ((ArrayList)object).toArray(new StoreProcedureParameter[((ArrayList)object).size()]);
    }

    private void setParameterList(String string) {
        String[] stringArray = string.split("]");
        StoreProcedureParameter[] storeProcedureParameterArray = new StoreProcedureParameter[stringArray.length / 4];
        for (int i2 = 0; i2 < stringArray.length; i2 += 4) {
            StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter();
            String string2 = stringArray[i2];
            String string3 = stringArray[i2 + 1];
            String string4 = stringArray[i2 + 2];
            String string5 = stringArray[i2 + 3];
            storeProcedureParameter.setName(string2.substring(string2.indexOf(58) + 1));
            storeProcedureParameter.setSchema(this.getIntSchema(string4));
            storeProcedureParameter.setType(this.getIntType(string3));
            storeProcedureParameter.setValue(string5.substring(string5.indexOf(58) + 1));
            try {
                storeProcedureParameterArray[i2 / 4] = storeProcedureParameter;
                continue;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Out of bounds : " + i2);
            }
        }
        this.setParameters(storeProcedureParameterArray);
    }

    private int getIntSchema(String string) {
        try {
            return Integer.parseInt(string.substring(string.indexOf(58) + 1));
        }
        catch (Exception exception) {
            return 0x7FFFFFFE;
        }
    }

    private int getIntType(String string) {
        try {
            return Integer.parseInt(string.substring(string.indexOf(58) + 1));
        }
        catch (Exception exception) {
            return 12;
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes");
        if (this.share) {
            xMLPrintWriter.attr("share", this.share);
        }
        xMLPrintWriter.attr("maxMemRowCount", this.getMaxMemRowCount()).end();
        if (this.database != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        this.writeParameters(xMLPrintWriter);
        this.writeResultNames(xMLPrintWriter);
    }

    private void writeResultNames(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ResultNames");
        int n2 = Math.min(12, this.resultNames.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("Name").textNode((String)this.resultNames.get(i2)).end();
        }
        xMLPrintWriter.end();
    }

    private void writeParameters(XMLPrintWriter xMLPrintWriter) {
        int n2 = ArrayUtils.getLength(this.parameters);
        if (n2 == 0) {
            return;
        }
        xMLPrintWriter.startTAG("ParamterList");
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("para");
            this.parameters[i2].writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return XML_TAG;
    }

    @Override
    public DataModel createDataModel(Calculator calculator) {
        return DataModel.EMPTY_DATAMODEL;
    }

    @Override
    public DataModel createDataModel(Calculator calculator, String string) {
        return this.getProcedureDataModel(calculator, string);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int n2;
        StoreProcedure storeProcedure = (StoreProcedure)super.clone();
        storeProcedure.setDatabaseConnection(this.getDatabaseConnection());
        storeProcedure.setParameters(this.getParameters());
        storeProcedure.setQuery(this.getQuery());
        storeProcedure.setMaxMemRowCount(this.getMaxMemRowCount());
        storeProcedure.dataModelList = new ArrayList();
        for (n2 = 0; n2 < this.dataModelList.size(); ++n2) {
            storeProcedure.dataModelList.add(this.dataModelList.get(n2));
        }
        storeProcedure.resultNames = new ArrayList();
        for (n2 = 0; n2 < this.resultNames.size(); ++n2) {
            storeProcedure.resultNames.add(this.resultNames.get(n2));
        }
        return storeProcedure;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof StoreProcedure && ComparatorUtils.equals(this.database, ((StoreProcedure)object).getDatabaseConnection()) && ComparatorUtils.equals(this.query, ((StoreProcedure)object).getQuery()) && ComparatorUtils.equals(this.parameters, ((StoreProcedure)object).getParameters());
    }
}

