/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.excelplus;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.AbstractDataModel;
import com.fr.data.impl.excelplus.Excel2003Util;
import com.fr.data.impl.excelplus.Excel2007Util;
import com.fr.data.impl.excelplus.ExcelUtil;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDataModelPlus
extends AbstractDataModel {
    private int columnCount = 0;
    private String[] columnNames;
    private List<Object[]> rowDataList = new ArrayList<Object[]>();
    private boolean needColumnName;
    private String filePath;
    private Parameter[] params;
    private InputStream inputStream;

    public ExcelDataModelPlus(String string, boolean bl, Parameter[] parameterArray) {
        this.filePath = string;
        this.needColumnName = bl;
        this.params = parameterArray;
    }

    public ExcelDataModelPlus(InputStream inputStream, String string) {
        this(inputStream, string, false, null);
    }

    public ExcelDataModelPlus(InputStream inputStream, String string, boolean bl, Parameter[] parameterArray) {
        this.inputStream = inputStream;
        this.filePath = string;
        this.needColumnName = bl;
        this.params = parameterArray;
    }

    @Override
    public int getColumnCount() throws TableDataException {
        this.initData();
        return this.columnCount;
    }

    @Override
    public String getColumnName(int n2) throws TableDataException {
        this.initData();
        String string = "#" + (n2 + 1);
        if (this.needColumnName) {
            return this.columnNames != null && n2 < this.columnNames.length ? this.columnNames[n2] : string;
        }
        return string;
    }

    @Override
    public boolean hasRow(int n2) throws TableDataException {
        return n2 >= 0 && n2 < this.getRowCount();
    }

    @Override
    public int getRowCount() throws TableDataException {
        this.initData();
        return this.rowDataList.size();
    }

    @Override
    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        if (n3 >= this.rowDataList.get(n2).length) {
            return null;
        }
        return this.rowDataList.get(n2)[n3];
    }

    @Override
    public void release() throws Exception {
    }

    private void initData() {
        ExcelUtil excelUtil;
        if (!this.rowDataList.isEmpty()) {
            return;
        }
        String string = ExcelDataModelPlus.generateCompletePath(this.filePath, this.params);
        try {
            if (this.inputStream != null) {
                if (string.endsWith(".xlsx")) {
                    excelUtil = new Excel2007Util(this.inputStream, false);
                    this.rowDataList = ((Excel2007Util)excelUtil).getRowDataList();
                } else if (string.endsWith(".xls") || string.endsWith(".et")) {
                    excelUtil = new Excel2003Util(this.inputStream, false);
                    this.rowDataList = ((Excel2003Util)excelUtil).getRowDataList();
                }
            } else if (string.endsWith(".xlsx")) {
                excelUtil = new Excel2007Util(string, false);
                this.rowDataList = ((Excel2007Util)excelUtil).getRowDataList();
            } else if (string.endsWith(".xls")) {
                excelUtil = new Excel2003Util(string, false);
                this.rowDataList = ((Excel2003Util)excelUtil).getRowDataList();
            } else {
                try {
                    this.rowDataList = new Excel2007Util(string, false).getRowDataList();
                }
                catch (Exception exception) {
                    this.rowDataList = new Excel2003Util(string, false).getRowDataList();
                }
            }
            if (this.rowDataList.size() > 0) {
                this.columnCount = this.rowDataList.get(0).length;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        if (this.needColumnName && this.rowDataList.size() > 0) {
            excelUtil = this.rowDataList.get(0);
            this.columnNames = new String[((ExcelUtil)excelUtil).length];
            for (int i2 = 0; i2 < ((ExcelUtil)excelUtil).length; ++i2) {
                this.columnNames[i2] = excelUtil[i2].toString();
            }
            this.rowDataList.remove(0);
        }
    }

    protected static String generateCompletePath(String string, Parameter[] parameterArray) {
        try {
            return ParameterHelper.analyze4Templatee(string, parameterArray);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return "";
        }
    }

    public static List<List<Object[]>> createMutiSheetData(InputStream inputStream, String string) throws Exception {
        ArrayList<List<Object[]>> arrayList = new ArrayList<List<Object[]>>();
        if (string.endsWith(".xlsx")) {
            List<Excel2007Util> list = Excel2007Util.createMutiSheetExcel(inputStream);
            for (Excel2007Util excel2007Util : list) {
                arrayList.add(excel2007Util.getRowDataList());
            }
        } else if (string.endsWith(".xls") || string.endsWith(".et")) {
            arrayList.addAll(Excel2003Util.createMutiSheetExcel(inputStream));
        }
        return arrayList;
    }
}

