/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.IntList;
import com.fr.data.AbstractDataModel;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.Primitive;
import java.util.ArrayList;
import java.util.List;

public class UnionDataModel
extends AbstractDataModel {
    private transient int[][] columnInfo = null;
    private transient int[] rowCountInfo = null;
    private transient List columnNameList = null;
    private List resultSetList;
    private final Object columnLock = new Object();
    private final Object rowLock = new Object();

    public UnionDataModel(List list) {
        this.resultSetList = list;
    }

    public int getColumnCount() throws TableDataException {
        this.initColumn();
        return this.columnNameList.size();
    }

    public String getColumnName(int n2) throws TableDataException {
        this.initColumn();
        return (String)this.columnNameList.get(n2);
    }

    public int getRowCount() throws TableDataException {
        this.initRowCount();
        this.initColumn();
        return this.rowCountInfo[this.rowCountInfo.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumn() throws TableDataException {
        Object object = this.columnLock;
        synchronized (object) {
            if (this.columnNameList == null) {
                int n2;
                IntList intList;
                int n3;
                if (this.resultSetList == null || this.resultSetList.isEmpty()) {
                    this.columnNameList = new ArrayList(0);
                    this.columnInfo = new int[0][0];
                    return;
                }
                int n4 = this.resultSetList.size();
                this.columnNameList = new ArrayList();
                IntList[] intListArray = new IntList[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    DataModel dataModel = (DataModel)this.resultSetList.get(n3);
                    int n5 = dataModel.getColumnCount();
                    intList = new IntList();
                    for (n2 = 0; n2 < n5; ++n2) {
                        String string = dataModel.getColumnName(n2);
                        if (this.columnNameList.contains(string)) {
                            intList.add(this.columnNameList.indexOf(string));
                            continue;
                        }
                        this.columnNameList.add(string);
                        intList.add(this.columnNameList.size() - 1);
                    }
                    intListArray[n3] = intList;
                }
                this.columnInfo = new int[n4][this.columnNameList.size()];
                for (n3 = 0; n3 < n4; ++n3) {
                    intList = intListArray[n3];
                    int[] nArray = this.columnInfo[n3];
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        nArray[n2] = -1;
                    }
                    for (n2 = intList.size() - 1; n2 >= 0; --n2) {
                        nArray[intList.get((int)n2)] = n2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRowCount() throws TableDataException {
        Object object = this.rowLock;
        synchronized (object) {
            if (this.rowCountInfo == null) {
                if (this.resultSetList == null || this.resultSetList.isEmpty()) {
                    this.rowCountInfo = new int[1];
                    return;
                }
                int n2 = this.resultSetList.size();
                this.rowCountInfo = new int[n2 + 1];
                for (int i2 = 0; i2 < n2; ++i2) {
                    DataModel dataModel = (DataModel)this.resultSetList.get(i2);
                    this.rowCountInfo[i2 + 1] = dataModel.getRowCount() + this.rowCountInfo[i2];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n2, int n3) throws TableDataException {
        if (n2 < 0 || n3 < 0) {
            return Primitive.NULL;
        }
        Object object = this.rowLock;
        synchronized (object) {
            for (int i2 = this.rowCountInfo.length - 1; i2 >= 0; --i2) {
                if (n2 < this.rowCountInfo[i2]) continue;
                if (i2 == this.rowCountInfo.length) {
                    return Primitive.NULL;
                }
                int[] nArray = this.columnInfo[i2];
                if (n3 >= nArray.length) {
                    return Primitive.NULL;
                }
                int n4 = nArray[n3];
                if (n4 < 0) {
                    return Primitive.NULL;
                }
                Object object2 = ((DataModel)this.resultSetList.get(i2)).getValueAt(n2 - this.rowCountInfo[i2], n4);
                if (object2 == null) {
                    return Primitive.NULL;
                }
                return object2;
            }
            return Primitive.NULL;
        }
    }

    public void release() throws Exception {
        if (this.resultSetList != null) {
            int n2 = this.resultSetList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataModel dataModel = (DataModel)this.resultSetList.get(i2);
                dataModel.release();
            }
        }
    }
}

