/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractDataModel;
import com.fr.data.impl.AutoParentBuilder;
import com.fr.data.impl.Forest;
import com.fr.data.impl.Node;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class RecursionDataModel
extends AbstractDataModel {
    private DataModel originalTableDataModel;
    private transient List columnNameList = new ArrayList();
    private int markField;
    private int parentMarkField;
    private AutoParentBuilder autoParentBuilder;
    private static final String GENFIELD = "FR_GEN_";
    private Object[][] valuePath;
    private String[] nodeIdArray;
    private Node[] nodeArray;

    public RecursionDataModel(DataModel dataModel, int n2, int n3) {
        this.originalTableDataModel = dataModel;
        this.setMarkField(n2);
        this.parentMarkField = n3;
    }

    public int getParentMarkField() {
        return this.parentMarkField;
    }

    public int getColumnCount() throws TableDataException {
        this.initColumn();
        return this.columnNameList.size();
    }

    private void build() throws TableDataException {
        Forest forest = this.buildForest();
        int n2 = this.originalTableDataModel.getRowCount();
        this.valuePath = forest.toTableArray(n2);
        this.nodeIdArray = forest.createQNodeIdArray(n2);
        this.nodeArray = forest.getNodeArrayOrderByRow(n2);
    }

    private Forest buildForest() throws TableDataException {
        Forest forest = new Forest();
        for (int i2 = 0; i2 < this.originalTableDataModel.getRowCount(); ++i2) {
            Object object = this.originalTableDataModel.getValueAt(i2, this.getMarkField());
            String string = this.getParentValue(object, i2);
            Node node = this.createNode(i2, object);
            Node node2 = this.createNode(-1, string);
            forest.addNodePair(node2, node);
        }
        forest.mergeTrees();
        return forest;
    }

    private String getParentValue(Object object, int n2) throws TableDataException {
        if (this.parentMarkField >= 0) {
            Object object2 = this.originalTableDataModel.getValueAt(n2, this.parentMarkField);
            return object2 == null ? null : object2.toString();
        }
        return this.getAutoParentValue(object, n2);
    }

    private String getAutoParentValue(Object object, int n2) throws TableDataException {
        this.initAutoParentBuilder();
        return this.autoParentBuilder.getParentId(n2);
    }

    private void initAutoParentBuilder() {
        if (this.autoParentBuilder == null) {
            this.autoParentBuilder = new AutoParentBuilder();
            this.autoParentBuilder.setDataModel(this.originalTableDataModel);
            this.autoParentBuilder.setMarkField(this.markField);
        }
    }

    private Node createNode(int n2, Object object) {
        if (this.isBlank(object)) {
            return Node.NULL;
        }
        Node node = new Node(object.toString());
        node.setRow(n2);
        return node;
    }

    private boolean isBlank(Object object) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        return StringUtils.isBlank(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumn() throws TableDataException {
        RecursionDataModel recursionDataModel = this;
        synchronized (recursionDataModel) {
            int n2;
            if (!this.columnNameList.isEmpty()) {
                return;
            }
            this.init();
            for (n2 = 0; n2 < this.originalTableDataModel.getColumnCount(); ++n2) {
                this.columnNameList.add(this.originalTableDataModel.getColumnName(n2));
            }
            if (this.valuePath.length == 0) {
                return;
            }
            for (n2 = 0; n2 < this.valuePath[0].length; ++n2) {
                this.columnNameList.add(GENFIELD + n2);
            }
        }
    }

    public String getColumnName(int n2) throws TableDataException {
        this.initColumn();
        return (String)this.columnNameList.get(n2);
    }

    public int getRowCount() throws TableDataException {
        return this.originalTableDataModel.getRowCount();
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        if (n3 < this.originalTableDataModel.getColumnCount()) {
            return this.originalTableDataModel.getValueAt(n2, n3);
        }
        return this.getValueFromLayerList(n2, n3 - this.originalTableDataModel.getColumnCount());
    }

    private Object getValueFromLayerList(int n2, int n3) throws TableDataException {
        if (this.valuePath == null) {
            this.init();
        }
        return this.valuePath[n2][n3];
    }

    public void release() throws Exception {
    }

    public Object[][] getValuePath() throws TableDataException {
        this.initColumn();
        if (this.valuePath == null) {
            this.init();
        }
        return this.valuePath;
    }

    private void init() throws TableDataException {
        if (this.valuePath == null) {
            this.build();
        }
    }

    public boolean hasChildren(int n2) throws TableDataException {
        this.initColumn();
        Node node = this.nodeArray[n2];
        if (Node.isNULL(node)) {
            return false;
        }
        return node.getChildSize() != 0;
    }

    private int getParentIndex(int n2) throws TableDataException {
        this.initColumn();
        String string = this._getParentValue(n2);
        int n3 = this.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!ComparatorUtils.equals(this.getValueAt(i2, this.markField).toString(), string)) continue;
            return i2;
        }
        return -1;
    }

    private String _getParentValue(int n2) throws TableDataException {
        Object object = null;
        if (this.parentMarkField > 0) {
            object = this.originalTableDataModel.getValueAt(n2, this.parentMarkField);
        } else {
            Object object2 = this.originalTableDataModel.getValueAt(n2, this.markField);
            object = this.getAutoParentValue(object2, n2);
        }
        return object == null ? "" : object.toString();
    }

    public String getParentValue(int n2) throws TableDataException {
        this.initColumn();
        return this._getParentValue(n2);
    }

    public String getParentId(int n2) throws TableDataException {
        this.initColumn();
        Node node = this.nodeArray[n2];
        Node node2 = node.getParent();
        if (Node.isNULL(node2) || !node2.hasIdentifyRow()) {
            return "0";
        }
        String string = this.nodeIdArray[node2.getRow()];
        return string == null ? "0" : string;
    }

    public String getId(int n2) throws TableDataException {
        this.initColumn();
        if (this.nodeIdArray == null) {
            this.init();
        }
        return this.nodeIdArray[n2];
    }

    public static int getNotNullLength(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            return i2;
        }
        return objectArray.length;
    }

    public int getMarkField() {
        return this.markField;
    }

    public void setMarkField(int n2) {
        this.markField = n2;
    }
}

