/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.OrderBy;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.page.PageConfiguration;
import com.fr.general.FRLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Select
extends AbstractDML {
    private List selectColumnNameList = new ArrayList(8);
    private List orderbyList = new ArrayList(4);
    private Where where;
    private PageConfiguration pageConfiguration;

    public Select(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Select(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.where = where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public Where getWhere() {
        return this.where;
    }

    public void addColumnName(String string) {
        if (string != null) {
            this.selectColumnNameList.add(string);
        }
    }

    public void addOrderBy(String string, boolean bl) {
        if (string != null) {
            this.orderbyList.add(new OrderBy(string, bl));
        }
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        String string = this.toStatementSQLString(this.dialect);
        FRLogger.getLogger().info(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, 1);
        }
        return preparedStatement;
    }

    public String noResultSQL() {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        stringBuffer.append(" where 1=2");
        stringBuffer.append(this.generateOrderSql());
        return stringBuffer.toString();
    }

    public String toStatementSQLString(Dialect dialect) {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        if (this.where != null) {
            stringBuffer.append(this.where.toStatementSQLString(dialect));
        }
        stringBuffer.append(this.generateOrderSql());
        return this.configPage(stringBuffer.toString(), dialect);
    }

    private String configPage(String string, Dialect dialect) {
        if (this.isPageSelect(dialect, string)) {
            return dialect.getLimitString(string, this.pageConfiguration.getStart(), this.pageConfiguration.getPageSize());
        }
        return string;
    }

    private boolean isPageSelect(Dialect dialect, String string) {
        return dialect.supportsLimitOffset(string) && this.pageConfiguration != null && this.pageConfiguration.isValid();
    }

    public String toNormalSQLString() {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        if (this.where != null) {
            stringBuffer.append(this.where.toNormalSQLString(this.dialect));
        }
        stringBuffer.append(this.generateOrderSql());
        return stringBuffer.toString();
    }

    private String genTmpSelectSQLString() {
        String[] stringArray;
        int n2;
        if (this.dialect == null) {
            this.dialect = DialectFactory.getDefaultDialect();
        }
        if ((n2 = this.selectColumnNameList.size()) == 0) {
            stringArray = new String[]{"*"};
        } else {
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.dialect.column2SQL((String)this.selectColumnNameList.get(i2));
            }
        }
        String string = this.getTable().toStatementSQLString(this.dialect);
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ');
        int n3 = stringArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            stringBuffer.append(stringArray[i3]);
            if (i3 >= n3 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ');
        string2 = stringBuffer.toString();
        String string3 = "SELECT" + string2 + "FROM " + string;
        return string3;
    }

    private String generateOrderSql() {
        if (this.dialect == null) {
            this.dialect = DialectFactory.getDefaultDialect();
        }
        if (this.orderbyList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Order by ");
            int n2 = this.orderbyList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                OrderBy orderBy = (OrderBy)this.orderbyList.get(i2);
                if (i2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.dialect.column2SQL(orderBy.getColumnName()));
                if (orderBy.isAsc()) {
                    stringBuffer.append(" asc");
                    continue;
                }
                stringBuffer.append(" desc");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public Select setPageConfiguration(PageConfiguration pageConfiguration) {
        this.pageConfiguration = pageConfiguration;
        return this;
    }
}

