/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.datasource;

import com.fr.base.ParameterHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.IOUtils;
import com.fr.general.data.DataSource;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class URLDataSource
implements DataSource {
    private String url;
    private ParameterProvider[] params;
    private static final int TIME_OUT = 50000;

    public URLDataSource() {
    }

    public URLDataSource(String string, ParameterProvider[] parameterProviderArray) {
        this.url = string;
        this.params = parameterProviderArray;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public InputStream getSourceStream(ParameterProvider[] parameterProviderArray) throws Exception {
        this.params = parameterProviderArray;
        return this.getSourceStream();
    }

    private InputStream getSourceStream() throws Exception {
        String string = ParameterHelper.analyze4Templatee(this.url, this.params);
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(50000);
        uRLConnection.setReadTimeout(50000);
        InputStream inputStream = uRLConnection.getInputStream();
        String string2 = IOUtils.inputStream2String(inputStream, "UTF-8").trim();
        return new ByteArrayInputStream(string2.getBytes("UTF-8"));
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        if (xMLableReader.isChildNode() && "URL".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
            this.url = string.trim();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.url != null) {
            xMLPrintWriter.startTAG("URL").textNode(this.url).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof URLDataSource && ComparatorUtils.equals(this.url, ((URLDataSource)object).url);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

