/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.Parameter;
import com.fr.cache.list.IntList;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.Result;
import com.fr.data.core.Compare;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class CommonCondition
extends AbstractCondition {
    protected String columnName;
    protected Compare compare;
    protected int columnNumber;

    public CommonCondition() {
    }

    public CommonCondition(String string, int n2, Object object) {
        this(string, new Compare(n2, object));
    }

    public CommonCondition(String string, Compare compare) {
        this.columnName = string;
        this.compare = compare;
    }

    public CommonCondition(String string, int n2, Compare compare) {
        this(string, compare);
        this.columnNumber = n2;
    }

    public Compare getCompare() {
        return this.compare;
    }

    public void setCompare(Compare compare) {
        this.compare = compare;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int n2) {
        this.columnNumber = n2;
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        Compare compare = this.getCompare();
        if (compare != null) {
            compare.modColumnRow(modColumnRowProvider);
        }
    }

    public void formula2Value(Calculator calculator) {
        if (this.compare != null) {
            this.compare.fm2Value(calculator);
        }
    }

    public void buildExecuteSequenceList(List list, Calculator calculator) {
        if (this.compare != null) {
            GeneralUtils.dealBuidExecuteSequence(this.compare.getValue(), list, calculator);
        }
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        return this.compare.dependence(calculatorProvider);
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider) {
        Compare compare = this.getCompare();
        Object object2 = compare.getValue();
        if (!(object2 instanceof String) && !(object2 instanceof Primitive) && (object2 = calculatorProvider.resolveVariable(object2)) != null) {
            try {
                compare = (Compare)compare.clone();
                compare.setValue(object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
        }
        if (object instanceof Result) {
            Object object3 = ((Result)object).toResult(this);
            return object3 != null && compare.eval(object3);
        }
        return compare.eval(object);
    }

    public int[] evalTableData(DataModel dataModel, int[] nArray, int n2, CalculatorProvider calculatorProvider) {
        nArray = super.getFilterRows(dataModel, n2, nArray, calculatorProvider);
        if (dataModel == null) {
            return new int[0];
        }
        int n3 = this.findColumIndexInDataModel(dataModel);
        if (n3 == -1) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int n4 = this.calculateRowCount(dataModel);
        nArray = this.initSourceIndices(nArray, n4);
        IntList intList = new IntList();
        Compare compare = this.getCompare();
        if (compare != null) {
            compare = this.resolveRightValueOfCompare(calculatorProvider);
            intList = this.calculateSuitableRowIndexes(dataModel, compare, nArray, n3, n4);
        }
        return intList.toArray();
    }

    private void ensureColumnNameNotNull() {
        if (this.columnName == null) {
            this.columnName = "";
        }
    }

    public int findColumIndexInDataModel(DataModel dataModel) {
        int n2;
        block4: {
            n2 = -1;
            this.ensureColumnNameNotNull();
            try {
                int n3 = dataModel.getColumnCount();
                if (this.columnNumber > 0 && this.columnNumber < n3 + 1) {
                    n2 = this.columnNumber - 1;
                    break block4;
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!ComparatorUtils.tableDataColumnNameEquals(this.columnName, dataModel.getColumnName(i2))) continue;
                    n2 = i2;
                    break;
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        return n2;
    }

    private int calculateRowCount(DataModel dataModel) {
        try {
            return dataModel.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            return 0;
        }
    }

    private int[] initSourceIndices(int[] nArray, int n2) {
        if (nArray == null) {
            return IntList.range(n2);
        }
        return nArray;
    }

    public Compare resolveRightValueOfCompare(CalculatorProvider calculatorProvider) {
        Compare compare = this.compare;
        FArray<Object> fArray = compare.getValue();
        if (!(fArray instanceof String) && !(fArray instanceof Primitive)) {
            if (fArray instanceof FormulaProvider) {
                try {
                    fArray = calculatorProvider.evalValue(((FormulaProvider)((Object)fArray)).getContent());
                }
                catch (UtilEvalError utilEvalError) {
                    fArray = null;
                }
            } else if (fArray instanceof Parameter) {
                try {
                    fArray = calculatorProvider.eval(((Parameter)((Object)fArray)).getName());
                }
                catch (UtilEvalError utilEvalError) {
                    FRLogger.getLogger().info(utilEvalError.getMessage());
                }
                if (fArray instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)((Object)fArray);
                    FArray<Object> fArray2 = new FArray<Object>();
                    int n2 = jSONArray.length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        try {
                            fArray2.add(jSONArray.get(i2));
                            continue;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    fArray = fArray2;
                }
            } else {
                fArray = calculatorProvider.resolveVariable(fArray);
            }
            if (fArray != null) {
                try {
                    compare = (Compare)compare.clone();
                    compare.setValue(fArray);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                }
            }
        }
        return compare;
    }

    private IntList calculateSuitableRowIndexes(DataModel dataModel, Compare compare, int[] nArray, int n2, int n3) {
        IntList intList = new IntList();
        for (int n4 : nArray) {
            if (n4 < 0 || n4 >= n3) continue;
            try {
                Object object = dataModel.getValueAt(n4, n2);
                if (!compare.eval(object)) continue;
                intList.add(n4);
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        return intList;
    }

    public boolean equals(Object object) {
        return object instanceof CommonCondition && ((CommonCondition)object).columnNumber == this.columnNumber && ComparatorUtils.equals(((CommonCondition)object).columnName, this.columnName) && ComparatorUtils.equals(((CommonCondition)object).compare, this.compare);
    }

    public String toString() {
        return StringUtils.isNotEmpty(this.columnName) ? "(" + Inter.getLocText("ColumnName") + ":" + this.columnName + ") " + this.compare : "(" + Inter.getLocText("Datasource-Column_Index") + ":" + this.columnNumber + ") " + this.compare;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Compare".equals(string) || "Condition".equals(string)) {
                this.compare = new Compare(0, "");
                xMLableReader.readXMLObject(this.compare);
            } else if ("CNAME".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                this.columnName = string2 == null ? "" : string2;
            } else if ("CNUMBER".equals(string)) {
                this.columnNumber = Integer.parseInt(xMLableReader.getElementValue());
            } else if ("SelectionColumn".equals(string)) {
                this.columnName = xMLableReader.getAttrAsString("name", "");
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.columnNumber != -1) {
            xMLPrintWriter.startTAG("CNUMBER").textNode(String.valueOf(this.columnNumber));
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotEmpty(this.columnName)) {
            xMLPrintWriter.startTAG("CNAME").textNode(this.columnName == null ? "" : this.columnName);
            xMLPrintWriter.end();
        }
        if (this.compare != null) {
            this.compare.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CommonCondition commonCondition = (CommonCondition)super.clone();
        if (this.compare != null) {
            commonCondition.compare = (Compare)this.compare.clone();
        }
        return commonCondition;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        if (this.columnName != null) {
            jSONObject.put("columnname", this.columnName);
        }
        if (this.columnNumber != 0) {
            jSONObject.put("columnNumber", this.columnNumber);
        }
        if (this.compare != null) {
            jSONObject.put("compare", this.compare.createJSON());
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("columnname")) {
            this.columnName = jSONObject.getString("columnname");
        }
        if (jSONObject.has("columnNumber")) {
            this.columnNumber = jSONObject.getInt("columnNumber");
        }
        if (jSONObject.has("compare")) {
            Compare compare = new Compare();
            compare.parseJSON(jSONObject.getJSONObject("compare"));
            this.compare = compare;
        }
    }
}

