/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.Parameter;
import com.fr.cluster.rpc.RPCUtil;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class Result
implements Serializable {
    private static final long serialVersionUID = 101L;
    protected Serializable returnValue;
    private Parameter[] parameterValues;
    private boolean isReturnValueRecovered = false;
    private boolean isReturnValueSerializabled = false;

    public boolean isReturnValueRecovered() {
        return this.isReturnValueRecovered;
    }

    public void returnValueRecovered() {
        this.isReturnValueRecovered = true;
    }

    public boolean isReturnValueSerializabled() {
        return this.isReturnValueSerializabled;
    }

    public void returnValueSerializabled() {
        this.isReturnValueSerializabled = true;
    }

    public Result(Object object, Parameter[] parameterArray) {
        this.returnValue = object != null ? (Serializable)this.checkReturnValueSerializable(object) : "object_null";
        this.parameterValues = this.transform(parameterArray);
    }

    private Parameter[] transform(Parameter[] parameterArray) {
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            parameterArray[i2].resetInitialed();
            parameterArray[i2].initial(parameterArray[i2].getType(), parameterArray[i2].getValue());
        }
        return parameterArray;
    }

    public Object getReturnValue(Method method) throws Throwable {
        return this.recoverResultValue(method, this.returnValue);
    }

    public void assignmentReturnParameter(Object[] objectArray) throws Exception {
        if (objectArray != null && this.parameterValues != null && this.parameterValues.length == objectArray.length) {
            for (int i2 = 0; i2 < this.parameterValues.length; ++i2) {
                this.parameterValues[i2].recover();
                this.assignmentParameter(this.parameterValues[i2].getValue(), objectArray[i2]);
            }
        }
    }

    private void assignmentParameter(Object object, Object object2) throws Exception {
        if (object != null && object2 != null) {
            Class<?> clazz = object2.getClass();
            Class<?> clazz2 = object.getClass();
            if (RPCUtil.equalsTool(clazz.getName(), clazz2.getName())) {
                Method[] methodArray = clazz.getMethods();
                for (int i2 = 0; i2 < methodArray.length; ++i2) {
                    Method method;
                    if (!this.isGetter(methodArray[i2]) || (method = this.findSetter(this.getSetterName(methodArray[i2].getName()), methodArray)) == null) continue;
                    try {
                        method.invoke(object2, methodArray[i2].invoke(object, new Object[0]));
                        continue;
                    }
                    catch (Exception exception) {
                        FRLogger.getLogger().error(exception.getMessage() + methodArray[i2]);
                    }
                }
            } else {
                throw new Exception("the type of returning value is different to the local");
            }
        }
    }

    private Method findSetter(String string, Method[] methodArray) {
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if (!RPCUtil.equalsTool(string, methodArray[i2].getName()) || methodArray[i2].getParameterTypes().length != 1) continue;
            return methodArray[i2];
        }
        return null;
    }

    private boolean isGetter(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getName().startsWith("get");
    }

    private String getSetterName(String string) {
        String string2 = this.field(string);
        if (string2 != null) {
            return "set" + string2;
        }
        return null;
    }

    private String field(String string) {
        String[] stringArray = string.split("get");
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return null;
    }

    protected Object recoverResultValue(Method method, Serializable serializable) throws Throwable {
        if (RPCUtil.equalsTool(serializable, "object_null")) {
            this.returnValueRecovered();
            return null;
        }
        if (serializable instanceof Throwable) {
            throw (Throwable)serializable;
        }
        if (RPCUtil.equalsTool(method.getReturnType(), Iterator.class)) {
            this.returnValueRecovered();
            return this.convertIterator((ArrayList)serializable);
        }
        return serializable;
    }

    private Object convertIterator(ArrayList arrayList) {
        if (arrayList != null) {
            return arrayList.iterator();
        }
        return new ArrayList(0).iterator();
    }

    protected Object checkReturnValueSerializable(Object object) {
        if (object instanceof Iterator) {
            object = this.extractIterator((Iterator)object);
            this.returnValueSerializabled();
        }
        return object;
    }

    private Serializable extractIterator(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Result)) {
            return false;
        }
        Result result = (Result)object;
        if (this.isReturnValueRecovered != result.isReturnValueRecovered) {
            return false;
        }
        if (this.isReturnValueSerializabled != result.isReturnValueSerializabled) {
            return false;
        }
        if (ComparatorUtils.equals(this.parameterValues, result.parameterValues)) {
            return false;
        }
        return RPCUtil.equalsTool(this.returnValue, result.returnValue);
    }

    public int hashCode() {
        int n2 = this.returnValue.hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.parameterValues);
        n2 = 31 * n2 + (this.isReturnValueRecovered ? 1 : 0);
        n2 = 31 * n2 + (this.isReturnValueSerializabled ? 1 : 0);
        return n2;
    }
}

