/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.RPCClient;
import com.fr.cluster.rpc.RPCProxyHandler;
import com.fr.cluster.rpc.RPCSkeletonsService;
import com.fr.cluster.rpc.RPCUtil;
import com.fr.cluster.rpc.SocketServer;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPC {
    private static RPCSkeletonsService rpcSkeletonsService;
    private static Map<Integer, SocketServer> socketServers;
    private static RPCClient RPCClient;
    public static final String NULLOBJECT = "object_null";

    private static void initServer() {
        if (socketServers == null) {
            rpcSkeletonsService = new RPCSkeletonsService();
            socketServers = new HashMap<Integer, SocketServer>();
        }
    }

    public static void registerSkeleton(Object object, int n2) {
        rpcSkeletonsService.register(RPCUtil.encodeClassName(object.getClass(), n2), object);
        if (!socketServers.containsKey(n2)) {
            SocketServer socketServer = new SocketServer();
            socketServer.setPort(n2);
            socketServer.setBirpcService(rpcSkeletonsService);
            socketServer.start();
            socketServers.put(n2, socketServer);
        }
    }

    public static void registerSkeleton(Object object) {
        RPC.registerSkeleton(object, SocketServer.DEFAULT_PORT);
    }

    public static Object getProxy(Class clazz, String string) {
        return RPC.getProxy(clazz, string, SocketServer.DEFAULT_PORT);
    }

    public static Object getProxy(Class clazz, String string, int n2) {
        return RPC.getProxy(clazz, string, n2, new HashMap<String, Object>());
    }

    public static Object getProxy(Class clazz, String string, int n2, Map<String, Object> map) {
        return RPC.getProxy(clazz, clazz.getInterfaces(), string, n2, map, false);
    }

    public static Object getProxy(Class clazz, Class<?>[] classArray, String string, int n2) {
        return RPC.getProxy(clazz, classArray, string, n2, new HashMap<String, Object>(), false);
    }

    public static Object getProxy(Class clazz, String string, int n2, Boolean bl) {
        return RPC.getProxy(clazz, clazz.getInterfaces(), string, n2, new HashMap<String, Object>(), bl);
    }

    public static Object getProxy(Class clazz, Class<?>[] classArray, String string, int n2, Map<String, Object> map, boolean bl) {
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new RPCProxyHandler(new RPCClient(RPCUtil.encodeClassName(clazz, n2), string, n2), map, bl));
        return object;
    }

    public static void release() {
        if (socketServers != null) {
            Iterator<SocketServer> iterator = socketServers.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().stop();
            }
        }
        rpcSkeletonsService = null;
        socketServers = null;
    }

    static {
        RPC.initServer();
        ServletContext.addServletContextListener(new ServletContextListener(){

            public void onServletStart() {
                RPC.initServer();
            }

            public void onServletStop() {
                RPC.release();
            }
        });
    }
}

