/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.charttypes;

import com.fr.chart.base.ChartInternationalNameContentBean;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.charttypes.AreaIndependentChart;
import com.fr.chart.charttypes.BarIndependentChart;
import com.fr.chart.charttypes.BubbleIndependentChart;
import com.fr.chart.charttypes.ColumnIndependentChart;
import com.fr.chart.charttypes.CustomIndependentChart;
import com.fr.chart.charttypes.DonutIndependentChart;
import com.fr.chart.charttypes.FunnelIndependentChart;
import com.fr.chart.charttypes.GanttIndependentChart;
import com.fr.chart.charttypes.GisMapIndependentChart;
import com.fr.chart.charttypes.LineIndependentChart;
import com.fr.chart.charttypes.MapIndependentChart;
import com.fr.chart.charttypes.MeterIndependentChart;
import com.fr.chart.charttypes.PieIndependentChart;
import com.fr.chart.charttypes.RadarIndependentChart;
import com.fr.chart.charttypes.RangeIndependentChart;
import com.fr.chart.charttypes.StockIndependentChart;
import com.fr.chart.charttypes.XYScatterIndependentChart;
import com.fr.chart.fun.IndependentChartProvider;
import com.fr.chart.fun.impl.AbstractIndependentDefaultChartProviderWithAPILevel;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.plugin.PluginCollector;
import com.fr.plugin.PluginLicenseManager;
import com.fr.plugin.PluginMessage;
import com.fr.plugin.proxy.PluginInstanceProxyFactory;
import com.fr.stable.ArrayUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListSet;
import com.fr.stable.StringUtils;
import com.fr.stable.collections.map.CloseableContainedMap;
import com.fr.stable.fun.Authorize;
import com.fr.stable.plugin.ExtraChartTypeClassManagerProvider;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartTypeManager
implements ExtraChartTypeClassManagerProvider {
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    public static final String CHART_PRIORITY = "-1";
    private static String[] DEFAULT_JS = new String[]{"/com/fr/web/core/js/chart.utils.js", "/com/fr/web/core/js/chart.constants.js", "/com/fr/web/core/js/chart.shape.js", "/com/fr/web/core/js/chart.plotattr.js", "/com/fr/web/core/js/chart.axisglyph.js", "/com/fr/web/core/js/chart.datapoint.js", "/com/fr/web/core/js/chart.dataseries.js", "/com/fr/web/core/js/chart.glyph.js", "/com/fr/web/core/js/chart.legend.js", "/com/fr/web/core/js/chart.datasheet.js", "/com/fr/web/core/js/chart.handler.js", "/com/fr/web/core/js/chart.tooltip.js", "/com/fr/web/core/js/chart.report.widget.js", "/com/fr/web/core/js/chart.form.widget.js", "/com/fr/web/core/js/chart.finechart.js"};
    private static ChartTypeManager typeManager;
    private static LinkedHashMap<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> chartTypes;

    public static synchronized ChartTypeManager getInstance() {
        if (typeManager == null) {
            typeManager = new ChartTypeManager();
            chartTypes.clear();
            typeManager.readDefaultChartTypes();
        }
        return typeManager;
    }

    private static synchronized void envChanged() {
        typeManager = null;
    }

    private static void readDefaultChartTypes() {
        CloseableContainedMap<String, AbstractIndependentDefaultChartProviderWithAPILevel, LinkedHashMap> closeableContainedMap = new CloseableContainedMap<String, AbstractIndependentDefaultChartProviderWithAPILevel, LinkedHashMap>(LinkedHashMap.class);
        closeableContainedMap.put("FineReportColumnChart", new ColumnIndependentChart());
        closeableContainedMap.put("FineReportLineChart", new LineIndependentChart());
        closeableContainedMap.put("FineReportBarChart", new BarIndependentChart());
        closeableContainedMap.put("FineReportPieChart", new PieIndependentChart());
        closeableContainedMap.put("FineReportAreaChart", new AreaIndependentChart());
        closeableContainedMap.put("FineReportScatterChart", new XYScatterIndependentChart());
        closeableContainedMap.put("FineReportBubbleChart", new BubbleIndependentChart());
        closeableContainedMap.put("FineReportRadarChart", new RadarIndependentChart());
        closeableContainedMap.put("FineReportStockChart", new StockIndependentChart());
        closeableContainedMap.put("FineReportMeterChart", new MeterIndependentChart());
        closeableContainedMap.put("FineReportRangeChart", new RangeIndependentChart());
        closeableContainedMap.put("FineReportCustomChart", new CustomIndependentChart());
        closeableContainedMap.put("FineReportGanttChart", new GanttIndependentChart());
        closeableContainedMap.put("FineReportDonutChart", new DonutIndependentChart());
        closeableContainedMap.put("FineReportMapChart", new MapIndependentChart());
        closeableContainedMap.put("FineReportGisChart", new GisMapIndependentChart());
        closeableContainedMap.put("FineReportFunnelChart", new FunnelIndependentChart());
        chartTypes.put(CHART_PRIORITY, closeableContainedMap);
    }

    public static void addChartType(String string, IndependentChartProvider independentChartProvider, String string2) {
        if (chartTypes != null) {
            if (!chartTypes.containsKey(string)) {
                CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap> closeableContainedMap = new CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>(LinkedHashMap.class);
                closeableContainedMap.put(string2, independentChartProvider);
                chartTypes.put(string, closeableContainedMap);
            } else {
                Map map = chartTypes.get(string);
                if (!map.containsKey(string2)) {
                    map.put(string2, independentChartProvider);
                }
            }
        }
    }

    public String[] getUsedJSFiles() {
        ListSet<String> listSet = new ListSet<String>();
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            Map map = chartTypes.get(string);
            for (Map.Entry entry2 : map.entrySet()) {
                IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry2.getValue();
                for (String string2 : independentChartProvider.getRequiredJS()) {
                    listSet.add(string2);
                }
            }
        }
        return ArrayUtils.addAll(DEFAULT_JS, listSet.toArray((T[])new String[0]));
    }

    public void addChartTypeProvider(String string, String string2, String string3, PluginSimplify pluginSimplify) {
        if (StringUtils.isNotBlank(string2)) {
            try {
                Class<?> clazz = Class.forName(string2);
                Authorize authorize = clazz.getAnnotation(Authorize.class);
                if (authorize != null) {
                    PluginLicenseManager.getInstance().registerPaid(authorize, pluginSimplify);
                }
                IndependentChartProvider independentChartProvider = (IndependentChartProvider)new PluginInstanceProxyFactory(clazz, pluginSimplify).addProxy("isClosed").getProxyObj();
                if (PluginCollector.getCollector().isError(independentChartProvider, 3, pluginSimplify.getPluginName())) {
                    PluginMessage.remindUpdate(string2);
                } else {
                    ChartTypeManager.getInstance();
                    ChartTypeManager.addChartType(string, independentChartProvider, string3);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("class not found:" + exception.getMessage());
            }
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        this.readXML(xMLableReader, null, PluginSimplify.NULL);
    }

    @Override
    public void readXML(XMLableReader xMLableReader, List<String> list, PluginSimplify pluginSimplify) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (list != null) {
                list.add(string);
            }
            if (ComparatorUtils.equals(string, "IndependentChartProvider")) {
                String string2 = xMLableReader.getAttrAsString("class", "");
                String string3 = xMLableReader.getAttrAsString("plotID", "");
                String string4 = xMLableReader.getAttrAsString("priority", CHART_PRIORITY);
                this.addChartTypeProvider(string4, string2, string3, pluginSimplify);
            }
        }
    }

    public Chart[] getChartTypes(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                Chart[] chartArray = this.getChartTypes(string2, string);
                if (chartArray.length == 0) continue;
                return chartArray;
            }
        }
        return new Chart[0];
    }

    public String getWrapperName(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                String string3 = this.getWrapperName(string2, string);
                if (!StringUtils.isNotEmpty(string3)) continue;
                return string3;
            }
        }
        return "";
    }

    public String getChartImagePath(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                String string3 = this.getChartImagePath(string2, string);
                if (!StringUtils.isNotEmpty(string3)) continue;
                return string3;
            }
        }
        return "";
    }

    public boolean containsPlot(String string) {
        if (chartTypes != null) {
            Iterator<Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>>> iterator = chartTypes.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry = iterator.next();
                String string2 = entry.getKey();
                boolean bl2 = this.containsPlot(string2, string);
                if (!bl2) continue;
                return bl2;
            }
        }
        return false;
    }

    public ChartInternationalNameContentBean[] getAllChartBaseNames() {
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray;
        int n2;
        List<Integer> list = ChartTypeManager.getPriorityInOrder();
        ArrayList<ChartInternationalNameContentBean[]> arrayList = new ArrayList<ChartInternationalNameContentBean[]>();
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            chartInternationalNameContentBeanArray = String.valueOf(list.get(n2));
            ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray2 = this.getAllChartBaseNames((String)chartInternationalNameContentBeanArray);
            arrayList.add(chartInternationalNameContentBeanArray2);
        }
        n2 = 0;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            chartInternationalNameContentBeanArray = (ChartInternationalNameContentBean[])arrayList.get(n3);
            n2 += chartInternationalNameContentBeanArray.length;
        }
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray3 = new ChartInternationalNameContentBean[n2];
        int n4 = 0;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray4 = (ChartInternationalNameContentBean[])arrayList.get(i2);
            for (int i3 = 0; i3 < chartInternationalNameContentBeanArray4.length; ++i3) {
                chartInternationalNameContentBeanArray3[n4++] = chartInternationalNameContentBeanArray4[i3];
            }
        }
        return chartInternationalNameContentBeanArray3;
    }

    public static List<Integer> orderInPriority(List<Integer> list) {
        if (list == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (list.size() > 0) {
            int n2 = 0;
            int n3 = list.size();
            for (int i2 = 1; i2 < n3; ++i2) {
                if (list.get(i2) <= list.get(n2)) continue;
                n2 = i2;
            }
            arrayList.add(list.get(n2));
            list.remove(n2);
        }
        return arrayList;
    }

    public static Chart getFirstChart() {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return new Chart();
        }
        List<Integer> list = ChartTypeManager.getPriorityInOrder();
        if (list.size() == 0) {
            ChartTypeManager.getDefaultFirstChart();
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = String.valueOf(list.get(i2));
            Map map = chartTypes.get(string);
            if (map == null || map.isEmpty()) {
                return new Chart();
            }
            Iterator iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return new Chart();
    }

    private static Chart getDefaultFirstChart() {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return new Chart();
        }
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            Map map = chartTypes.get(string);
            if (map == null || map.isEmpty()) {
                return new Chart();
            }
            Iterator iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry2 = iterator.next();
            String string2 = (String)entry2.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return new Chart();
    }

    private static List<Integer> getPriorityInOrder() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            arrayList.add(Integer.valueOf(string));
        }
        return ChartTypeManager.orderInPriority(arrayList);
    }

    public String[] getRequiredJS(String string) {
        if (chartTypes != null) {
            Iterator<Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>>> iterator = chartTypes.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry = iterator.next();
                String string2 = entry.getKey();
                String[] stringArray = this.getRequiredJS(string2, string);
                if (ComparatorUtils.equals((Object)stringArray, (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY)) continue;
                return stringArray;
            }
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private Chart[] getChartTypes(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return chartTypes.get(string).get(string2).getChartTypes();
        }
        return new Chart[0];
    }

    private String getWrapperName(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return chartTypes.get(string).get(string2).getWrapperName();
        }
        return "";
    }

    private String[] getRequiredJS(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return chartTypes.get(string).get(string2).getRequiredJS();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String getChartImagePath(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return chartTypes.get(string).get(string2).getChartImagePath();
        }
        return "";
    }

    private boolean containsPlot(String string, String string2) {
        return chartTypes != null && chartTypes.containsKey(string) && chartTypes.get(string).containsKey(string2);
    }

    private ChartInternationalNameContentBean[] getAllChartBaseNames(String string) {
        Map map = chartTypes.get(string);
        int n2 = map.size();
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray = new ChartInternationalNameContentBean[n2];
        Iterator iterator = map.entrySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry.getValue();
            chartInternationalNameContentBeanArray[n3++] = new ChartInternationalNameContentBean(independentChartProvider.getChartName(), string2);
        }
        return chartInternationalNameContentBeanArray;
    }

    private String[] getUsedJSFiles(String string) {
        ListSet<String> listSet = new ListSet<String>();
        Map map = chartTypes.get(string);
        for (Map.Entry entry : map.entrySet()) {
            IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry.getValue();
            for (String string2 : independentChartProvider.getRequiredJS()) {
                listSet.add(string2);
            }
        }
        return ArrayUtils.addAll(DEFAULT_JS, listSet.toArray((T[])new String[0]));
    }

    public static Chart getFirstChart(String string) {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return null;
        }
        Map map = chartTypes.get(string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        Iterator iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return null;
    }

    static {
        chartTypes = new LinkedHashMap();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ChartTypeManager.getInstance();
                ChartTypeManager.envChanged();
            }
        });
    }
}

