/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.BarStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class StackedBar3DStyle
extends BarStyle {
    private Rectangle2D totalRect = null;
    private boolean isHorizontal;
    private boolean axisReversed;

    public StackedBar3DStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.color = color;
        this.rect = rectangle2D;
        this.totalRect = rectangle2D;
        this.isHorizontal = bl;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
    }

    public void setTotalRect(Rectangle2D rectangle2D) {
        this.totalRect = rectangle2D;
    }

    public void paintStyle(Graphics graphics) {
        if (this.color == null) {
            return;
        }
        if (graphics instanceof SWFGraphics2D) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        GradientPaint gradientPaint = null;
        gradientPaint = this.isHorizontal ? new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), this.getShadeStartColor(), (float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), this.getShadeEndColor()) : new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), this.getShadeStartColor(), (float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), this.getShadeEndColor());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.rect);
        this.drawBorder(graphics2D);
        if (this.totalRect != null) {
            graphics2D.setPaint(this.getInnerStrokeColor());
            GeneralPath generalPath = new GeneralPath();
            if (this.isHorizontal) {
                if (this.axisReversed) {
                    generalPath.moveTo((float)this.totalRect.getX() + 1.0f, (float)(this.totalRect.getY() + this.totalRect.getHeight()) - 2.0f);
                    generalPath.lineTo((float)this.totalRect.getX() + 1.0f, (float)this.totalRect.getY() + 1.0f);
                    generalPath.lineTo((float)(this.totalRect.getX() + this.totalRect.getWidth()) - 1.0f, (float)this.totalRect.getY() + 1.0f);
                } else {
                    generalPath.moveTo((float)this.totalRect.getX() + 1.0f, (float)this.totalRect.getY() + 1.0f);
                    generalPath.lineTo((float)(this.totalRect.getX() + this.totalRect.getWidth()) - 1.0f, (float)this.totalRect.getY() + 1.0f);
                    generalPath.lineTo((float)(this.totalRect.getX() + this.totalRect.getWidth()) - 1.0f, (float)(this.totalRect.getY() + this.totalRect.getHeight()) - 2.0f);
                }
            } else if (this.axisReversed) {
                generalPath.moveTo((float)this.totalRect.getX() + 1.0f, (float)this.totalRect.getY() + 1.0f);
                generalPath.lineTo((float)this.totalRect.getX() + 1.0f, (float)(this.totalRect.getY() + this.totalRect.getHeight()) - 2.0f);
                generalPath.lineTo((float)(this.totalRect.getX() + this.totalRect.getWidth()) - 1.0f, (float)(this.totalRect.getY() + this.totalRect.getHeight()) - 2.0f);
            } else {
                generalPath.moveTo((float)this.totalRect.getX() + 1.0f, (float)(this.totalRect.getY() + this.totalRect.getHeight()) - 2.0f);
                generalPath.lineTo((float)this.totalRect.getX() + 1.0f, (float)this.totalRect.getY() + 1.0f);
                generalPath.lineTo((float)(this.totalRect.getX() + this.totalRect.getWidth()) - 1.0f, (float)this.totalRect.getY() + 1.0f);
            }
            graphics2D.draw(generalPath);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private void drawBorder(Graphics2D graphics2D) {
        if (this.rect != null && this.rect.getWidth() > 4.0 && this.rect.getHeight() > 4.0) {
            GeneralPath generalPath = this.isHorizontal ? (this.totalRect == null ? ChartUtils.getBoundsTopAndBottom(this.rect) : (this.axisReversed ? ChartUtils.getBoundsWithoutRight(this.rect) : ChartUtils.getBoundsWithoutLeft(this.rect))) : (this.totalRect == null ? ChartUtils.getBoundsLeftAndRight(this.rect) : (this.axisReversed ? ChartUtils.getBoundsWithoutTop(this.rect) : ChartUtils.getBoundsWithoutBottom(this.rect)));
            graphics2D.setPaint(this.getStrokeColor());
            graphics2D.setStroke(new BasicStroke(this.borderWidth));
            graphics2D.draw(generalPath);
        }
    }
}

