/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RangeAxisGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.core.IteratorChain;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RangePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -3079867047500181470L;
    private static final double AXISHEIGHT = 50.0;
    private RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
    private double seriesWidth = 2.0;
    private List rangeAxisGlyphList = new ArrayList();

    public void layoutAxisGlyph(int n2) {
        this.rangeAxisGlyphList.clear();
        int n3 = this.getCategoryCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2 = this.getBounds().getHeight();
            double d3 = this.getBounds().getWidth();
            double d4 = d2 / (double)(n3 * 2) > 50.0 ? 50.0 : d2 / (double)(n3 * 2);
            double d5 = (double)(i2 + 1) * d2 / (double)(1 + n3) - d4 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, d5, d3, d4);
            RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
            try {
                rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            rangeAxisGlyph.dealPlotBoundsWithAxisLabel(double_, n2);
            rangeAxisGlyph.setPlotZeroBounds(this.getBounds());
            rangeAxisGlyph.init(double_, d2);
            rangeAxisGlyph.calculateAxisLengthUnit();
            this.rangeAxisGlyphList.add(rangeAxisGlyph);
        }
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            for (int i3 = 0; i3 < this.getSeriesSize(); ++i3) {
                DataSeries dataSeries = this.getSeries(i3);
                DataPoint dataPoint = dataSeries.getDataPoint(i2);
                if (dataPoint.isValueIsNull()) continue;
                RangeAxisGlyph rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyphList.get(i2);
                Point2D point2D = rangeAxisGlyph.getPoint2D(dataPoint.getValue());
                double d2 = rangeAxisGlyph.getBounds().getHeight();
                double d3 = rangeAxisGlyph.getBounds().getY();
                Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - this.seriesWidth / 2.0, d3 + point2D.getY() - d2 / 2.0, this.seriesWidth, d2);
                ShapeGlyph shapeGlyph = new ShapeGlyph(double_);
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                dataPoint.setDrawImpl(shapeGlyph);
                this.dealDataPointLabel(dataPoint, n2);
            }
        }
        this.dealLabelBoundsInOrder();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        double d2 = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        double d3 = 0.0;
        double d4 = 2.0;
        switch (n2) {
            case 1: {
                d3 = rectangle2D.getY() - dimension2D.getHeight() - d4;
                break;
            }
            case 3: {
                d3 = rectangle2D.getY() + rectangle2D.getHeight() + d4;
                break;
            }
            default: {
                d2 = rectangle2D.getX() + rectangle2D.getWidth() + d4;
                d3 = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
            }
        }
        return new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setRangeAxisGlyph(RangeAxisGlyph rangeAxisGlyph) {
        this.rangeAxisGlyph = rangeAxisGlyph;
    }

    public RangeAxisGlyph getRangeAxisGlyph() {
        return this.rangeAxisGlyph;
    }

    public void setSeriesWidth(double d2) {
        this.seriesWidth = d2;
    }

    public Iterator selectableChildren() {
        ArrayList arrayList = new ArrayList();
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            arrayList.addAll(this.rangeAxisGlyphList);
        }
        return new IteratorChain(new Iterator[]{super.selectableChildren(), arrayList.iterator()});
    }

    public void draw(Graphics graphics, int n2) {
        super.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGird(graphics);
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            for (int i2 = 0; i2 < this.rangeAxisGlyphList.size(); ++i2) {
                ((RangeAxisGlyph)this.rangeAxisGlyphList.get(i2)).draw(graphics2D, n2);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n2);
    }

    private void drawAxisGird(Graphics graphics) {
        if (this.rangeAxisGlyphList != null && !this.rangeAxisGlyphList.isEmpty()) {
            for (int i2 = 0; i2 < this.rangeAxisGlyphList.size(); ++i2) {
                ((RangeAxisGlyph)this.rangeAxisGlyphList.get(i2)).drawAxisGrid(graphics);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof RangePlotGlyph && super.equals(object) && ((RangePlotGlyph)object).seriesWidth == this.seriesWidth && ComparatorUtils.equals(((RangePlotGlyph)object).rangeAxisGlyph, this.rangeAxisGlyph);
    }

    public Object clone() throws CloneNotSupportedException {
        RangePlotGlyph rangePlotGlyph = (RangePlotGlyph)super.clone();
        if (this.rangeAxisGlyph != null) {
            rangePlotGlyph.rangeAxisGlyph = (RangeAxisGlyph)this.rangeAxisGlyph.clone();
        }
        return rangePlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.rangeAxisGlyph != null) {
            jSONObject.put("rangeAxisGlyph", this.rangeAxisGlyph.toJSONObject(repository));
        }
        jSONObject.put("seriesWidth", this.seriesWidth);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "RangePlotGlyph";
    }

    public String getChartType() {
        return "Range";
    }
}

