/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.ScreenResolution;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Arc3DStyleBase;
import com.fr.chart.chartglyph.ArcHighLightStyleBase;
import com.fr.chart.chartglyph.ArcPlane3DStyle;
import com.fr.chart.chartglyph.ArcTopDownShadeStyle;
import com.fr.chart.chartglyph.ArcTransparentChartStyle;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataPointLabelInfo;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.stable.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class PiePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 7862387644048932954L;
    public static final double START_ANGLE = 90.0;
    private static final double LABEL_ANGLE = 10.0;
    private static final double MARGIN_WIDTH = 0.01;
    protected static final double FIRST_QUA = 90.0;
    protected static final double SECOND_QUA = 180.0;
    protected static final double THRID_QUA = 270.0;
    private static final double FOUTH_QUA = 360.0;
    private static final double BEST_RAD = 0.9;
    protected static final double WHEN_MORE_RAD = 0.8;
    protected static final double MOVE_GAP = 0.1;
    protected static final double NO_BOUNDS = 0.9;
    protected static final double RADIO_PERCENT = 1.2;
    private static final double BASE_PERCENT = 1.31;
    private static final double RADIUS_PERCENT_DIFF = 0.05;
    private static final double RADIUS_MIN_PERCENR = 0.5;
    private static final int MAX_SERIES_MODE = 5;
    protected static final double OUTSIDE_LABEL_RADIUS_COEFFICIENT = 1.3;
    private Arc3DStyleBase arc3DStyleBase;
    private ArcHighLightStyleBase arcHighLightStyle;
    protected transient double radius = 0.0;
    private transient double maxLabelWidth = 0.0;
    private transient ArrayList leftUp = new ArrayList();
    private transient ArrayList rightUp = new ArrayList();
    private transient ArrayList leftDown = new ArrayList();
    private transient ArrayList rightDown = new ArrayList();
    protected double radiusPercent = 0.9;

    protected double getSeriesStartAngle(int n2, int n3) {
        double d2 = 90.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            d2 += this.getPercent(i2, n2) * 360.0;
        }
        return d2;
    }

    protected double getHalfAngle(double d2, int n2, int n3) {
        return d2 + this.getPercent(n2, n3) * 360.0 / 2.0;
    }

    protected double getTotalValue(int n2) {
        double d2 = 0.0;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            d2 += Math.abs(dataPoint4Pie.getValue());
        }
        return d2;
    }

    protected double getPercent(int n2, int n3) {
        double d2 = this.getTotalValue(n3);
        if (d2 <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n2);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
        return Math.abs(dataPoint4Pie.getValue()) / d2;
    }

    private void clearList() {
        this.leftUp.clear();
        this.leftDown.clear();
        this.rightUp.clear();
        this.rightDown.clear();
    }

    private void sortList() {
        this.bubbleSort(this.leftUp);
        this.bubbleSort(this.leftDown);
        this.bubbleSort(this.rightUp);
        this.bubbleSort(this.rightDown);
    }

    private void bubbleSort(ArrayList arrayList) {
        PointAndAngle[] pointAndAngleArray = arrayList.toArray(new PointAndAngle[0]);
        int n2 = pointAndAngleArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            PointAndAngle pointAndAngle;
            int n3;
            for (n3 = i2; n3 < n2; ++n3) {
                if (!(pointAndAngleArray[n3].centerAngle > pointAndAngleArray[n3 + 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n3];
                pointAndAngleArray[n3] = pointAndAngleArray[n3 + 1];
                pointAndAngleArray[n3 + 1] = pointAndAngle;
            }
            for (n3 = --n2; n3 > i2; --n3) {
                if (!(pointAndAngleArray[n3].centerAngle < pointAndAngleArray[n3 - 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n3];
                pointAndAngleArray[n3] = pointAndAngleArray[n3 - 1];
                pointAndAngleArray[n3 - 1] = pointAndAngle;
            }
        }
        arrayList.clear();
        for (PointAndAngle pointAndAngle : pointAndAngleArray) {
            arrayList.add(pointAndAngle);
        }
    }

    public void layoutAxisGlyph(int n2) {
    }

    protected void initLabelData(int n2, int n3) {
        this.radius = this.getPieDimension(n2) / 2.0;
        this.maxLabelWidth = this.getMaxLabelWidth(n2, n3);
        this.getSeriesCountWithQuadrant(n2);
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            this.deal4EachCategory(i2, n2);
        }
        this.dealLabelBoundsInOrder();
    }

    protected void dealLabelBoundsOutPlotBounds(Rectangle2D rectangle2D, GeneralPath generalPath, DataPoint dataPoint, List list, int n2) {
        String string;
        double d2;
        int n3;
        if (!this.isOutsideLabel(dataPoint.getSeriesIndex(), dataPoint.getCategoryIndex())) {
            super.dealLabelBoundsOutPlotBounds(rectangle2D, generalPath, dataPoint, list, n2);
            return;
        }
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataPoint;
        if (!dataPoint4Pie.isShowLabel()) {
            return;
        }
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty(dataPoint.getDataLabel().text)) {
            return;
        }
        if (rectangle2D.getX() >= this.getBounds().getX() && rectangle2D.getMaxX() <= this.getBounds().getMaxX()) {
            return;
        }
        double d3 = rectangle2D.getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            d3 = rectangle2D.getMaxX() - this.getBounds().getX();
        } else if (rectangle2D.getMaxX() > this.getBounds().getMaxX()) {
            d3 = this.getBounds().getMaxX() - rectangle2D.getX();
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        String string2 = dataPoint4Pie.getDataLabel().getText();
        int n4 = ScreenResolution.getScreenResolution();
        for (n3 = 0; n3 < string2.length() && !((d2 = GlyphUtils.calculateTextDimensionWithNoRotation(string = string2.substring(0, n3) + "\u2026", textAttr, n4).getWidth()) > d3); ++n3) {
        }
        if (n3 == 0) {
            dataPoint4Pie.setShowText("\u2026");
        } else {
            dataPoint4Pie.setShowText(string2.substring(0, n3 - 1) + "\u2026");
        }
        double d4 = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint4Pie.getShowText(), textAttr, n4).getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            rectangle2D.setRect(this.getBounds().getX(), rectangle2D.getY(), d4, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d4, rectangle2D.getHeight());
        }
        dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
    }

    protected void deal4EachCategory(int n2, int n3) {
        this.initLabelData(n2, n3);
        this.dealWithDataSeries(n2, n3);
    }

    protected void dealWithDataSeries(int n2, int n3) {
        this.arc3DStyleBase = null;
        this.arcHighLightStyle = null;
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            if (dataPoint4Pie.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint4Pie);
            dataPoint4Pie.setDrawImpl(shapeGlyph);
            if (this.getSubType() != 1) continue;
            this.dealPlotStyle(this.plotStyle, dataPoint4Pie);
        }
        this.dealWithCategoryLabels(n2, n3);
    }

    private boolean isExistOuterLabels() {
        return !this.leftUp.isEmpty() || !this.leftDown.isEmpty() || !this.rightUp.isEmpty() || !this.rightDown.isEmpty();
    }

    protected void dealWithCategoryLabels(int n2, int n3) {
        if (this.isExistOuterLabels()) {
            this.dealOutSideLabels(n2, n3);
            this.dealLabelBoundsOverLay(this.leftUp, n3, 0, 90.0, 180.0, true);
            this.dealLabelBoundsOverLay(this.leftDown, n3, 0, 180.0, 270.0, true);
            this.dealLabelBoundsOverLay(this.rightUp, n3, 0, 0.0, 90.0, false);
            this.dealLabelBoundsOverLay(this.rightDown, n3, 0, 270.0, 360.0, false);
        }
        this.dealInsideLabels(n2, n3);
    }

    private void dealOutSideLabels(int n2, int n3) {
        double d2 = 0.0;
        d2 = Math.max(d2, this.dealEachArea(this.leftUp, n3));
        d2 = Math.max(d2, this.dealEachArea(this.leftDown, n3));
        d2 = Math.max(d2, this.dealEachArea(this.rightUp, n3));
        if ((d2 = Math.max(d2, this.dealEachArea(this.rightDown, n3))) == 0.0) {
            return;
        }
        this.radiusPercent -= 0.05;
        if (this.radiusPercent >= 0.5) {
            this.deal4EachCategory(n2, n3);
        }
    }

    private void dealLabelBoundsOverLay(ArrayList arrayList, int n2, int n3, double d2, double d3, boolean bl) {
        if (n3 >= 2) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        boolean bl2 = true;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i2);
            if (pointAndAngle.dataPoint4Pie.getDataLabel() == null || StringUtils.isEmpty(pointAndAngle.dataPoint4Pie.getDataLabel().text)) continue;
            Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
            if (generalPath.intersects(rectangle2D)) {
                if (this.adjustLabelBoundsY(generalPath, pointAndAngle, n2, d2, d3, bl)) continue;
                bl2 = false;
                break;
            }
            generalPath.append(rectangle2D, false);
        }
        if (bl2) {
            return;
        }
        this.dealLabelBoundsOverLay(arrayList, n2, n3 + 1, d2, d3, !bl);
    }

    protected boolean adjustLabelBoundsY(GeneralPath generalPath, PointAndAngle pointAndAngle, int n2, double d2, double d3, boolean bl) {
        Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
        double d4 = pointAndAngle.centerAngle;
        while (generalPath.intersects(rectangle2D)) {
            d4 = bl ? (d4 += 1.0) : (d4 -= 1.0);
            this.calculateLabelBoundsWithAngle(d4, pointAndAngle, n2, rectangle2D);
        }
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        generalPath.append(rectangle2D, false);
        if (d4 < d2 || d4 > d3) {
            return false;
        }
        if (!this.isGuideLineShow(pointAndAngle.dataPoint4Pie) || !pointAndAngle.dataPoint4Pie.isShowLabel()) {
            return true;
        }
        GeneralPath generalPath2 = new GeneralPath();
        double d5 = 0.0;
        double d6 = 0.0;
        d5 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? rectangle2D.getX() + rectangle2D.getWidth() + 2.0 : rectangle2D.getX() - 2.0;
        d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        generalPath2.moveTo(d5, d6);
        d5 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d5 += 0.1 * this.radius) : (d5 -= 0.1 * this.radius);
        generalPath2.lineTo(d5, d6);
        Point2D point2D = this.getCenterPoint(pointAndAngle.dataPoint4Pie.getSeriesIndex(), pointAndAngle.dataPoint4Pie.getCategoryIndex());
        double d7 = this.radius + 2.0;
        d5 = point2D.getX() + d7 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d6 = point2D.getY() - d7 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath2.lineTo(d5, d6);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath2);
        return true;
    }

    private double dealEachArea(ArrayList arrayList, int n2) {
        double d2 = this.getBounds().getX() + this.getBounds().getWidth();
        double d3 = this.getBounds().getX();
        double d4 = 0.0;
        this.checkPointsShowLabel(arrayList, n2);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i2);
            if (pointAndAngle.dataPoint4Pie.getDataLabel() == null) continue;
            this.dealOutsideLabelBoundsWhenNormal(double_, pointAndAngle, n2);
            if (((RectangularShape)double_).getX() < d3) {
                d4 = d3 - ((RectangularShape)double_).getX();
            }
            if (!(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() > d2)) continue;
            d4 = ((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() - d2;
        }
        return d4;
    }

    private void checkPointsShowLabel(ArrayList arrayList, int n2) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i2);
            TextGlyph textGlyph = pointAndAngle.dataPoint4Pie.getDataLabel();
            if (textGlyph == null || !StringUtils.isNotEmpty(textGlyph.getText())) continue;
            d2 += this.getLabelDim(pointAndAngle.dataPoint4Pie, n2).getHeight();
        }
        if (d2 > this.radius) {
            this.removeAngleExtendMinPoint(arrayList);
            this.checkPointsShowLabel(arrayList, n2);
        }
    }

    private void removeAngleExtendMinPoint(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(0);
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            PointAndAngle pointAndAngle2 = (PointAndAngle)arrayList.get(i2);
            if (!this.isSmallerThan(pointAndAngle2, pointAndAngle)) continue;
            pointAndAngle = pointAndAngle2;
        }
        pointAndAngle.dataPoint4Pie.setShowLabel(false);
        arrayList.remove(pointAndAngle);
    }

    protected boolean isSmallerThan(PointAndAngle pointAndAngle, PointAndAngle pointAndAngle2) {
        return pointAndAngle.getExtendAngle() < pointAndAngle2.getExtendAngle();
    }

    private void dealInsideLabels(int n2, int n3) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            TextGlyph textGlyph;
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            if (dataPoint4Pie.isValueIsNull() || this.isOutsideLabel(i2, n2) || (textGlyph = dataPoint4Pie.getDataLabel()) == null || !StringUtils.isNotEmpty(textGlyph.getText())) continue;
            this.dealInsideLabelBounds(dataPoint4Pie, n3);
        }
    }

    protected void dealPlotStyle(int n2, DataPoint4Pie dataPoint4Pie) {
        ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint4Pie.getDrawImpl();
        Arc2D.Double double_ = (Arc2D.Double)dataPoint4Pie.getShape();
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            if (n2 == 1) {
                double d2;
                int n3 = dataPoint4Pie.getCategoryIndex();
                int n4 = dataPoint4Pie.getSeriesIndex();
                Point2D point2D = this.getCenterPoint(n4, n3);
                if (this.arc3DStyleBase == null) {
                    d2 = this.radius / 1.31;
                    this.arc3DStyleBase = new Arc3DStyleBase(this.getArcWithRadius(d2));
                }
                chartStyle = new ArcPlane3DStyle(color, double_, double_, true);
                d2 = 0.1 * this.radius / 3.0;
                double d3 = this.getSeriesStartAngle(n3, n4);
                double d4 = this.getHalfAngle(d3, n4, n3);
                double d5 = this.radius / 1.2;
                double d6 = d2 * Math.cos(Math.toRadians(d4)) + point2D.getX() - d5;
                double d7 = -d2 * Math.sin(Math.toRadians(d4)) + point2D.getY() - d5;
                double_.setFrame(d6, d7, d5 * 2.0, d5 * 2.0);
            } else if (n2 == 2) {
                if (this.arcHighLightStyle == null) {
                    this.arcHighLightStyle = new ArcHighLightStyleBase(this.getArcWithRadius(this.radius));
                }
                chartStyle = new ArcTopDownShadeStyle(color, double_, double_, true);
                int n5 = dataPoint4Pie.getCategoryIndex();
                int n6 = dataPoint4Pie.getSeriesIndex();
                Point2D point2D = this.getCenterPoint(n6, n5);
                double d8 = this.radius / 1.2;
                double_.setFrame(point2D.getX() - d8, point2D.getY() - d8, d8 * 2.0, d8 * 2.0);
            } else if (n2 == 4) {
                chartStyle = new ArcTopDownShadeStyle(color, double_, double_, true);
            } else if (n2 == 5) {
                chartStyle = new ArcTransparentChartStyle(color, double_, true);
            }
            if (chartStyle != null) {
                if (this.isExistAttrByResult(dataPoint4Pie, AttrAlpha.class)) {
                    chartStyle.setAlpha(shapeGlyph.getAlpha());
                }
                if (this.isExistAttrByResult(dataPoint4Pie, AttrBorder.class)) {
                    chartStyle.setBorderWidth(shapeGlyph.getBorderStyle());
                    chartStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? Color.black : shapeGlyph.getBorderColor());
                }
                dataPoint4Pie.setDataPointStyle(chartStyle);
            }
        }
    }

    private Arc2D.Double getArcWithRadius(double d2) {
        Point2D point2D = this.getCenterPoint(0, 0);
        return new Arc2D.Double(point2D.getX() - d2, point2D.getY() - d2, 2.0 * d2, 2.0 * d2, 0.0, 360.0, 0);
    }

    public int getSubType() {
        return 1;
    }

    protected ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint) {
        Shape shape = this.getArc2D(dataPoint);
        ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        return shapeGlyph;
    }

    protected Point2D getCenterPoint(int n2, int n3) {
        double d2 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d3 = (double)n3 * d2 + d2 / 2.0;
        return new Point2D.Double(d3, this.getBounds().getHeight() / 2.0);
    }

    protected Shape getArc2D(DataPoint dataPoint) {
        int n2 = dataPoint.getSeriesIndex();
        int n3 = dataPoint.getCategoryIndex();
        double d2 = this.getSeriesStartAngle(n3, n2) % 360.0;
        Point2D point2D = this.getCenterPoint(n2, n3);
        return this.getDataPointShape(point2D, d2, this.radius, n2, n3);
    }

    public void dealLeadLineSeries() {
        int n2 = this.getCategoryCount();
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                DataSeries dataSeries = this.getSeries(i3);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i2);
                if (dataPoint4Pie.isValueIsNull()) continue;
                ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint4Pie.getDrawImpl();
                double d2 = this.getHalfAngle(this.getSeriesStartAngle(i2, i3), i3, i2);
                if (shapeGlyph == null || shapeGlyph.getShape() == null || !(shapeGlyph.getShape() instanceof Arc2D)) continue;
                this.dealLeadLine((Arc2D)shapeGlyph.getShape(), dataPoint4Pie, d2 % 360.0);
            }
        }
    }

    protected double getPieDimension(int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = rectangle2D.getWidth() / (double)this.getCategoryCount();
        double d3 = 0.0;
        d3 = d2 > rectangle2D.getHeight() ? rectangle2D.getHeight() / 1.2 : d2 / 1.2;
        d3 = this.deal4BestRad(d3, n2);
        return d3;
    }

    protected double deal4BestRad(double d2, int n2) {
        DataPointLabelInfo dataPointLabelInfo = new DataPointLabelInfo();
        this.getConditionCollection().changeStyleConditionWithInfo(dataPointLabelInfo, this.getSeries(0).getDataPoint(n2), null);
        if (dataPointLabelInfo != null && dataPointLabelInfo.getPosition() == 6) {
            d2 *= this.radiusPercent;
            if (this.getCategoryCount() > 1) {
                d2 *= 0.8;
            }
        }
        return d2;
    }

    protected Shape getDataPointShape(Point2D point2D, double d2, double d3, int n2, int n3) {
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - d3, point2D.getY() - d3, 2.0 * d3, 2.0 * d3, d2, this.getPercent(n2, n3) * 360.0, 2);
        return double_;
    }

    protected void getSeriesCountWithQuadrant(int n2) {
        this.clearList();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            if (this.getSeries(i2).getDataPoint(n2).isValueIsNull() || !this.isOutsideLabel(i2, n2)) continue;
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            double d2 = this.getHalfAngle(this.getSeriesStartAngle(n2, i2), i2, n2) % 360.0;
            DecimalFormat decimalFormat = new DecimalFormat("######0.00");
            if ((d2 = Double.valueOf(decimalFormat.format(d2)).doubleValue()) >= 90.0 && d2 <= 180.0) {
                this.leftUp.add(new PointAndAngle(dataPoint4Pie, d2));
                continue;
            }
            if (d2 > 180.0 && d2 <= 270.0) {
                this.leftDown.add(new PointAndAngle(dataPoint4Pie, d2));
                continue;
            }
            if (d2 > 270.0 && d2 <= 360.0) {
                this.rightDown.add(new PointAndAngle(dataPoint4Pie, d2));
                continue;
            }
            this.rightUp.add(new PointAndAngle(dataPoint4Pie, d2));
        }
        this.sortList();
    }

    protected void dealLeadLine(Arc2D arc2D, DataPoint4Pie dataPoint4Pie, double d2) {
        TextGlyph textGlyph;
        Rectangle2D rectangle2D;
        if (this.isGuideLineShow(dataPoint4Pie) && !arc2D.intersects(rectangle2D = (textGlyph = dataPoint4Pie.getDataLabel()).getBounds())) {
            Point2D point2D = Cylinder.getArcPoint(arc2D, d2);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            this.setDataPointBoundsWithXYWH(dataPoint4Pie, d2, rectangle2D, d3, d4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDataPointBoundsWithXYWH(DataPoint4Pie dataPoint4Pie, double d2, Rectangle2D rectangle2D, double d3, double d4) {
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getY();
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        double d9 = this.bounds.getHeight() * 0.01;
        if (d3 < d5 - d9) {
            d7 = rectangle2D.getX() - d9;
            d8 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else if (d3 > d5 + rectangle2D.getWidth() + d9) {
            d7 = rectangle2D.getX() + rectangle2D.getWidth();
            d8 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d5 = rectangle2D.getX() + rectangle2D.getWidth() - d9;
            d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else if (this.isInTopAreaOrBottomArea(d2)) {
            if (d4 > rectangle2D.getY() + rectangle2D.getHeight()) {
                d7 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d8 = rectangle2D.getY() + rectangle2D.getHeight() + d9;
                d5 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d6 = rectangle2D.getY() + rectangle2D.getHeight();
            } else {
                if (!(d4 < rectangle2D.getY())) return;
                d7 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d8 = rectangle2D.getY() - d9;
                d5 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d6 = rectangle2D.getY();
            }
        } else if (d2 >= 100.0 && d2 <= 260.0) {
            d7 = rectangle2D.getX() + rectangle2D.getWidth();
            d8 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d5 = rectangle2D.getX() + rectangle2D.getWidth() - d9;
            d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else {
            d7 = rectangle2D.getX() + d9;
            d8 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d5 = rectangle2D.getX() + d9 * 2.0;
            d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        }
        this.makeSureLeadLinePath(dataPoint4Pie, d3, d4, d7, d8, d5, d6);
    }

    private boolean isInTopAreaOrBottomArea(double d2) {
        return d2 > 80.0 && d2 < 100.0 || d2 > 260.0 && d2 < 280.0;
    }

    private void makeSureLeadLinePath(DataPoint4Pie dataPoint4Pie, double d2, double d3, double d4, double d5, double d6, double d7) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d2, (float)d3);
        generalPath.curveTo((float)d4, (float)d5, (float)(d2 + d6) / 2.0f, (float)(d3 + d7) / 2.0f, (float)d6, (float)d7);
        dataPoint4Pie.setLeadLine(generalPath);
    }

    protected boolean isGuideLineShow(DataPoint dataPoint) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return false;
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        String string = textGlyph.getText();
        return string != null && attrContents.isShowGuidLine() && textGlyph.getBounds() != null;
    }

    private Rectangle2D avoidCoverLabelBounds(GeneralPath generalPath, Rectangle2D rectangle2D, double d2, double d3, double d4, double d5) {
        if (rectangle2D == null) {
            return null;
        }
        double d6 = d2;
        this.whileTmp(generalPath, rectangle2D, d6, d4, d5, d3);
        if (!generalPath.intersects(rectangle2D)) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
            generalPath.append(double_, false);
            return double_;
        }
        return null;
    }

    private void whileTmp(GeneralPath generalPath, Rectangle2D rectangle2D, double d2, double d3, double d4, double d5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(rectangle2D);
        double d6 = 0.0;
        double d7 = 0.5;
        while (generalPath.intersects(rectangle2D)) {
            d2 += d7;
            if (d6 > 360.0) {
                rectangle2D.setRect(double_);
                break;
            }
            double d8 = d3 + d5 * Math.cos(Math.PI * d2 / 180.0);
            double d9 = d4 - d5 * Math.sin(Math.PI * d2 / 180.0);
            double d10 = 45.0;
            if (d2 > 90.0 && d2 < d10 + 180.0) {
                rectangle2D.setRect(d8 - rectangle2D.getWidth(), d9 - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            } else if (d2 >= d10 + 180.0 && d2 < 270.0) {
                rectangle2D.setRect(d8 - rectangle2D.getWidth(), d9 - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else if (d2 >= 270.0 && d2 < d10 + 270.0) {
                rectangle2D.setRect(d8, d9 - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                rectangle2D.setRect(d8, d9 - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            d6 += d7;
        }
    }

    public void drawShape4Series(Graphics graphics, int n2) {
        DataPoint4Pie dataPoint4Pie;
        int n3;
        int n4;
        DataSeries dataSeries;
        int n5;
        super.drawShape4Series(graphics, n2);
        int[] nArray = this.getDrawSequence();
        int n6 = this.getSeriesSize();
        for (n5 = 0; n5 < n6; ++n5) {
            dataSeries = this.getSeries(nArray[n5]);
            n4 = dataSeries.getDataPointCount();
            for (n3 = 0; n3 < n4; ++n3) {
                dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
                if (!dataPoint4Pie.isBorderDefault()) continue;
                dataPoint4Pie.drawOnlyBorder(graphics, n2);
            }
        }
        n6 = this.getSeriesSize();
        for (n5 = 0; n5 < n6; ++n5) {
            dataSeries = this.getSeries(nArray[n5]);
            n4 = dataSeries.getDataPointCount();
            for (n3 = 0; n3 < n4; ++n3) {
                dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
                if (dataPoint4Pie.isBorderDefault()) continue;
                dataPoint4Pie.drawOnlyBorder(graphics, n2);
            }
        }
    }

    protected double changeRadius(int n2, int n3) {
        return this.radius * 1.3;
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            if (this.isOutsideLabel(dataPoint.getSeriesIndex(), dataPoint.getCategoryIndex())) {
                this.dealOutsideLabelBounds(dataPoint, n2);
            } else {
                this.dealInsideLabelBounds(dataPoint, n2);
            }
        }
    }

    protected boolean isOutsideLabel(int n2, int n3) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, this.getSeries(n2));
        return attrContents.getPosition() == 6 || attrContents.isShowGuidLine();
    }

    private void dealOutsideLabelBounds(DataPoint dataPoint, int n2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n3 = dataPoint.getCategoryIndex();
        int n4 = dataPoint.getSeriesIndex();
        double d2 = this.getSeriesStartAngle(n3, n4) % 360.0;
        double d3 = this.getHalfAngle(d2, n4, n3) % 360.0;
        this.dealOutsideLabelBoundsWhenNormal(double_, new PointAndAngle((DataPoint4Pie)dataPoint, d3), n2);
        dataPoint.getDataLabel().setBounds(double_);
    }

    protected void dealInsideLabelBounds(DataPoint dataPoint, int n2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n3 = dataPoint.getSeriesIndex();
        int n4 = dataPoint.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n3, n4);
        double d2 = this.getLabelDim(dataPoint, n2).getHeight();
        double d3 = this.getLabelDim(dataPoint, n2).getWidth();
        double d4 = 0.5;
        double d5 = this.changeRadius(n4, n3);
        TextGlyph textGlyph = dataPoint.getDataLabel();
        double d6 = this.getSeriesStartAngle(n4, n3) % 360.0;
        double d7 = this.getHalfAngle(d6, n3, n4) % 360.0;
        Shape shape = this.getDataPointShape(point2D, d6, d5, n3, n4);
        double d8 = d5 * Math.cos(Math.PI * d7 / 180.0);
        double d9 = d5 * Math.sin(Math.PI * d7 / 180.0);
        for (d4 = 0.5; d4 < 1.0; d4 += 0.1) {
            double d10 = point2D.getX() + d8 * d4;
            double d11 = point2D.getY() - d9 * d4;
            double d12 = d10 - d3 / 2.0;
            double d13 = d11 - d2 / 2.0;
            ((Rectangle2D)double_).setRect(d12, d13, d3, d2);
            if (!this.isNotNeedMoveChangeLabelRadius(shape, double_)) continue;
            textGlyph.setBounds(double_);
            break;
        }
        if (d4 >= 0.9) {
            textGlyph.setBounds(null);
        }
    }

    protected boolean isNotNeedMoveChangeLabelRadius(Shape shape, Rectangle2D rectangle2D) {
        return shape == null ? false : shape.contains(rectangle2D);
    }

    private void dealOutsideLabelBoundsWhenNormal(Rectangle2D rectangle2D, PointAndAngle pointAndAngle, int n2) {
        Point2D point2D = this.calculateLabelBoundsWithAngle(pointAndAngle.centerAngle, pointAndAngle, n2, rectangle2D);
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        if (this.isGuideLineShow(pointAndAngle.dataPoint4Pie)) {
            this.dealWidthLine(point2D, pointAndAngle);
        }
    }

    protected Point2D calculateLabelBoundsWithAngle(double d2, PointAndAngle pointAndAngle, int n2, Rectangle2D rectangle2D) {
        int n3 = pointAndAngle.dataPoint4Pie.getSeriesIndex();
        int n4 = pointAndAngle.dataPoint4Pie.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n3, n4);
        Dimension2D dimension2D = this.getLabelDim(pointAndAngle.dataPoint4Pie, n2);
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        double d5 = this.plotStyle != 1 ? this.radius * 1.2 : this.radius;
        double d6 = point2D.getX() + d5 * Math.cos(Math.PI * d2 / 180.0);
        double d7 = point2D.getY() - d5 * Math.sin(Math.PI * d2 / 180.0);
        double d8 = (this.plotStyle != 1 ? this.radius : this.radius / 1.2) * 0.1 + 2.0;
        if (pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0) {
            rectangle2D.setRect(d6 - d8 - d4, d7 - d3 / 2.0, d4, d3);
        } else {
            rectangle2D.setRect(d6 + d8, d7 - d3 / 2.0, d4, d3);
        }
        return point2D;
    }

    protected void dealWidthLine(Point2D point2D, PointAndAngle pointAndAngle) {
        double d2 = this.plotStyle != 1 ? this.radius : this.radius / 1.2;
        GeneralPath generalPath = new GeneralPath();
        double d3 = d2 + 2.0;
        double d4 = point2D.getX() + d3 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        double d5 = point2D.getY() - d3 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.moveTo(d4, d5);
        d3 = d2 * 1.2;
        d4 = point2D.getX() + d3 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d5 = point2D.getY() - d3 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.lineTo(d4, d5);
        d4 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d4 -= d2 * 0.1) : (d4 += d2 * 0.1);
        generalPath.lineTo(d4, d5);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath);
    }

    private double getLabelMargin(int n2, double d2) {
        return Math.max((this.bounds.getHeight() / 2.0 - d2 * (double)n2) / (double)(n2 + 1), 0.0);
    }

    protected Dimension2D getLabelDim(DataPoint dataPoint, int n2) {
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty(dataPoint.getDataLabel().getText())) {
            return new Dimension(0, 0);
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n2);
    }

    private Rectangle2D dealOutsideLabelBoundsWithLargeSeriesSize(Rectangle2D rectangle2D, double d2, DataPoint dataPoint, int n2) {
        int n3 = dataPoint.getCategoryIndex();
        Dimension2D dimension2D = this.getLabelDim(dataPoint, n2);
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        double d5 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d6 = (d5 - this.getPieDimension(n3)) / 2.0;
        double d7 = (d6 - this.maxLabelWidth) / 2.0;
        DecimalFormat decimalFormat = new DecimalFormat("######0.00");
        d2 = Double.valueOf(decimalFormat.format(d2));
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        if (d2 <= 180.0 && d2 >= 90.0) {
            d8 = this.getLabelMargin(this.leftUp.size(), d3);
            d9 = (d7 > 0.0 ? d6 - d7 - d4 : d5 * 0.01) + d5 * (double)n3;
            int n4 = this.leftUp.indexOf(new Double(d2));
            d10 = (double)n4 * (d8 + d3) + d8;
            if (n4 >= 0 && n4 < this.leftUp.size()) {
                this.leftUp.set(n4, new Double(Double.MAX_VALUE));
            }
        } else if (d2 <= 270.0 && d2 > 180.0) {
            d8 = this.getLabelMargin(this.leftDown.size(), d3);
            d9 = (d7 > 0.0 ? d6 - d7 - d4 : d5 * 0.01) + d5 * (double)n3;
            int n5 = this.leftDown.indexOf(new Double(d2));
            d10 = (double)n5 * (d8 + d3) + d8 + this.bounds.getHeight() / 2.0;
            if (n5 >= 0 && n5 < this.leftDown.size()) {
                this.leftDown.set(n5, new Double(Double.MAX_VALUE));
            }
        } else if (d2 <= 360.0 && d2 > 270.0) {
            d8 = this.getLabelMargin(this.rightDown.size(), d3);
            d9 = (d7 > 0.0 ? d6 + this.getPieDimension(n3) + d7 : d5 * 0.99 - d4) + d5 * (double)n3;
            int n6 = this.rightDown.indexOf(new Double(d2));
            d10 = this.bounds.getHeight() - (double)n6 * (d3 + d8);
            if (n6 >= 0 && n6 < this.rightDown.size()) {
                this.rightDown.set(n6, new Double(Double.MAX_VALUE));
            }
        } else {
            d8 = this.getLabelMargin(this.rightUp.size(), d3);
            d9 = (d7 > 0.0 ? d6 + this.getPieDimension(n3) + d7 : d5 * 0.99 - d4) + d5 * (double)n3;
            int n7 = this.rightUp.indexOf(new Double(d2));
            d10 = this.bounds.getHeight() / 2.0 - (double)n7 * (d3 + d8);
            if (n7 >= 0 && n7 < this.rightUp.size()) {
                this.rightUp.set(n7, new Double(Double.MAX_VALUE));
            }
        }
        rectangle2D.setRect(d9, d10, d4, d3);
        return rectangle2D;
    }

    protected double getMaxLabelWidth(int n2, int n3) {
        double d2 = 0.0;
        int n4 = this.getSeriesSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            DataPoint dataPoint = this.getSeries(i2).getDataPoint(n2);
            AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
            TextAttr textAttr = attrContents.getTextAttr();
            if (textAttr == null || dataPoint.getDataLabel() == null) continue;
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n3);
            d2 = Math.max(d2, dimension2D.getWidth());
        }
        return d2;
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.arc3DStyleBase != null) {
            this.arc3DStyleBase.paintStyle(graphics);
        } else if (this.arcHighLightStyle != null) {
            this.arcHighLightStyle.paintStyle(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n2);
    }

    public boolean equals(Object object) {
        return object instanceof PiePlotGlyph;
    }

    public String getPlotGlyphType() {
        return "PiePlotGlyph";
    }

    public String getChartType() {
        return "Pie";
    }

    public class PointAndAngle {
        public double centerAngle;
        public DataPoint4Pie dataPoint4Pie;

        public PointAndAngle(DataPoint4Pie dataPoint4Pie, double d2) {
            this.dataPoint4Pie = dataPoint4Pie;
            this.centerAngle = d2;
        }

        public double getExtendAngle() {
            Arc2D.Double double_ = (Arc2D.Double)this.dataPoint4Pie.getShape();
            if (double_ != null) {
                return double_.extent;
            }
            return 0.0;
        }

        public Arc2D.Double getArcWithRadius(double d2) {
            Arc2D.Double double_ = (Arc2D.Double)this.dataPoint4Pie.getShape();
            if (double_ != null) {
                return null;
            }
            Point point = new Point((int)(double_.getX() + double_.getWidth() / 2.0), (int)(double_.getY() + double_.getHeight() / 2.0));
            return new Arc2D.Double(((Point2D)point).getX() - d2, ((Point2D)point).getY() - d2, 2.0 * d2, 2.0 * d2, double_.getAngleStart(), double_.getAngleExtent(), 0);
        }
    }
}

