/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterInterval
implements Serializable,
XMLable {
    public static final String XML_TAG = "MeterInterval";
    private static final long serialVersionUID = 1530982090622488257L;
    private Formula beginValue;
    private Formula endValue;
    private Color backgroundColor = Color.BLACK;
    private String intervalPartName;

    public MeterInterval() {
        this("", new Formula("0.0"), new Formula("5.0"));
    }

    public MeterInterval(String string, Formula formula, Formula formula2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        this.intervalPartName = string;
        this.beginValue = formula;
        this.endValue = formula2;
    }

    public String getIntervalPartName() {
        return this.intervalPartName;
    }

    public void setIntervalPartName(String string) {
        this.intervalPartName = string == null ? "" : string;
    }

    public Formula getBeginValue() {
        return this.beginValue;
    }

    public void setBeginValue(Formula formula) {
        this.beginValue = formula;
    }

    public Formula getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Formula formula) {
        this.endValue = formula;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public double getStartValueResult() {
        double d2 = 0.0;
        Number number = ChartBaseUtils.formula2Number(this.beginValue);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public double getEndValueResult() {
        double d2 = 450.0;
        Number number = ChartBaseUtils.formula2Number(this.endValue);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.beginValue != null) {
            list.addAll(Arrays.asList(this.beginValue.dependence(calculatorProvider)));
        }
        if (this.endValue != null) {
            list.addAll(Arrays.asList(this.endValue.dependence(calculatorProvider)));
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.beginValue != null) {
            Utils.dealFormulaValue(this.beginValue, calculator);
        }
        if (this.endValue != null) {
            Utils.dealFormulaValue(this.endValue, calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.beginValue != null) {
            GeneralUtils.dealBuidExecuteSequence(this.beginValue, list, calculator);
        }
        if (this.endValue != null) {
            GeneralUtils.dealBuidExecuteSequence(this.endValue, list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.beginValue != null) {
            this.beginValue.modColumnRow(mOD_COLUMN_ROW);
        }
        if (this.endValue != null) {
            this.endValue.modColumnRow(mOD_COLUMN_ROW);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("label", this.getIntervalPartName());
        if (this.getBackgroundColor() != null) {
            xMLPrintWriter.attr("backgroudColor", this.getBackgroundColor().getRGB());
        }
        if (this.beginValue != null) {
            xMLPrintWriter.attr("beginValue", this.getBeginValue().toString());
        }
        if (this.endValue != null) {
            xMLPrintWriter.attr("endValue", this.getEndValue().toString());
        }
        xMLPrintWriter.end();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (XML_TAG.equals(string)) {
            String string2 = xMLableReader.getAttrAsString("label", null);
            if (string2 != null) {
                this.setIntervalPartName(string2);
            }
            this.setBeginValue(new Formula(xMLableReader.getAttrAsString("beginValue", "0")));
            this.setEndValue(new Formula(xMLableReader.getAttrAsString("endValue", "0")));
            Color color = null;
            string2 = xMLableReader.getAttrAsString("backgroudColor", null);
            if (string2 != null) {
                color = new Color(Integer.parseInt(string2), true);
            }
            this.setBackgroundColor(color);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MeterInterval meterInterval = (MeterInterval)super.clone();
        if (this.beginValue != null) {
            meterInterval.beginValue = (Formula)this.beginValue.clone();
        }
        if (this.endValue != null) {
            meterInterval.endValue = (Formula)this.endValue.clone();
        }
        return meterInterval;
    }

    public boolean equals(Object object) {
        return object instanceof MeterInterval && ComparatorUtils.equals(((MeterInterval)object).intervalPartName, this.intervalPartName) && ComparatorUtils.equals(((MeterInterval)object).backgroundColor, this.backgroundColor) && ComparatorUtils.equals(((MeterInterval)object).getBeginValue(), this.getBeginValue()) && ComparatorUtils.equals(((MeterInterval)object).getEndValue(), this.getEndValue());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("beginValue", ChartBaseUtils.formula2Number(this.beginValue));
        jSONObject.put("endValue", ChartBaseUtils.formula2Number(this.endValue));
        if (this.backgroundColor != null) {
            jSONObject.put("backgroundColor", StableUtils.javaColor2JSColorWithAlpha(this.backgroundColor));
        }
        return jSONObject;
    }
}

