/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldLine3D
extends SpecialGlyph
implements Object3D {
    private static final long serialVersionUID = -5271643180557390028L;
    private static String MOVE_TO = "moveTo";
    private static String LINE_TO = "lineTo";
    private float z = 0.0f;
    private float deep = 60.0f;
    private Projection projection = new Projection();
    private List point_list = new ArrayList();
    private List type_list = new ArrayList();
    private ColorInfo colorInfo = new ColorInfo();
    private int topSize = 0;
    private boolean isFirst = false;
    private ArrayList<ArrayList<GeneralPath>> flatPathArray = new ArrayList();
    private ArrayList<GeneralPath> positivePaths = new ArrayList();
    private ArrayList<Point2D> positiveStartPoint = new ArrayList();
    private ArrayList<Point2D> positiveEndPoint = new ArrayList();
    private ArrayList<GeneralPath> backPaths = new ArrayList();
    private ArrayList<Point2D> backStartPoint = new ArrayList();
    private ArrayList<Point2D> backEndPoint = new ArrayList();

    public FoldLine3D() {
    }

    public FoldLine3D(float f2, float f3) {
        this.setZ(f2);
        this.setDeep(f3);
    }

    public FoldLine3D(double d2, double d3) {
        this.setZ((float)d2);
        this.setDeep((float)d3);
    }

    public void moveTo(float f2, float f3) {
        this.getType_list().add(MOVE_TO);
        this.getPoint_list().add(new Point2D.Float(f2, f3));
    }

    public void lineTo(float f2, float f3) {
        this.getType_list().add(LINE_TO);
        this.getPoint_list().add(new Point2D.Float(f2, f3));
    }

    public void setTopSize(int n2) {
        this.topSize = n2;
    }

    public void setIsFirst(boolean bl) {
        this.isFirst = bl;
    }

    public void closePath() {
        int n2;
        for (n2 = this.getType_list().size() - 1; n2 >= 0 && ComparatorUtils.equals(this.getType_list().get(n2), (Object)LINE_TO); --n2) {
        }
        if (n2 >= 0) {
            this.getType_list().add(LINE_TO);
            this.getPoint_list().add(this.getPoint_list().get(n2));
        }
    }

    @Override
    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.calculatePaths();
        this.paintLeftRight(graphics);
        this.paintFlat(graphics);
        this.paintPositive(graphics);
        this.paintBack(graphics);
        if (this.isFirst) {
            this.paintBottom(graphics);
        }
        this.paintFront(graphics);
    }

    private void paintBottom(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            double d2 = ((Point2D)this.point_list.get(this.point_list.size() - 2)).getX();
            double d3 = ((Point2D)this.point_list.get(this.point_list.size() - 2)).getY();
            double d4 = ((Point2D)this.point_list.get(this.topSize)).getX();
            double d5 = ((Point2D)this.point_list.get(this.topSize)).getY();
            Point2D point2D = this.projection.projectee(d2, d3, this.z);
            Point2D point2D2 = this.projection.projectee(d4, d5, this.z);
            Point2D point2D3 = this.projection.projectee(d4, d5, this.z - this.deep);
            Point2D point2D4 = this.projection.projectee(d2, d3, this.z - this.deep);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.closePath();
            graphics2D.setPaint(color);
            graphics2D.fill(generalPath);
        }
        graphics2D.setPaint(paint);
    }

    private void paintBack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.05, 0.1);
            Color color3 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.25);
            int n2 = this.backPaths.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                GeneralPath generalPath = this.backPaths.get(i2);
                GradientPaint gradientPaint = new GradientPaint(this.backStartPoint.get(i2), color2, this.backEndPoint.get(i2), color3);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.setPaint(paint);
    }

    private void paintPositive(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.35);
            int n2 = this.positivePaths.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                GeneralPath generalPath = this.positivePaths.get(i2);
                GradientPaint gradientPaint = new GradientPaint(this.positiveStartPoint.get(i2), color, this.positiveEndPoint.get(i2), color2);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.setPaint(paint);
    }

    public void paintFlat(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            int n2 = this.flatPathArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ArrayList<GeneralPath> arrayList = this.flatPathArray.get(i2);
                graphics2D.setPaint(color);
                graphics2D.fill(this.getLineShape(arrayList));
            }
        }
        graphics2D.setPaint(paint);
    }

    private GeneralPath getLineShape(ArrayList<GeneralPath> arrayList) {
        GeneralPath generalPath = new GeneralPath();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            generalPath.append(arrayList.get(i2), false);
        }
        return generalPath;
    }

    private void paintLeftRight(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            GeneralPath[] generalPathArray = this.getGeneralPaths();
            GeneralPath generalPath = generalPathArray[generalPathArray.length - 1];
            GeneralPath generalPath2 = generalPathArray[this.topSize - 1];
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.1);
            graphics2D.setPaint(color2);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
        }
        graphics2D.setPaint(paint);
    }

    protected void paintFront(Graphics graphics) {
        GeneralPath generalPath = this.getFrontArea();
        Point2D point2D = this.getTopPoint();
        Point2D point2D2 = this.getBottomPoint();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        Color color = null;
        if (this.getColorInfo() != null && this.getColorInfo().getSeriesAttrColor().getSeriesColor() != null) {
            color = this.getColorInfo().getSeriesAttrColor().getSeriesColor();
        }
        if (color != null) {
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.25);
            GradientPaint gradientPaint = new GradientPaint(point2D2, color, point2D, color2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(generalPath);
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    private void calculatePaths() {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        int n2 = -1;
        for (int i2 = 0; i2 < this.topSize - 1; ++i2) {
            if (ComparatorUtils.equals(this.getType_list().get(i2 + 1), (Object)MOVE_TO)) continue;
            double d2 = ((Point2D)this.getPoint_list().get(i2)).getX();
            double d3 = ((Point2D)this.getPoint_list().get(i2)).getY();
            double d4 = ((Point2D)this.getPoint_list().get(i2 + 1)).getX();
            double d5 = ((Point2D)this.getPoint_list().get(i2 + 1)).getY();
            Point2D point2D = this.getProjection().projectee(d2, d3, this.getZ());
            Point2D point2D2 = this.getProjection().projectee(d4, d5, this.getZ());
            Point2D point2D3 = this.getProjection().projectee(d4, d5, this.getZ() - this.getDeep());
            Point2D point2D4 = this.getProjection().projectee(d2, d3, this.getZ() - this.getDeep());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.closePath();
            if (d3 > d5) {
                this.positivePaths.add(generalPath);
                this.positiveStartPoint.add((Point2D)this.getPoint_list().get(i2));
                this.positiveEndPoint.add((Point2D)this.getPoint_list().get(i2 + 1));
                continue;
            }
            if (d3 < d5) {
                this.backPaths.add(generalPath);
                this.backStartPoint.add((Point2D)this.getPoint_list().get(i2));
                this.backEndPoint.add((Point2D)this.getPoint_list().get(i2 + 1));
                continue;
            }
            if (n2 == i2 - 1) {
                arrayList.add(generalPath);
                if (i2 == this.topSize - 2) {
                    this.flatPathArray.add(arrayList);
                    arrayList = new ArrayList();
                }
            } else {
                if (n2 == -1) {
                    arrayList.add(generalPath);
                    n2 = i2;
                    continue;
                }
                this.flatPathArray.add(arrayList);
                arrayList = new ArrayList();
            }
            n2 = i2;
        }
    }

    @Override
    public Shape getShape() {
        GeneralPath generalPath = this.getFrontArea();
        generalPath.append(this.getLineShape(), false);
        return generalPath;
    }

    public Shape getLineShape() {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath[] generalPathArray = this.getGeneralPaths();
        for (int i2 = 0; i2 < generalPathArray.length; ++i2) {
            generalPath.append(generalPathArray[i2], false);
        }
        return generalPath;
    }

    private GeneralPath[] getGeneralPaths() {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (int i2 = 0; i2 < this.getPoint_list().size() - 1; ++i2) {
            if (ComparatorUtils.equals(this.getType_list().get(i2 + 1), (Object)MOVE_TO)) continue;
            double d2 = ((Point2D)this.getPoint_list().get(i2)).getX();
            double d3 = ((Point2D)this.getPoint_list().get(i2)).getY();
            double d4 = ((Point2D)this.getPoint_list().get(i2 + 1)).getX();
            double d5 = ((Point2D)this.getPoint_list().get(i2 + 1)).getY();
            Point2D point2D = this.getProjection().projectee(d2, d3, this.getZ());
            Point2D point2D2 = this.getProjection().projectee(d4, d5, this.getZ());
            Point2D point2D3 = this.getProjection().projectee(d4, d5, this.getZ() - this.getDeep());
            Point2D point2D4 = this.getProjection().projectee(d2, d3, this.getZ() - this.getDeep());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.closePath();
            arrayList.add(generalPath);
        }
        return arrayList.toArray(new GeneralPath[arrayList.size()]);
    }

    private GeneralPath getFrontArea() {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < this.getPoint_list().size(); ++i2) {
            Point2D point2D = this.getProjection().projectee(((Point2D)this.getPoint_list().get(i2)).getX(), ((Point2D)this.getPoint_list().get(i2)).getY(), this.getZ());
            if (i2 == 0) {
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                continue;
            }
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    private Point2D getBottomPoint() {
        Point2D point2D = (Point2D)this.getPoint_list().get(0);
        double d2 = point2D.getY();
        for (int i2 = 0; i2 < this.getPoint_list().size(); ++i2) {
            if (!(d2 < ((Point2D)this.getPoint_list().get(i2)).getY())) continue;
            point2D = (Point2D)this.getPoint_list().get(i2);
            d2 = point2D.getY();
        }
        return point2D;
    }

    private Point2D getTopPoint() {
        Point2D point2D = (Point2D)this.getPoint_list().get(0);
        double d2 = point2D.getY();
        for (int i2 = 0; i2 < this.getPoint_list().size(); ++i2) {
            if (!(d2 > ((Point2D)this.getPoint_list().get(i2)).getY())) continue;
            point2D = (Point2D)this.getPoint_list().get(i2);
            d2 = point2D.getY();
        }
        return point2D;
    }

    public void setZ(float f2) {
        this.z = f2;
    }

    public float getZ() {
        return this.z;
    }

    @Override
    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    @Override
    public Projection getProjection() {
        return this.projection;
    }

    public void setDeep(float f2) {
        this.deep = f2;
    }

    public float getDeep() {
        return this.deep;
    }

    public void setPoint_list(List list) {
        this.point_list = list;
    }

    public List getPoint_list() {
        return this.point_list;
    }

    public void setType_list(List list) {
        this.type_list = list;
    }

    public List getType_list() {
        return this.type_list;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof FoldLine3D)) {
            return false;
        }
        FoldLine3D foldLine3D = (FoldLine3D)object;
        if (foldLine3D.getZ() != this.getZ()) {
            return false;
        }
        if (foldLine3D.getDeep() != this.getDeep()) {
            return false;
        }
        if (!ComparatorUtils.equals(foldLine3D.getProjection(), this.getProjection())) {
            return false;
        }
        if (foldLine3D.getPoint_list().size() != this.getPoint_list().size()) {
            return false;
        }
        for (n2 = 0; n2 < foldLine3D.getPoint_list().size(); ++n2) {
            if (ComparatorUtils.equals(foldLine3D.getPoint_list().get(n2), this.getPoint_list().get(n2))) continue;
            return false;
        }
        for (n2 = 0; n2 < foldLine3D.getType_list().size(); ++n2) {
            if (ComparatorUtils.equals(foldLine3D.getType_list().get(n2), this.getType_list().get(n2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("deep", this.deep);
        jSONObject.put("z", this.z);
        jSONObject.put("point_list", this.point_list);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        if (this.colorInfo != null) {
            jSONObject.put("colorInfo", this.colorInfo.toJSONObject(repository));
        }
        return jSONObject;
    }
}

