/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.chart.Glyph;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Gantt;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TrendLineGlyph;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSeries<T extends DataPoint>
extends SpecialGlyph
implements Result {
    private static final long serialVersionUID = 6421947917220147755L;
    protected Glyph drawImpl;
    protected ChartStyle dataSeriesStyle;
    private int seriesIndex;
    private String seriesName;
    private List<T> points = new ArrayList<T>();
    private List trendLineGlyphList = new ArrayList();
    private boolean isCompositeSeries = false;
    private boolean seriesDragEnable = false;

    public DataSeries() {
    }

    public DataSeries(int n2) {
        this.seriesIndex = n2;
    }

    @Override
    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void addTrendLineGlyph(TrendLineGlyph trendLineGlyph) {
        this.trendLineGlyphList.add(trendLineGlyph);
    }

    public int getTrendLineGlyphSize() {
        return this.trendLineGlyphList == null ? 0 : this.trendLineGlyphList.size();
    }

    public TrendLineGlyph getTrendLineGlyph(int n2) {
        if (n2 < 0 || n2 > this.getTrendLineGlyphSize() - 1) {
            return null;
        }
        return (TrendLineGlyph)this.trendLineGlyphList.get(n2);
    }

    public void clearTrendLineGlyph() {
        this.trendLineGlyphList.clear();
    }

    public void setDrawImpl(Glyph glyph) {
        this.drawImpl = glyph;
    }

    public void addDataPoint(T t2) {
        this.points.add(t2);
    }

    public void removeDataPoint(T t2) {
        this.points.remove(t2);
    }

    public int getDataPointCount() {
        return this.points == null ? 0 : this.points.size();
    }

    public DataPoint getDataPoint(int n2) {
        if (n2 < 0 || n2 > this.getDataPointCount() - 1) {
            return new DataPoint();
        }
        return (DataPoint)this.points.get(n2);
    }

    public List<T> getPoints() {
        return this.points;
    }

    public void setCompositeSeries(boolean bl) {
        this.isCompositeSeries = bl;
    }

    public boolean isCompositeSeries() {
        return this.isCompositeSeries;
    }

    @Override
    public void draw(Graphics graphics, int n2) {
        if (this.drawImpl != null) {
            this.drawImpl.draw(graphics, n2);
        }
        int n3 = this.getDataPointCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getDataPoint(i2).draw(graphics, n2);
        }
    }

    public void drawChartStyle(Graphics graphics) {
        if (this.dataSeriesStyle != null) {
            this.dataSeriesStyle.paintStyle(graphics);
        }
    }

    public void setDataSeriesStyle(ChartStyle chartStyle) {
        this.dataSeriesStyle = chartStyle;
    }

    public ChartStyle getDataSeriesStyle() {
        return this.dataSeriesStyle;
    }

    public void drawLabel(Graphics graphics, int n2) {
        int n3 = this.getDataPointCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getDataPoint(i2).drawLabel(graphics, n2);
        }
    }

    public void drawTrendLine(Graphics graphics, int n2) {
        int n3 = this.getTrendLineGlyphSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getTrendLineGlyph(i2).draw(graphics, n2);
        }
    }

    @Override
    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        if (this.drawImpl != null) {
            generalPath.append(this.drawImpl.getShape(), false);
        }
        int n2 = this.getDataPointCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Shape shape = this.getDataPoint(i2).getShape();
            if (shape == null) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    public boolean isSeriesNullType4Gantt(int n2) {
        boolean bl = true;
        for (int i2 = 0; i2 < this.getDataPointCount(); ++i2) {
            DataPoint4Gantt dataPoint4Gantt = (DataPoint4Gantt)this.getDataPoint(i2);
            if (n2 == 0) {
                bl = !(dataPoint4Gantt.getPlanStart() >= 0.0) || !(dataPoint4Gantt.getPlanEnd() >= 0.0);
            } else if (n2 == 1) {
                bl = !(dataPoint4Gantt.getPlanEnd() >= 0.0) || !(dataPoint4Gantt.getPlanStart() >= 0.0);
            } else if (n2 == 2) {
                bl = !(dataPoint4Gantt.getRealStart() >= 0.0);
            } else if (n2 == 3) {
                bl = !(dataPoint4Gantt.getRealEnd() >= 0.0);
            } else if (n2 == 4) {
                boolean bl2 = bl = !(dataPoint4Gantt.getProgress() >= 0.0);
            }
            if (!bl) break;
        }
        return bl;
    }

    @Override
    public boolean evalWithCondition(Condition condition, Calculator calculator) {
        return condition == null ? false : condition.eval(this, calculator);
    }

    @Override
    public Object toResult(CommonCondition commonCondition) {
        String string = commonCondition.getColumnName();
        if (ComparatorUtils.equals(string, ChartConstants.SERIES_INDEX) || ArrayUtils.contains(ChartConstants.getSeriesIndexKeys(), string)) {
            return new Integer(this.seriesIndex + 1);
        }
        if (ComparatorUtils.equals(string, ChartConstants.SERIES_NAME) || ArrayUtils.contains(ChartConstants.getSeriesNameKeys(), string)) {
            return this.seriesName;
        }
        if (ComparatorUtils.equals(string, ChartConstants.PROJECT_ID) || ArrayUtils.contains(ChartConstants.getProjectIdKeys(), string)) {
            return this.seriesName;
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof DataSeries && ((DataSeries)object).getSeriesIndex() == this.seriesIndex && ((DataSeries)object).isSeriesDragEnable() == this.seriesDragEnable && ComparatorUtils.equals(((DataSeries)object).getSeriesName(), this.seriesName) && ComparatorUtils.equals(((DataSeries)object).points, this.points) && ComparatorUtils.equals(((DataSeries)object).drawImpl, this.drawImpl);
    }

    protected String getType() {
        return "DataSeries";
    }

    public void setSeriesDragEnable(boolean bl) {
        this.seriesDragEnable = bl;
    }

    public boolean isSeriesDragEnable() {
        return this.seriesDragEnable;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("type", this.getType());
        if (this.points != null && this.points.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i2 = 0; i2 < this.points.size(); ++i2) {
                arrayList.add(this.getDataPoint(i2).toJSONObject(repository));
            }
            jSONObject.put("dataPointType", this.getDataPoint(0).getType());
            jSONObject.put("dataPoints", arrayList);
        }
        jSONObject.put("seriesIndex", this.seriesIndex);
        jSONObject.put("seriesName", this.seriesName);
        jSONObject.put("seriesDragEnable", this.seriesDragEnable);
        jSONObject.put("isCompositeSeries", this.isCompositeSeries);
        return jSONObject;
    }
}

