/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class DataPoint4Funnel
extends DataPoint {
    private GeneralPath leadLine;
    private double valueGap;
    private double valueWidth;
    private boolean isShowLabel = true;
    private TextGlyph seriesText;
    private TextGlyph valueText;
    private String showText;
    private Color topColor;
    private Color lineColor;
    private Color seriesColor;
    private String seriesString = "";
    private String valueString = "";

    public void setLeadLine(GeneralPath generalPath) {
        this.leadLine = generalPath;
    }

    public GeneralPath getLeadLine() {
        return this.leadLine;
    }

    public String getType() {
        return "DataPoint4Funnel";
    }

    public void setDataLabel(TextGlyph textGlyph) {
        super.setDataLabel(textGlyph);
    }

    public void drawLabel(Graphics graphics, int n2) {
        if (this.isValueIsNull() || !this.isShowLabel) {
            return;
        }
        if (this.getDataLabel() == null) {
            return;
        }
        Color color = graphics.getColor();
        if (this.valueText != null) {
            Glyph glyph = this.getDrawImpl();
            ShapeGlyph shapeGlyph = (ShapeGlyph)glyph;
            GeneralInfo generalInfo = shapeGlyph.getGeneralInfo();
            Background background = generalInfo.getBackground();
            if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
                this.valueText.getTextAttr().setFRFontColor(((ColorBackground)background).getColor());
                if (this.getSeriesIndex() == 0) {
                    this.valueText.getTextAttr().setFRFontColor(this.topColor);
                }
            }
            GlyphUtils.drawStrings(graphics, this.valueText.getText(), this.valueText.getTextAttr(), this.valueText.getBounds(), n2);
        }
        if (this.seriesText != null) {
            this.seriesText.setTextAttr(this.getDataLabel().getTextAttr());
            this.seriesText.getTextAttr().setFRFontColor(this.seriesColor);
            if (this.getSeriesIndex() == 0) {
                this.valueText.getTextAttr().setFRFontColor(this.topColor);
            }
            GlyphUtils.drawStrings(graphics, this.seriesText.getText(), this.seriesText.getTextAttr(), this.seriesText.getBounds(), n2);
        }
        if (this.getDataLabel() != null && this.getLeadLine() != null) {
            graphics.setColor(this.lineColor);
            GraphHelper.draw(graphics, this.getLeadLine(), 1);
        }
        graphics.setColor(color);
    }

    public void initLabel(int n2) {
        this.initLabelBounds(n2);
        this.initColor();
    }

    public void setIndividualLabelText(String string, AttrContents attrContents) {
        if (string.contains("${SERIES}")) {
            this.seriesString = this.getSeriesName();
        }
        String string2 = this.getValueParaString(this.getValueByUnit(), attrContents);
        String string3 = this.getPercentParaString(attrContents);
        if (string.contains("${VALUE}") && string.contains("${PERCENT}")) {
            this.valueString = string2 + ChartConstants.DELIMITERS[0] + string3;
        } else if (string.contains("${VALUE}")) {
            this.valueString = string2;
        } else if (string.contains("${PERCENT}")) {
            this.valueString = string3;
        }
    }

    public String[] getSeriesValueString() {
        return new String[]{this.seriesString, this.valueString};
    }

    private void initColor() {
        this.topColor = new Color(115, 115, 115);
        this.lineColor = new Color(204, 204, 204);
        this.seriesColor = new Color(0, 0, 0);
    }

    private void initLabelBounds(int n2) {
        if (this.isValueIsNull() || !this.isShowLabel) {
            return;
        }
        if (this.getDataLabel() == null || this.getDataLabel().getBounds() == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getDataLabel().getBounds();
        if (StringUtils.isNotEmpty(this.valueString)) {
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(this.valueString, this.getDataLabel().getTextAttr(), n2);
            double d2 = rectangle2D.getX() + rectangle2D.getWidth() - this.valueWidth;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
            this.valueText = new TextGlyph(this.valueString, this.getDataLabel().getTextAttr());
            this.dealTextWithEllipsis(this.valueText, rectangle2D.getWidth(), n2);
            this.valueText.setBounds(double_);
        }
        if (StringUtils.isNotEmpty(this.seriesString)) {
            double d3 = rectangle2D.getWidth();
            if (this.valueText != null) {
                d3 -= this.valueWidth;
            }
            if (d3 > 0.0) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getHeight());
                this.seriesText = new TextGlyph(this.seriesString, this.getDataLabel().getTextAttr());
                this.dealTextWithEllipsis(this.seriesText, d3, n2);
                this.seriesText.setBounds(double_);
            }
        }
    }

    private void dealTextWithEllipsis(TextGlyph textGlyph, double d2, int n2) {
        String string;
        int n3;
        String string2 = textGlyph.getText();
        double d3 = GlyphUtils.calculateTextDimensionWithNoRotation(string2, textGlyph.getTextAttr(), n2).getWidth();
        if (d3 <= d2) {
            return;
        }
        for (n3 = string2.length(); n3 >= 0 && !((d3 = GlyphUtils.calculateTextDimensionWithNoRotation(string = string2.substring(0, n3) + "\u2026", textGlyph.getTextAttr(), n2).getWidth()) <= d2); --n3) {
        }
        if (n3 <= 0) {
            textGlyph.setText("\u2026");
        } else {
            textGlyph.setText(string2.substring(0, n3) + "\u2026");
        }
    }

    public boolean equals(Object object) {
        return object instanceof DataPoint4Funnel && ChartComparatorUtils.equals(this.leadLine, ((DataPoint4Funnel)object).leadLine) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)super.clone();
        dataPoint4Funnel.leadLine = (GeneralPath)this.leadLine.clone();
        return dataPoint4Funnel;
    }

    public boolean isShowLabel() {
        return this.isShowLabel;
    }

    public void setShowLabel(boolean bl) {
        this.isShowLabel = bl;
    }

    public void setShowText(String string) {
        this.showText = string;
    }

    public String getShowText() {
        return this.seriesString + this.valueString;
    }

    public void setValueGap(double d2) {
        this.valueGap = d2;
    }

    public void setValueWidth(double d2) {
        this.valueWidth = d2;
    }

    public void setTopColor(Color color) {
        this.topColor = color;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("seriesString", this.seriesString);
        jSONObject.put("valueString", this.valueString);
        return jSONObject;
    }
}

