/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Utils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Meter;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.FRFont;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class BlueMeter
extends Meter {
    private static final double PIE_ANGLE = 90.0;
    private static final double ARC_WIDTH = 0.07;
    private static final double ARC_RADIUS = 0.75;
    private static final double SHORT_TICK_LEN = 0.08;
    private static final double LONG_TICK_LEN = 0.12;
    private static final double ARROW_OUTER_R = 0.36;
    private static final double ARROW_BACK_R = 0.44;
    private static final double ARROW_INNER_R = 0.12;
    private static final double ARROW_LENGTH = 0.72;
    private static final int MAX_ANGLE = 300;

    public BlueMeter(TextGlyph textGlyph, double d2, MeterStyle meterStyle) {
        super(textGlyph, d2, meterStyle);
    }

    public void draw(Graphics graphics, int n2) {
        this.resetBeforeDraw();
        this.initTransientValue(n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        this.drawBackground(graphics2D, n2);
        if (this.radius > 0.0) {
            int n3 = this.meterStyle.getIntervalCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.drawArcForInterval(graphics2D, n2, this.meterStyle.getInterval(i2), i2);
            }
            this.drawTicks(graphics2D, n2);
            this.drawArrow(graphics2D, n2);
            this.drawDisplay(graphics2D, n2);
        }
        this.drawTitle(graphics2D, n2);
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    protected void initTransientValue(int n2) {
        this.meterStyle.setMaxArrowAngle(300);
        super.initTransientValue(n2);
    }

    protected void calculateMiddleYAndRadius(double d2, double d3, int n2) {
        this.radius = Math.min(d2, d3) / 2.0;
        this.meterMiddleY = this.bounds.getHeight() / 2.0 + this.bounds.getY();
    }

    private void drawArrow(Graphics2D graphics2D, int n2) {
        Paint paint = graphics2D.getPaint();
        if (this.getValue() >= this.meterStyle.getStartValueResult() && this.getValue() <= this.meterStyle.getEndValueFormula()) {
            this.drawArrowAngle(graphics2D, n2);
        }
        graphics2D.setPaint(paint);
    }

    private GeneralPath getPointerPath(GeneralPath generalPath, GeneralPath generalPath2) {
        double d2 = Math.toRadians(-90.0);
        double d3 = this.value;
        double d4 = this.valueToAngle(d3, this.meterStyle.getMaxArrowAngle());
        double d5 = this.meterMiddleX + this.radius * 0.12 * Math.cos(Math.PI * (d4 / 180.0) - d2);
        double d6 = this.meterMiddleY - this.radius * 0.12 * Math.sin(Math.PI * (d4 / 180.0) - d2);
        double d7 = this.meterMiddleX + this.radius * 0.12 * Math.cos(Math.PI * (d4 / 180.0) + d2);
        double d8 = this.meterMiddleY - this.radius * 0.12 * Math.sin(Math.PI * (d4 / 180.0) + d2);
        double d9 = this.meterMiddleX + 0.72 * this.radius * Math.cos(Math.PI * d4 / 180.0);
        double d10 = this.meterMiddleY - 0.72 * this.radius * Math.sin(Math.PI * d4 / 180.0);
        generalPath.moveTo((float)d9, (float)d10);
        generalPath.lineTo((float)d5, (float)d6);
        generalPath.lineTo((float)(d7 + d5) / 2.0f, (float)(d8 + d6) / 2.0f);
        generalPath.closePath();
        generalPath2.moveTo((float)d9, (float)d10);
        generalPath2.lineTo((float)d7, (float)d8);
        generalPath2.lineTo((float)(d7 + d5) / 2.0f, (float)(d8 + d6) / 2.0f);
        generalPath2.closePath();
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo((float)d9, (float)d10);
        generalPath3.lineTo((float)d5, (float)d6);
        generalPath3.lineTo((float)d7, (float)d8);
        generalPath3.closePath();
        return generalPath3;
    }

    private void drawArrowAngle(Graphics2D graphics2D, int n2) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
        double d2 = this.radius * 0.44;
        graphics2D.fill(new Arc2D.Double(this.meterMiddleX - d2, this.meterMiddleY - d2, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 1));
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        GeneralPath generalPath3 = this.getPointerPath(generalPath, generalPath2);
        graphics2D.setColor(new Color(242, 150, 0));
        graphics2D.fill(generalPath);
        graphics2D.setColor(new Color(216, 110, 30));
        graphics2D.fill(generalPath2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.draw(generalPath3);
        double d3 = this.radius * 0.36;
        Arc2D.Double double_ = new Arc2D.Double(this.meterMiddleX - d3, this.meterMiddleY - d3, d3 * 2.0, d3 * 2.0, 0.0, 360.0, 1);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.fill(double_);
        Color[] colorArray = new Color[]{new Color(20, 134, 255), new Color(0, 90, 238)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)this.meterMiddleX, (float)this.meterMiddleY, (float)(this.radius * 0.36), new float[]{0.0f, 1.0f}, colorArray);
        graphics2D.setPaint((Paint)radialGradientPaint);
        graphics2D.fill(double_);
        graphics2D.setColor(new Color(16, 68, 160));
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(double_);
        graphics2D.setPaint(paint);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void drawArcForInterval(Graphics2D graphics2D, int n2, MeterInterval meterInterval, int n3) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(meterInterval.getBackgroundColor());
        double d2 = this.deal4Begin(n3, meterInterval);
        double d3 = this.deal4End(n3, meterInterval);
        if (d2 > d3) {
            return;
        }
        double d4 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d5 = this.valueToAngle(d3, this.getMeterStyle().getMaxArrowAngle());
        this.arcWidth = this.radius * 0.07;
        float f2 = (float)(this.radius * 0.85 - this.arcWidth * 0.5);
        double d6 = (d4 - d5) * 0.5;
        if (n3 == this.meterStyle.getIntervalCount() - 1) {
            graphics2D.setStroke(new BasicStroke((float)this.arcWidth, 1, 1));
        } else {
            graphics2D.setStroke(new BasicStroke((float)this.arcWidth));
        }
        graphics2D.draw(new Arc2D.Double(this.meterMiddleX - (double)f2, this.meterMiddleY - (double)f2, f2 * 2.0f, f2 * 2.0f, d5, d6, 0));
        if (n3 == 0) {
            graphics2D.setStroke(new BasicStroke((float)this.arcWidth, 1, 1));
        } else {
            graphics2D.setStroke(new BasicStroke((float)this.arcWidth));
        }
        graphics2D.draw(new Arc2D.Double(this.meterMiddleX - (double)f2, this.meterMiddleY - (double)f2, f2 * 2.0f, f2 * 2.0f, d5 + d6, d6, 0));
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    private void drawTicks(Graphics2D graphics2D, int n2) {
        double d2 = this.dealWithDoubleValue(this.meterStyle.getTickSizeFormula());
        double d3 = this.getOrder();
        if (d2 > 0.0) {
            double d4;
            double d5 = this.meterStyle.getStartValueResult() / d3;
            if (d5 > (d4 = this.meterStyle.getEndValueFormula() / d3)) {
                return;
            }
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.BLACK);
            GeneralPath generalPath = new GeneralPath();
            BigDecimal bigDecimal = new BigDecimal(Double.toString(d5)).subtract(new BigDecimal(Double.toString(d2)));
            double d6 = d5;
            while (d6 <= d4) {
                bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d2)));
                if (d6 == d5 || d6 == d4) {
                    this.drawTickLine(graphics2D, d6 * d3, true, true);
                } else {
                    this.drawTickLine(graphics2D, d6 * d3, false, true);
                }
                if (this.meterStyle.getMaxArrowAngle() != 360 || d6 != d4) {
                    this.drawTickLabel(graphics2D, bigDecimal.doubleValue(), generalPath, n2);
                }
                d6 = BigDecimal.valueOf(d6).add(BigDecimal.valueOf(d2)).doubleValue();
            }
            for (double d7 = d5; d7 <= d4; d7 += d2 / 5.0) {
                if ((d7 - d5) % d2 == 0.0) continue;
                this.drawTickLine(graphics2D, d7 * d3, false, false);
            }
            graphics2D.setColor(color);
        }
    }

    private void drawTickLine(Graphics2D graphics2D, double d2, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        double d3 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d4 = this.radius * 0.75;
        double d5 = this.radius * 0.12;
        if (!bl2 && !bl) {
            d5 = this.radius * 0.08;
        }
        double d6 = this.meterMiddleX + d4 * Math.cos(Math.PI * (d3 / 180.0));
        double d7 = this.meterMiddleY - d4 * Math.sin(Math.PI * (d3 / 180.0));
        double d8 = this.meterMiddleX + (d4 - d5) * Math.cos(Math.PI * (d3 / 180.0));
        double d9 = this.meterMiddleY - (d4 - d5) * Math.sin(Math.PI * (d3 / 180.0));
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.setColor(Color.WHITE);
        graphics2D.draw(new Line2D.Double(d6, d7, d8, d9));
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    private void drawTickLabel(Graphics2D graphics2D, double d2, GeneralPath generalPath, int n2) {
        Color color = graphics2D.getColor();
        if (this.meterStyle.isTickLabelsVisible()) {
            double d3 = this.getOrder();
            double d4 = this.valueToAngle(d2 * d3, this.getMeterStyle().getMaxArrowAngle());
            String string = this.meterStyle.getUnitFormat() != null ? this.meterStyle.getUnitFormat().format(d2) : Utils.doubleToString(d2);
            graphics2D.setColor(Color.WHITE);
            float f2 = 9.0f;
            FRFont fRFont = FRFont.getInstance("Century Gothic", 0, f2).applyForeground(Color.WHITE);
            TextAttr textAttr = new TextAttr(fRFont);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
            double d5 = this.meterMiddleX + this.radius * 0.5 * Math.cos(Math.PI * (d4 / 180.0)) - dimension2D.getWidth() / 2.0;
            double d6 = this.meterMiddleY - this.radius * 0.5 * Math.sin(Math.PI * (d4 / 180.0)) - dimension2D.getHeight() / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, dimension2D.getWidth(), dimension2D.getHeight());
            if (!generalPath.intersects(double_)) {
                generalPath.append(double_, false);
                GlyphUtils.drawStrings(graphics2D, string, textAttr, double_, n2);
            }
        }
        graphics2D.setColor(color);
    }

    private void drawDisplay(Graphics2D graphics2D, int n2) {
        String string = Utils.doubleToString(this.dealWithDoubleValue(this.getValue() / this.getOrder()));
        TextAttr textAttr = this.meterStyle.getValueTextAttr();
        textAttr.setFRFont(textAttr.getFRFont().applyForeground(Color.WHITE));
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d2 = this.meterMiddleX - dimension2D.getWidth() / 2.0;
        double d3 = this.meterMiddleY;
        GlyphUtils.drawStrings(graphics2D, string, textAttr, new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight()), n2);
        TextAttr textAttr2 = this.meterStyle.getUnitTextAttr();
        textAttr2.setFRFont(textAttr2.getFRFont().applyForeground(Color.WHITE));
        String string2 = this.meterStyle.getUnits();
        Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(string2, textAttr2, n2);
        float f2 = (float)(this.meterMiddleX - dimension2D2.getWidth() / 2.0);
        float f3 = (float)(this.meterMiddleY - dimension2D2.getHeight());
        GlyphUtils.drawStrings(graphics2D, string2, textAttr2, new Rectangle2D.Double(f2, f3, dimension2D2.getWidth(), dimension2D2.getHeight()), n2);
    }

    private void drawBackground(Graphics2D graphics2D, int n2) {
        Object object;
        Color[] colorArray = new Color[]{new Color(234, 231, 227), new Color(154, 149, 154), new Color(255, 255, 255), new Color(142, 136, 139), new Color(181, 181, 182)};
        float[] fArray = new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f};
        Point2D.Double double_ = new Point2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius);
        Point2D.Double double_2 = new Point2D.Double(this.meterMiddleX + this.radius, this.meterMiddleY + this.radius);
        if (((Point2D)double_).getX() == ((Point2D)double_2).getX() && ((Point2D)double_).getY() == ((Point2D)double_2).getY()) {
            graphics2D.setPaint(new Color(154, 149, 154));
        } else {
            object = new LinearGradientPaint((Point2D)double_, (Point2D)double_2, fArray, colorArray);
            graphics2D.setPaint((Paint)object);
        }
        object = new Arc2D.Double(this.meterMiddleX - this.radius, (double)((float)this.meterMiddleY) - this.radius, this.radius * 2.0, this.radius * 2.0, 0.0, 360.0, 1);
        graphics2D.fill((Shape)object);
        Color[] colorArray2 = new Color[]{new Color(20, 134, 255), new Color(0, 59, 128), new Color(0, 35, 64)};
        float[] fArray2 = new float[]{0.0f, 0.7f, 1.0f};
        double d2 = this.radius * 0.9;
        if ((float)d2 <= Float.MIN_VALUE) {
            return;
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)this.meterMiddleX, (float)this.meterMiddleY, (float)d2, fArray2, colorArray2);
        graphics2D.setPaint((Paint)radialGradientPaint);
        Arc2D.Double double_3 = new Arc2D.Double(this.meterMiddleX - d2, (double)((float)this.meterMiddleY) - d2, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 1);
        graphics2D.fill(double_3);
    }
}

