/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Utils;
import com.fr.chart.base.ChartConstants;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AxisHelper {
    private static Map unit = null;
    private static final double BAI = 100.0;
    private static final double SHI = 10.0;
    private static final int FIVE = 5;
    private static final int EIGHT = 8;
    private static final int SIX = 6;
    private static final int SEVEN = 7;

    public static double getDivideUnit(String string) {
        if (unit == null) {
            unit = new HashMap();
            unit.put(ChartConstants.UNIT_I18N_KEYS[0], new Double(1.0));
            double d2 = 100.0;
            for (int i2 = 1; i2 < ChartConstants.UNIT_I18N_KEYS.length; ++i2) {
                unit.put(ChartConstants.UNIT_I18N_KEYS[i2], new Double(d2));
                d2 *= 10.0;
            }
            unit.put("10000", new Double(10000.0));
            unit.put("100000", new Double(100000.0));
            unit.put("10000000", new Double(1.0E7));
            unit.put("100000000", new Double(1.0E8));
        }
        if (unit.containsKey(string)) {
            return (Double)unit.get(string);
        }
        return Utils.string2Number(string).doubleValue();
    }

    public static BigDecimal calculateIncrement(double d2, double d3) {
        if (d2 >= d3) {
            return new BigDecimal("1");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d3 - d2));
        if (bigDecimal.doubleValue() == 1.0) {
            return new BigDecimal("0.2");
        }
        double d4 = AxisHelper.getMoveInt(bigDecimal);
        BigDecimal bigDecimal2 = AxisHelper.getBaseWithMoveInt(d4);
        int n2 = (int)((d3 - d2) / bigDecimal2.doubleValue());
        if (n2 == 2 || n2 == 1) {
            return bigDecimal2.multiply(new BigDecimal("0.5"));
        }
        if (n2 >= 3 && n2 <= 5) {
            return bigDecimal2;
        }
        if (n2 >= 6 && n2 <= 7) {
            return bigDecimal2.multiply(new BigDecimal("2"));
        }
        if (n2 >= 8) {
            return bigDecimal2.multiply(new BigDecimal("3"));
        }
        return bigDecimal;
    }

    public static double calIncreWithTickNumber(double d2, double d3, int n2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d3 - d2));
        double d4 = AxisHelper.getMoveInt(bigDecimal);
        BigDecimal bigDecimal2 = AxisHelper.getBaseWithMoveInt(d4);
        int n3 = (int)((d3 - d2) / bigDecimal2.doubleValue());
        double d5 = bigDecimal2.doubleValue() * (double)n3 / (double)n2;
        return d5 * 2.0;
    }

    public static double getMoveInt(BigDecimal bigDecimal) {
        double d2;
        block3: {
            block2: {
                d2 = 0.0;
                if (!(bigDecimal.doubleValue() > 0.0) || !(bigDecimal.doubleValue() < 1.0)) break block2;
                while (bigDecimal.doubleValue() < 1.0) {
                    bigDecimal = bigDecimal.multiply(new BigDecimal("10"));
                    d2 -= 1.0;
                }
                break block3;
            }
            if (!(bigDecimal.doubleValue() >= 10.0)) break block3;
            while (bigDecimal.doubleValue() >= 10.0) {
                bigDecimal = bigDecimal.movePointLeft(1);
                d2 += 1.0;
            }
        }
        return d2;
    }

    private static BigDecimal getBaseWithMoveInt(double d2) {
        BigDecimal bigDecimal;
        block3: {
            block2: {
                bigDecimal = new BigDecimal("1");
                if (!(d2 > 0.0)) break block2;
                int n2 = 0;
                while ((double)n2 < d2) {
                    bigDecimal = bigDecimal.multiply(new BigDecimal("10"));
                    ++n2;
                }
                break block3;
            }
            if (!(d2 < 0.0)) break block3;
            int n3 = 0;
            while ((double)n3 > d2) {
                bigDecimal = bigDecimal.movePointLeft(1);
                --n3;
            }
        }
        return bigDecimal;
    }
}

