/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.BaseUtils;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrTrendLine;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ConditionTrendLine;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.StockChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Stock;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.NullMarker;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;

public class StockPlot
extends RectanglePlot {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "StockPlot";
    public static final String NONE = Inter.getLocText("FR-Chart-Data_None");
    public static final double JUST_BEAUTIFUL = 4.0;
    private static final Object[] OPEN_VALUE = new Object[]{"10", "18", "24", "28", "30", "31", "31", "50", "28", "26", "30", "25", "30", "50", "60", "77", "80", "82", "82", "80", "77", "78", "79", "60", "50", "40", "80", "40", "30", "20", "10", "30"};
    private static final Object[] HIGH_VALUE = new Object[]{"20", "28", "34", "38", "40", "41", "41", "70", "48", "66", "50", "45", "50", "70", "80", "97", "100", "92", "92", "110", "97", "88", "99", "70", "60", "50", "84", "47", "39", "25", "20", "39"};
    private static final Object[] LOW_VALUE = new Object[]{"8", "18", "24", "24", "25", "21", "11", "20", "18", "16", "10", "15", "10", "30", "50", "67", "70", "72", "62", "60", "57", "58", "69", "50", "45", "30", "70", "30", "20", "10", "3", "20"};
    private static final Object[] CLOSE_VALUE = new Object[]{"18", "20", "28", "30", "31", "31", "20", "28", "26", "30", "25", "30", "50", "60", "77", "80", "82", "82", "80", "77", "78", "79", "75", "50", "55", "50", "70", "35", "33", "13", "15", "34"};
    private static final Object[] VOLUME_VALUE = new Object[]{"18", "14", "28", "30", "31", "31", "20", "28", "26", "30", "25", "30", "50", "60", "77", "80", "82", "82", "80", "77", "78", "79", "60", "50", "55", "50", "70", "35", "33", "13", "15", "34"};
    private int highLowLineStyle = 1;
    private Color highLowLineColor = Color.gray;
    private int upBarBorderLineStyle = 1;
    private Color upBarBorderLineBackground = new Color(200, 45, 49);
    private Color upBarBackground = new Color(200, 45, 49);
    private int downBarBorderLineStyle = 1;
    private Color downBarBorderLineBackground = new Color(0, 127, 84);
    private Color downBarBackground = new Color(0, 127, 84);

    public StockPlot() {
        this.setxAxis(new CategoryAxis(3));
        this.setyAxis(new ValueAxis(2));
        this.setSecondAxis(new ValueAxis(4));
        this.resetNullLegendAttr();
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public String[] getAlertLinePaneTitle() {
        return new String[]{"Main_Value_Axis", "Second_Value_Axis"};
    }

    public String getPlotName() {
        return Inter.getLocText("FR-Chart-Type_Stock");
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.resetNullLegendAttr();
    }

    public boolean isSupportTrendLine() {
        return true;
    }

    public int getHighLowLineStyle() {
        return this.highLowLineStyle;
    }

    public void setHighLowLineStyle(int n2) {
        this.highLowLineStyle = n2;
    }

    public Color getHighLowLineColor() {
        return this.highLowLineColor;
    }

    public void setHighLowLineColor(Color color) {
        this.highLowLineColor = color;
    }

    public int getUpBarBorderLineStyle() {
        return this.upBarBorderLineStyle;
    }

    public void setUpBarBorderLineStyle(int n2) {
        this.upBarBorderLineStyle = n2;
    }

    public void setUpBarBorderLineBackground(Color color) {
        this.upBarBorderLineBackground = color;
    }

    public Color getUpBarBorderLineBackground() {
        return this.upBarBorderLineBackground;
    }

    public Color getUpBarBackground() {
        return this.upBarBackground;
    }

    public void setUpBarBackground(Color color) {
        this.upBarBackground = color;
    }

    public int getDownBarBorderLineStyle() {
        return this.downBarBorderLineStyle;
    }

    public void setDownBarBorderLineStyle(int n2) {
        this.downBarBorderLineStyle = n2;
    }

    public void setDownBarBorderLineBackground(Color color) {
        this.downBarBorderLineBackground = color;
    }

    public Color getDownBarBorderLineBackground() {
        return this.downBarBorderLineBackground;
    }

    public Color getDownBarBackground() {
        return this.downBarBackground;
    }

    public void setDownBarBackground(Color color) {
        this.downBarBackground = color;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition) {
        StockChartData stockChartData = ChartXMLUtils.chartData4Stock(chartData);
        double d2 = 0.0;
        for (int i2 = 0; i2 < stockChartData.getCategoryLabelCount(); ++i2) {
            Number number;
            if (ComparatorUtils.equals((Object)ChartAxisPosition.AXIS_LEFT, (Object)chartAxisPosition)) {
                number = stockChartData.getOpenValue(i2);
                d2 = this.getMaxValue(d2, number);
                number = stockChartData.getHighValue(i2);
                d2 = this.getMaxValue(d2, number);
                number = stockChartData.getLowValue(i2);
                d2 = this.getMaxValue(d2, number);
                number = stockChartData.getCloseValue(i2);
                d2 = this.getMaxValue(d2, number);
                continue;
            }
            number = stockChartData.getVolumn(i2);
            d2 = this.getMaxValue(d2, number);
        }
        if (ComparatorUtils.equals((Object)ChartAxisPosition.AXIS_RIGHT, (Object)chartAxisPosition)) {
            d2 *= 4.0;
        }
        if (d2 == this.getMinValueFromData(chartData, false, chartAxisPosition)) {
            return d2 + 10.0;
        }
        return d2;
    }

    private double getMaxValue(double d2, Number number) {
        return number == null ? d2 : Math.max(number.doubleValue(), d2);
    }

    public double getMinValueFromData(ChartData chartData, boolean bl, ChartAxisPosition chartAxisPosition) {
        StockChartData stockChartData = ChartXMLUtils.chartData4Stock(chartData);
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < stockChartData.getCategoryLabelCount(); ++i2) {
            Number number;
            if (ComparatorUtils.equals((Object)ChartAxisPosition.AXIS_LEFT, (Object)chartAxisPosition)) {
                number = stockChartData.getOpenValue(i2);
                d2 = this.getMinValue(bl, d2, number);
                number = stockChartData.getHighValue(i2);
                d2 = this.getMinValue(bl, d2, number);
                number = stockChartData.getLowValue(i2);
                d2 = this.getMinValue(bl, d2, number);
                number = stockChartData.getCloseValue(i2);
                d2 = this.getMinValue(bl, d2, number);
                continue;
            }
            number = stockChartData.getVolumn(i2);
            d2 = this.getMinValue(bl, d2, number);
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    private double getMinValue(boolean bl, double d2, Number number) {
        if (number == null) {
            return d2;
        }
        if (bl) {
            double d3 = number.doubleValue();
            if (d3 < d2 && d3 > 0.0 && d3 < 1.0) {
                d2 = d3;
            }
        } else {
            d2 = number.doubleValue() < d2 ? number.doubleValue() : d2;
        }
        return d2;
    }

    protected DataPoint createDataPoint() {
        return new DataPoint4Stock();
    }

    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (plotGlyph == null) {
            return null;
        }
        ArrayList<LegendItem> arrayList = new ArrayList<LegendItem>();
        AttrTrendLine attrTrendLine = (AttrTrendLine)this.getConditionCollection().getDataSeriesCondition(AttrTrendLine.class, plotGlyph.getSeries(0), null);
        int n2 = 0;
        if (attrTrendLine != null) {
            for (int i2 = 0; i2 < attrTrendLine.size(); ++i2) {
                ConditionTrendLine conditionTrendLine = attrTrendLine.get(i2);
                LegendItem legendItem = new LegendItem(conditionTrendLine.getLine().getTrendLineName());
                LineStyleInfo lineStyleInfo = conditionTrendLine.getLine().getLineStyleInfo();
                legendItem.setLineMarkerIcon(new LineMarkerIcon(ColorBackground.getInstance(lineStyleInfo.getAttrLineColor().getSeriesColor()), 1, new NullMarker()));
                arrayList.add(legendItem);
                ++n2;
            }
        }
        if (n2 == 0) {
            return null;
        }
        if (this.getLegend() == null) {
            this.setLegend(new Legend());
        }
        return this.getLegend().createLegendGlyph(arrayList.toArray(new LegendItem[n2]));
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        StockPlotGlyph stockPlotGlyph = new StockPlotGlyph();
        chartData = ChartXMLUtils.chartData4Stock(chartData);
        this.createErrTextGlyph(stockPlotGlyph, (StockChartData)chartData);
        this.installAxisGlyph(stockPlotGlyph, chartData);
        this.install4PlotGlyph(stockPlotGlyph, chartData);
        stockPlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return stockPlotGlyph;
    }

    public ChartData createNullChartData() {
        return new StockChartData(new String[0], new String[]{""}, new String[0], new String[]{""}, new String[]{""}, new String[]{""});
    }

    public void install4PlotGlyph(StockPlotGlyph stockPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(stockPlotGlyph, chartData);
        stockPlotGlyph.setDownBarBackground(this.downBarBackground);
        stockPlotGlyph.setDownBarBorderLineBackground(this.downBarBorderLineBackground);
        stockPlotGlyph.setDownBarBorderLineStyle(this.downBarBorderLineStyle);
        stockPlotGlyph.setUpBarBackground(this.upBarBackground);
        stockPlotGlyph.setUpBarBorderLineBackground(this.upBarBorderLineBackground);
        stockPlotGlyph.setUpBarBorderLineBackground(this.upBarBorderLineBackground);
        stockPlotGlyph.setUpBarBorderLineStyle(this.upBarBorderLineStyle);
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        StockChartData stockChartData = ChartXMLUtils.chartData4Stock(chartData);
        DataSeries dataSeries = this.createDataSeries(0);
        dataSeries.setSeriesName(Inter.getLocText("FR-Chart-Stock_Close"));
        plotGlyph.addSeries(dataSeries);
        for (int i2 = 0; i2 < stockChartData.getCategoryLabelCount(); ++i2) {
            DataPoint4Stock dataPoint4Stock = new DataPoint4Stock();
            dataPoint4Stock.setCategoryIndex(i2);
            dataPoint4Stock.setSeriesIndex(0);
            double d2 = stockChartData.getCloseValue(i2) == null ? Double.NaN : stockChartData.getCloseValue(i2).doubleValue();
            double d3 = stockChartData.getLowValue(i2) == null ? Double.NaN : stockChartData.getLowValue(i2).doubleValue();
            double d4 = stockChartData.getHighValue(i2) == null ? Double.NaN : stockChartData.getHighValue(i2).doubleValue();
            double d5 = stockChartData.getVolumn(i2) == null ? Double.NaN : stockChartData.getVolumn(i2).doubleValue();
            double d6 = stockChartData.getOpenValue(i2) == null ? Double.NaN : stockChartData.getOpenValue(i2).doubleValue();
            dataPoint4Stock.initValues(d5, d6, d4, d3, d2);
            dataPoint4Stock.initLabels(stockChartData.getStockLabel());
            if (i2 < stockChartData.getCategoryLabelCount()) {
                dataPoint4Stock.setCategoryName(Utils.objectToString(stockChartData.getCategoryPresentLabel(i2)));
                dataPoint4Stock.setCategoryOriginalName(Utils.objectToString(stockChartData.getCategoryOriginalLabel(i2)));
            }
            dataPoint4Stock.setSeriesName(Inter.getLocText("ChartF-Series_Name"));
            dataPoint4Stock.setSeriesOriginalName(Inter.getLocText("ChartF-Series_Name"));
            dataSeries.addDataPoint(dataPoint4Stock);
            this.createDataLabel4DataPointWithCondition(dataPoint4Stock, this.getConditionCollection());
        }
    }

    public void installAxisGlyph(StockPlotGlyph stockPlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        stockPlotGlyph.setxAxisGlyph(axisGlyph);
        axisGlyph.setAxisType("xAxis");
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        axisGlyph2.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph2.isLog(), ChartAxisPosition.AXIS_LEFT), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT));
        axisGlyph2.setAxisType("yAxis");
        stockPlotGlyph.setyAxisGlyph(axisGlyph2);
        StockChartData stockChartData = ChartXMLUtils.chartData4Stock(chartData);
        if (stockChartData.getVolumnCount() > 0) {
            AxisGlyph axisGlyph3 = this.getSecondAxis().createAxisGlyph(chartData);
            axisGlyph3.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph3.isLog(), ChartAxisPosition.AXIS_RIGHT), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_RIGHT));
            axisGlyph3.setAxisType("secondAxis");
            stockPlotGlyph.setSecondAxisGlyph(axisGlyph3);
        }
        stockPlotGlyph.axisExtendsMaxMinValueWithTrendLine(axisGlyph);
    }

    public boolean isSupportDataSeriesCondition() {
        return false;
    }

    public boolean isSupportTooltipInInteractivePane() {
        return true;
    }

    public boolean isSupportDataSheet() {
        return true;
    }

    public boolean isSupportDataLabelAttr() {
        return false;
    }

    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    private void createErrTextGlyph(StockPlotGlyph stockPlotGlyph, StockChartData stockChartData) {
        if (this.isNotNullData(stockChartData)) {
            return;
        }
        String string = "";
        if (stockChartData.getHighCount() <= 0) {
            string = string + " " + Inter.getLocText("FR-Chart-Stock_High");
        }
        if (stockChartData.getLowCount() <= 0) {
            string = string + " " + Inter.getLocText("FR-Chart-Stock_Low");
        }
        if (stockChartData.getCloseCount() <= 0) {
            string = string + " " + Inter.getLocText("FR-Chart-Stock_Close");
        }
        stockPlotGlyph.setErrorToopTip(string);
        stockPlotGlyph.setErrorImage(BaseUtils.readImage("com/fr/chart/base/dataError.gif"));
    }

    private boolean isNotNullData(StockChartData stockChartData) {
        return stockChartData.getHighCount() > 0 && stockChartData.getLowCount() > 0 && stockChartData.getCloseCount() > 0;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof StockPlot;
    }

    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new StockChartData(ChartUtils.STOCK_CATEGORY_DATE, OPEN_VALUE, HIGH_VALUE, LOW_VALUE, CLOSE_VALUE, VOLUME_VALUE) : new StockChartData(ChartUtils.STOCK_CATEGORY_STRING, OPEN_VALUE, HIGH_VALUE, LOW_VALUE, CLOSE_VALUE, VOLUME_VALUE);
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{0};
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("StockAttr")) {
                this.readStockAttr(xMLableReader);
            } else if ("CategoryAxis".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("CategoryAxis")) {
                            StockPlot.this.setxAxis((CategoryAxis)xMLableReader.readXMLObject(new CategoryAxis()));
                        }
                    }
                });
            } else if ("PriceAxis".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("ValueAxis")) {
                            StockPlot.this.setyAxis((ValueAxis)xMLableReader.readXMLObject(new ValueAxis()));
                        }
                    }
                });
            } else if ("VolumeAxis".equals(string2)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.getTagName().equals("ValueAxis")) {
                            StockPlot.this.setSecondAxis((ValueAxis)xMLableReader.readXMLObject(new ValueAxis()));
                        }
                    }
                });
            } else if ("BG".equals(string2) && (string = xMLableReader.getAttrAsString("color", null)) != null) {
                this.setVerticalIntervalBackgroundColor(new Color(Integer.parseInt(string), true));
            }
        }
    }

    private void readStockAttr(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("highLowLineStyle", null);
        if (string != null) {
            this.highLowLineStyle = Integer.parseInt(string);
        }
        if ((string = xMLableReader.getAttrAsString("upColor", null)) != null) {
            this.upBarBackground = new Color(Integer.parseInt(string), true);
        }
        if ((string = xMLableReader.getAttrAsString("upLineColor", null)) != null) {
            this.upBarBorderLineBackground = new Color(Integer.parseInt(string), true);
        }
        if ((string = xMLableReader.getAttrAsString("downColor", null)) != null) {
            this.downBarBackground = new Color(Integer.parseInt(string), true);
        }
        if ((string = xMLableReader.getAttrAsString("downLineColor", null)) != null) {
            this.downBarBorderLineBackground = new Color(Integer.parseInt(string), true);
        }
        this.setUpBarBorderLineStyle(xMLableReader.getAttrAsInt("upBarBorderLineStyle", 1));
        this.setDownBarBorderLineStyle(xMLableReader.getAttrAsInt("downBarBorderLineStyle", 1));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("StockAttr");
        xMLPrintWriter.attr("highLowLineStyle", this.highLowLineStyle).attr("upBarBorderLineStyle", this.upBarBorderLineStyle).attr("downBarBorderLineStyle", this.downBarBorderLineStyle);
        if (this.highLowLineColor != null) {
            xMLPrintWriter.attr("highLowLineColor", this.highLowLineColor.getRGB());
        }
        if (this.upBarBackground != null) {
            xMLPrintWriter.attr("upColor", this.upBarBackground.getRGB());
        }
        if (this.upBarBorderLineBackground != null) {
            xMLPrintWriter.attr("upLineColor", this.upBarBorderLineBackground.getRGB());
        }
        if (this.downBarBackground != null) {
            xMLPrintWriter.attr("downColor", this.downBarBackground.getRGB());
        }
        if (this.downBarBorderLineBackground != null) {
            xMLPrintWriter.attr("downLineColor", this.downBarBorderLineBackground.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof StockPlot && super.equals(object) && ComparatorUtils.equals(((StockPlot)object).getDownBarBorderLineBackground(), this.downBarBorderLineBackground) && ComparatorUtils.equals(((StockPlot)object).getDownBarBackground(), this.downBarBackground) && ((StockPlot)object).getDownBarBorderLineStyle() == this.downBarBorderLineStyle && ((StockPlot)object).getUpBarBorderLineStyle() == this.upBarBorderLineStyle && ComparatorUtils.equals(((StockPlot)object).getUpBarBorderLineBackground(), this.upBarBorderLineBackground) && ComparatorUtils.equals(((StockPlot)object).getUpBarBackground(), this.upBarBackground) && ((StockPlot)object).getHighLowLineStyle() == this.highLowLineStyle && ComparatorUtils.equals(((StockPlot)object).getHighLowLineColor(), this.highLowLineColor);
    }

    public Object clone() throws CloneNotSupportedException {
        StockPlot stockPlot = (StockPlot)super.clone();
        return stockPlot;
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/stock/0";
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.STOCK;
    }

    public int getDetailType() {
        return 0;
    }

    public boolean isSupportValuePercent() {
        return false;
    }

    public boolean isSupportLegend() {
        return false;
    }

    public String getPlotID() {
        return "FineReportStockChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.STOCK_CHART;
    }
}

