/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.BasePlot;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.base.chart.chartdata.model.NormalDataModel;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.AttrTrendLine;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ConditionTrendLine;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.base.OuterLight;
import com.fr.chart.base.Shadow;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.RadarPlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Map;
import com.fr.chart.chartglyph.DataPointLabelInfo;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.NullMarker;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.NameJavaScriptGroup;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plot
extends GeneralInfo
implements BasePlot {
    private static final long serialVersionUID = 6362269816037714449L;
    public static final String XML_TAG = "Plot";
    public static final String X_AXIS = "xAxis";
    public static final String Y_AXIS = "yAxis";
    public static final String SECOND_AXIS = "secondAxis";
    public static final int DEFAULT_SIZE = 50;
    protected double combinedSize = 50.0;
    private static final int Y_INT_AXIS = 1;
    private static final int SECOND_INT_AXIS = 2;
    protected static final double MARKERSIZE = 0.8;
    private Legend legend = new Legend();
    private ConditionCollection conditionCollection = new ConditionCollection();
    private NameJavaScriptGroup hotHyperLink;
    private AttrContents hotTooltipStyle = this.getDefaultTooltipStyle();
    private int autoRefreshPerSecond = 0;
    private boolean seriesDragEnable = false;
    private boolean isNullValueBreak = true;
    private AttrFillStyle plotFillStyle = new AttrFillStyle();
    private int plotStyle = 0;
    protected String showUnit;
    protected String secondShowUnit;
    private DataSheet dataSheet = new DataSheet();
    private DataProcessor dataProcessor = new NormalDataModel();

    public Plot() {
        this.setBorderColor(null);
        this.setBorderStyle(0);
    }

    public DataProcessor getDataProcessor() {
        return this.dataProcessor;
    }

    public DataProcessor getDataProcessor4Definition() {
        return this.dataProcessor;
    }

    public void setDataProcessor(DataProcessor dataProcessor) {
        this.dataProcessor = dataProcessor;
    }

    public void setShowUnit(String string) {
        this.showUnit = string;
    }

    public void setSecondShowUnit(String string) {
        this.secondShowUnit = string;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public void setHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup) {
        this.hotHyperLink = nameJavaScriptGroup;
    }

    public NameJavaScriptGroup getHotHyperLink() {
        return this.hotHyperLink;
    }

    public void setPlotStyle(int n2) {
        this.plotStyle = n2;
    }

    public int getPlotStyle() {
        return this.plotStyle;
    }

    public void setPlotFillStyle(AttrFillStyle attrFillStyle) {
        this.plotFillStyle = attrFillStyle;
    }

    public AttrFillStyle getPlotFillStyle() {
        return this.plotFillStyle;
    }

    public void setHotTooltipStyle(AttrContents attrContents) {
        this.hotTooltipStyle = attrContents;
    }

    public AttrContents getHotTooltipStyle() {
        return this.hotTooltipStyle;
    }

    public void setInteractiveAxisTooltip(boolean bl) {
    }

    public boolean isInteractiveAxisTooltip() {
        return false;
    }

    public void setNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public void setConditionCollection(ConditionCollection conditionCollection) {
        this.conditionCollection = conditionCollection;
    }

    public ConditionCollection getConditionCollection() {
        return this.conditionCollection;
    }

    public String getPlotDetailType() {
        return this.getClass().getSimpleName();
    }

    public abstract PlotGlyph createPlotGlyph(ChartData var1);

    public abstract String getPlotID();

    public boolean isSupportTrendLine() {
        return false;
    }

    public boolean isSupportAxisTip() {
        return false;
    }

    public boolean isSupportAxisReverse() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return this.isSupportTrendLine() || this.getyAxis() instanceof ValueAxis;
    }

    public boolean isSupportTooltipInInteractivePane() {
        return true;
    }

    public boolean isSupportIntervalBackground() {
        return false;
    }

    public boolean isOnlyIntervalBackground() {
        return false;
    }

    public boolean isSupportBorder() {
        return false;
    }

    public void install4PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeries2PlotGlyph(plotGlyph, chartData);
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            if (!this.isSupportSeriesDrag()) continue;
            dataSeries.setSeriesDragEnable(this.seriesDragEnable);
        }
        if (this.isSupportSeriesDrag()) {
            plotGlyph.setSeriesDragEnable(this.seriesDragEnable);
        }
        plotGlyph.setGeneralInfo(this);
        plotGlyph.setConditionCollection(this.getConditionCollection());
        plotGlyph.setHotHyperLink(this.hotHyperLink);
        plotGlyph.setHotTooltipStyle(this.hotTooltipStyle);
        plotGlyph.setIsNullValueBreak(this.isNullValueBreak);
        plotGlyph.setAutoRefreshPerSecond(this.autoRefreshPerSecond);
        plotGlyph.setPlotFillStyle(this.plotFillStyle);
        plotGlyph.setPlotStyle(this.plotStyle);
    }

    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (this.legend != null) {
            return this.legend.createLegendGlyph(this.createLegendItems(plotGlyph));
        }
        return null;
    }

    public DataSheetGlyph createDataSheetGlyph(PlotGlyph plotGlyph) {
        if (this.dataSheet != null) {
            return this.dataSheet.createDataSheetGlyph(plotGlyph, this.createLegendItems(plotGlyph));
        }
        return null;
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph) {
        if (plotGlyph == null) {
            return new LegendItem[0];
        }
        return this.createLegendItems(plotGlyph, plotGlyph.getSeriesSize());
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph, int n2) {
        LegendItem[] legendItemArray = new LegendItem[n2 + this.getTrendLineNumber(plotGlyph)];
        Color[] colorArray = plotGlyph.createColors4Series();
        int n3 = 0;
        int n4 = 0;
        while (n3 < plotGlyph.getSeriesSize()) {
            DataSeries dataSeries = plotGlyph.getSeries(n3);
            legendItemArray[n4] = new LegendItem(dataSeries.getSeriesName());
            legendItemArray[n4].setCompositeItem(dataSeries.isCompositeSeries());
            legendItemArray[n4].setLineMarkerIcon(this.getLegendMarkerIcon(plotGlyph.getSeries(n3), colorArray));
            ++n3;
            ++n4;
        }
        this.addTrendLine2LegendItem(plotGlyph, legendItemArray);
        return legendItemArray;
    }

    private AttrContents getDefaultTooltipStyle() {
        AttrContents attrContents = new AttrContents("${VALUE}");
        attrContents.setFormat(new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##"));
        attrContents.setPercentFormat(new CoreDecimalFormat(new DecimalFormat("#0.##%"), "#0.##%"));
        return attrContents;
    }

    private boolean isUseOldTip(String string) {
        if (this.isNewToolTip(string)) {
            return false;
        }
        return string.indexOf("${SERIES}") < 0 || string.indexOf("${CATEGORY}") < 0 || string.indexOf("${SERIES}${BR}${CATEGORY}:${VALUE}") >= 0;
    }

    private boolean isNewToolTip(String string) {
        return StringUtils.isEmpty(string) || string.indexOf("${PERCENT}") > 0 || string.indexOf("${ADDRESS}") != -1;
    }

    private int getTrendLineNumber(PlotGlyph plotGlyph) {
        int n2 = 0;
        for (int i2 = 0; i2 < plotGlyph.getSeriesSize(); ++i2) {
            AttrTrendLine attrTrendLine = this.getSeriesTrendLine(plotGlyph, i2);
            if (attrTrendLine == null) continue;
            for (int i3 = 0; i3 < attrTrendLine.size(); ++i3) {
                ++n2;
            }
        }
        return n2;
    }

    private AttrTrendLine getSeriesTrendLine(PlotGlyph plotGlyph, int n2) {
        return (AttrTrendLine)this.getSeriesIndexConditionCollection(n2).getDataSeriesCondition(AttrTrendLine.class, plotGlyph.getSeries(n2), new Color[0]);
    }

    private void addTrendLine2LegendItem(PlotGlyph plotGlyph, LegendItem[] legendItemArray) {
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < plotGlyph.getSeriesSize(); ++i2) {
            AttrTrendLine attrTrendLine = (AttrTrendLine)this.getSeriesIndexConditionCollection(i2).getDataSeriesCondition(AttrTrendLine.class, plotGlyph.getSeries(i2), new Color[0]);
            if (attrTrendLine == null) continue;
            for (int i3 = 0; i3 < attrTrendLine.size(); ++i3) {
                ConditionTrendLine conditionTrendLine = attrTrendLine.get(i3);
                legendItemArray[n2] = new LegendItem(conditionTrendLine.getLine().getTrendLineName());
                LineStyleInfo lineStyleInfo = conditionTrendLine.getLine().getLineStyleInfo();
                legendItemArray[n2].setLineMarkerIcon(new LineMarkerIcon(ColorBackground.getInstance(lineStyleInfo.getAttrLineColor().getSeriesColor()), 1, new NullMarker()));
                ++n2;
            }
        }
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.getLegend() != null) {
            this.getLegend().dependence(calculatorProvider, list);
        }
        if (this.getConditionCollection() != null) {
            this.getConditionCollection().dependence(calculatorProvider, list);
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.getLegend() != null) {
            this.getLegend().dealFormula(calculator);
        }
        if (this.getConditionCollection() != null) {
            this.getConditionCollection().dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.getLegend() != null) {
            this.getLegend().buidExecuteSequenceList(list, calculator);
        }
        if (this.getConditionCollection() != null) {
            this.getConditionCollection().buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.getLegend() != null) {
            this.getLegend().modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.getConditionCollection() != null) {
            this.getConditionCollection().modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.hotHyperLink != null) {
            this.hotHyperLink.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        AttrBackground attrBackground = (AttrBackground)this.getConditionCollection().getDataSeriesCondition(AttrBackground.class, dataSeries, colorArray);
        lineMarkerIcon.setBackground(attrBackground.getSeriesBackground());
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
        lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
    }

    protected void dealColorCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        lineMarkerIcon.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
        lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
    }

    private void dealMarkerStyle(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        lineMarkerIcon.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
        AttrLineStyle attrLineStyle = (AttrLineStyle)this.getConditionCollection().getDataSeriesCondition(AttrLineStyle.class, dataSeries, colorArray);
        lineMarkerIcon.setLineStyle(attrLineStyle.getLineStyle());
        AttrMarkerType attrMarkerType = (AttrMarkerType)this.getConditionCollection().getDataSeriesCondition(AttrMarkerType.class, dataSeries, colorArray);
        Marker marker = MarkerFactory.createMarker(attrMarkerType.getMarkerType());
        marker.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
        marker.setPlotBackground(Marker.SCATTER_PLOT_BACKROUNG);
        lineMarkerIcon.setMarker(marker);
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        this.dealCondition(lineMarkerIcon, dataSeries, colorArray);
        return lineMarkerIcon;
    }

    protected LineMarkerIcon getLegendMarkerIcon4Line(DataSeries dataSeries, Color[] colorArray) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        this.dealMarkerStyle(lineMarkerIcon, dataSeries, colorArray);
        this.dealLineCondition(lineMarkerIcon, dataSeries, colorArray);
        return lineMarkerIcon;
    }

    protected void dealLineCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        lineMarkerIcon.setBackground(ColorBackground.getInstance(attrColor.getSeriesColor()));
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
        lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        this.addSeriesByIndex(0, normalChartData.getSeriesCount(), plotGlyph, chartData);
    }

    public ChartData createNullChartData() {
        return new NormalChartData(new Object[]{""}, new Object[]{""}, new Object[][]{{""}});
    }

    protected DataPoint createDataPoint() {
        return new DataPoint();
    }

    protected DataSeries createDataSeries(int n2) {
        return new DataSeries(n2);
    }

    protected void addSeriesByIndex(int n2, int n3, PlotGlyph plotGlyph, ChartData chartData, boolean bl) {
        int n4;
        NormalChartData normalChartData = (NormalChartData)chartData;
        int n5 = n4 = normalChartData == null ? 0 : normalChartData.getSeriesCount();
        for (int i2 = n2; i2 < n3 && i2 < n4; ++i2) {
            DataSeries dataSeries = this.createDataSeries(i2 - n2);
            dataSeries.setSeriesName(Utils.objectToString(normalChartData.getSeriesPresentLabel(i2)));
            boolean bl2 = true;
            for (int i3 = 0; i3 < normalChartData.getCategoryLabelCount(); ++i3) {
                DataPoint dataPoint = this.createDataPoint();
                dataPoint.setCategoryIndex(i3);
                dataPoint.setSeriesIndex(i2 - n2);
                double d2 = 0.0;
                if (i2 < normalChartData.getSeriesCount() && i3 < normalChartData.getCategoryLabelCount()) {
                    Number number = normalChartData.getValueAt(i2, i3);
                    if (number != null) {
                        d2 = number.doubleValue();
                        bl2 = false;
                    } else {
                        dataPoint.setValueIsNull(true);
                        d2 = 0.0;
                    }
                    dataPoint.setValue(d2);
                    this.dealValueByUnit(dataPoint, d2);
                }
                if (i3 < normalChartData.getCategoryLabelCount()) {
                    dataPoint.setCategoryName(Utils.objectToString(normalChartData.getCategoryPresentLabel(i3)));
                    dataPoint.setCategoryOriginalName(Utils.objectToString(normalChartData.getCategoryOriginalLabel(i3)));
                }
                if (i2 < normalChartData.getSeriesCount()) {
                    dataPoint.setSeriesName(Utils.objectToString(normalChartData.getSeriesPresentLabel(i2)));
                    dataPoint.setSeriesOriginalName(Utils.objectToString(normalChartData.getSeriesOriginalLabel(i2)));
                }
                this.addMoreCate2DataPoint(dataPoint, normalChartData);
                dataSeries.addDataPoint(dataPoint);
            }
            if (bl && bl2) continue;
            plotGlyph.addSeries(dataSeries);
        }
        this.createDataPointLabel(plotGlyph);
    }

    protected void addSeriesByIndexWithoutNull(int n2, int n3, PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeriesByIndex(n2, n3, plotGlyph, chartData, true);
    }

    protected void addSeriesByIndex(int n2, int n3, PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeriesByIndex(n2, n3, plotGlyph, chartData, false);
    }

    private void dealValueByUnit(DataPoint dataPoint, double d2) {
        if (dataPoint != null) {
            AttrAxisPosition attrAxisPosition;
            String string = this.showUnit;
            DataSeriesCondition dataSeriesCondition = this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, dataPoint);
            if (dataSeriesCondition != null && ComparatorUtils.equals((Object)(attrAxisPosition = (AttrAxisPosition)dataSeriesCondition).getAxisPosition(), (Object)ChartAxisPosition.AXIS_RIGHT)) {
                string = this.secondShowUnit;
            }
            double d3 = 1.0;
            if (StringUtils.isNotBlank(string)) {
                d3 = AxisHelper.getDivideUnit(string);
            }
            dataPoint.setValueByUnit(d2 / d3);
        }
    }

    private void addMoreCate2DataPoint(DataPoint dataPoint, NormalChartData normalChartData) {
        Object[] objectArray = normalChartData.getSecondCates();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n2 = dataPoint.getCategoryIndex();
        int n3 = normalChartData.getCategoryLabelCount();
        int n4 = Math.max(1, objectArray == null ? 1 : objectArray.length);
        Object[] objectArray2 = normalChartData.getThirdCates();
        int n5 = Math.max(1, objectArray2 == null ? 1 : objectArray2.length);
        int n6 = n3 / n5;
        int n7 = n6 / n4;
        int n8 = n2 / n6;
        int n9 = (n2 - n8 * n6) / n7;
        if (objectArray != null && objectArray.length > 0 && n9 < objectArray.length && objectArray[n9] != null) {
            dataPoint.setSecondCate(Utils.objectToString(objectArray[n9]));
        }
        if (objectArray2 != null && objectArray2.length > 0 && n8 < n5 && objectArray2[n8] != null) {
            dataPoint.setThirdCate(Utils.objectToString(objectArray2[n8]));
        }
    }

    protected void createDataPointLabel(PlotGlyph plotGlyph) {
        plotGlyph.calculateDataPointPercentValue();
        this.createDataLabel4EverySeries(plotGlyph);
    }

    protected void createDataLabel4EverySeries(PlotGlyph plotGlyph) {
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull()) continue;
                this.createDataLabel4DataPointWithCondition(dataPoint, this.getSeriesIndexConditionCollection(i2));
            }
        }
    }

    protected ConditionCollection getSeriesIndexConditionCollection(int n2) {
        return this.getConditionCollection();
    }

    protected void createDataLabel4DataPointWithCondition(DataPoint dataPoint, ConditionCollection conditionCollection) {
        DataPointLabelInfo dataPointLabelInfo = new DataPointLabelInfo();
        this.getConditionCollection().changeStyleConditionWithInfo(dataPointLabelInfo, dataPoint, new Color[0]);
        String string = dataPointLabelInfo.getSeriesLabel();
        if (ComparatorUtils.equals(dataPoint.getType(), "DataPoint4Pie") && string != null && string.contains("${CATEGORY}")) {
            int n2 = string.indexOf("${CATEGORY}");
            int n3 = "${CATEGORY}".length();
            int n4 = n2 + n3 + (string.length() > n3 ? 1 : 0);
            dataPointLabelInfo.setSeriesLabel(string.substring(n2 + n4));
        }
        TextGlyph textGlyph = new TextGlyph();
        textGlyph.setVisible(true);
        this.getConditionCollection().changeStyleConditionWithInfo(textGlyph, dataPoint, new Color[0]);
        String string2 = dataPointLabelInfo.createLabelText(dataPoint);
        if (StringUtils.isNotEmpty(string2)) {
            textGlyph.setText(string2);
            textGlyph.setVisible(true);
            textGlyph.setTextAttr(dataPointLabelInfo.getTextAttr());
            dataPoint.setDataLabel(textGlyph);
        }
    }

    protected void createDataLabelWithDataPoint4Map(DataPoint dataPoint, DataPoint4Map dataPoint4Map) {
        DataPointLabelInfo dataPointLabelInfo = new DataPointLabelInfo();
        this.getConditionCollection().changeStyleConditionWithInfo(dataPointLabelInfo, dataPoint4Map, new Color[0]);
        TextGlyph textGlyph = new TextGlyph();
        textGlyph.setVisible(true);
        this.getConditionCollection().changeStyleConditionWithInfo(textGlyph, dataPoint4Map, new Color[0]);
        String string = dataPointLabelInfo.createLabelText4Map(dataPoint);
        if (StringUtils.isNotEmpty(string)) {
            textGlyph.setText(string);
            textGlyph.setVisible(true);
            textGlyph.setTextAttr(dataPointLabelInfo.getTextAttr());
            dataPoint.setDataLabel(textGlyph);
        }
    }

    public double getCombinedSize() {
        return this.combinedSize;
    }

    public void setCombinedSize(double d2) {
        this.combinedSize = d2;
    }

    public DataSeriesCondition exsitMarkerType() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        return conditionAttr != null ? conditionAttr.getExisted(AttrMarkerType.class) : null;
    }

    public boolean isExsitLineStyle() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        return conditionAttr != null && conditionAttr.getExisted(AttrLineStyle.class) != null;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        return this.getMaxValueFromData(chartData, 0, normalChartData.getSeriesCount(), chartAxisPosition);
    }

    public boolean isUseSecondAxis() {
        boolean bl = false;
        AttrAxisPosition attrAxisPosition = this.getConditionCollection().getDefaultAttr().getExisted(AttrAxisPosition.class);
        if (attrAxisPosition != null) {
            bl = ComparatorUtils.equals((Object)attrAxisPosition.getAxisPosition(), (Object)ChartAxisPosition.AXIS_RIGHT);
        }
        ConditionCollection conditionCollection = this.getConditionCollection();
        int n2 = conditionCollection.getConditionAttrSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttrAxisPosition attrAxisPosition2 = conditionCollection.getConditionAttr(i2).getExisted(AttrAxisPosition.class);
            if (attrAxisPosition2 == null || !ComparatorUtils.equals((Object)ChartAxisPosition.AXIS_RIGHT, (Object)attrAxisPosition2.getAxisPosition())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public double getMaxValueFromData(ChartData chartData, int n2, int n3, ChartAxisPosition chartAxisPosition) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            for (int i3 = n2; i3 < normalChartData.getSeriesCount() && i3 < n3; ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, i3);
                if (number == null || !ComparatorUtils.equals((Object)attrAxisPosition.getAxisPosition(), (Object)chartAxisPosition)) continue;
                d2 = number.doubleValue() > d2 ? number.doubleValue() : d2;
            }
        }
        if (d2 == this.getMinValueFromData(normalChartData, false, chartAxisPosition)) {
            return d2 + 10.0;
        }
        return d2;
    }

    public double getMinValueFromData(ChartData chartData, boolean bl, ChartAxisPosition chartAxisPosition) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            for (int i3 = 0; i3 < normalChartData.getSeriesCount(); ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, i3);
                if (number == null || !ComparatorUtils.equals((Object)attrAxisPosition.getAxisPosition(), (Object)chartAxisPosition)) continue;
                if (bl) {
                    double d3 = number.doubleValue();
                    if (!(d3 < d2) || !(d3 > 0.0) || !(d3 < 1.0)) continue;
                    d2 = d3;
                    continue;
                }
                d2 = number.doubleValue() < d2 ? number.doubleValue() : d2;
            }
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return ComparatorUtils.equals(this.getClass().getName(), plot.getClass().getName());
    }

    public abstract boolean matchPlotType(Plot var1);

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        this.getConditionCollection().clearConditionAttr();
        if (plot == null) {
            return;
        }
        if (plot.getLegend() != null) {
            this.setLegend(plot.getLegend());
        } else {
            this.setLegend(new Legend());
        }
    }

    public void resetNullLegendAttr() {
        this.setLegend(null);
    }

    public boolean isHaveAxis() {
        return true;
    }

    public Axis getAxis(int n2) {
        switch (n2) {
            case 1: {
                return this.getyAxis();
            }
            case 2: {
                return this.getSecondAxis();
            }
        }
        return this.getxAxis();
    }

    public Axis getAxis(String string) {
        if (ComparatorUtils.equals(X_AXIS, string)) {
            return this.getxAxis();
        }
        if (ComparatorUtils.equals(Y_AXIS, string)) {
            return this.getyAxis();
        }
        if (ComparatorUtils.equals(SECOND_AXIS, string)) {
            return this.getSecondAxis();
        }
        return null;
    }

    public Axis getxAxis() {
        return null;
    }

    public void setxAxis(Axis axis) {
    }

    public Axis getyAxis() {
        return null;
    }

    public void setyAxis(Axis axis) {
    }

    public Axis getSecondAxis() {
        return null;
    }

    public void setSecondAxis(Axis axis) {
    }

    public void setSeriesDragEnable(boolean bl) {
        this.seriesDragEnable = bl;
    }

    public boolean isSeriesDragEnable() {
        return this.seriesDragEnable && this.isSupportSeriesDrag();
    }

    public String[] getAlertLinePaneTitle() {
        return new String[0];
    }

    public boolean isSupportDataSheet() {
        return false;
    }

    public boolean isSupportMoreCate() {
        return false;
    }

    public boolean isSupportCate() {
        return false;
    }

    public boolean isSupportDataSeriesAttr() {
        return true;
    }

    public boolean isSupportDataLabelAttr() {
        return true;
    }

    public boolean isSupportDataSeriesCondition() {
        return true;
    }

    public boolean isSupport3D() {
        return false;
    }

    public boolean isSupportAnimate() {
        return true;
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean isSupportAutoRefresh() {
        return true;
    }

    public boolean is3D() {
        return false;
    }

    public boolean isSupportZoomCategoryAxis() {
        return false;
    }

    public boolean isSupportZoomDirection() {
        return false;
    }

    public boolean isSupportCategoryFilter() {
        return true;
    }

    public boolean isSupportSeriesFilter() {
        return true;
    }

    public boolean isSupportLeadLine() {
        return false;
    }

    public boolean isSupportValuePercent() {
        return true;
    }

    public boolean isSupportAddress4Gis() {
        return false;
    }

    public void setAutoRefreshPerSecond(int n2) {
        this.autoRefreshPerSecond = n2;
    }

    public int getAutoRefreshPerSecond() {
        return this.autoRefreshPerSecond;
    }

    public abstract ChartData defaultChartData();

    public ChartData defaultSecondMoreCate() {
        NormalChartData normalChartData = new NormalChartData(ChartUtils.MORE_SECOND_CATE, ChartUtils.MORE_SERIES, ChartUtils.MORE_SECOND_VALUES);
        normalChartData.setSecondCates(ChartUtils.SECOND_CATE);
        return normalChartData;
    }

    public ChartData defaultThirdMoreCate() {
        NormalChartData normalChartData = new NormalChartData(ChartUtils.MORE_THIRD_CATE, ChartUtils.MORE_SERIES, ChartUtils.MORE_THIRD_VALUES);
        normalChartData.setSecondCates(ChartUtils.THIRD_SECOND_CATE);
        normalChartData.setThirdCates(ChartUtils.THIRD_CATE);
        return normalChartData;
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[0];
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(xMLableReader.getTagName(), "DataProcessor")) {
            this.setDataProcessor((DataProcessor)GeneralXMLTools.readXMLable(xMLableReader));
        }
        this.readPlotXML(xMLableReader);
    }

    protected void readPlotXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("NewSeriesCollection".equals(string)) {
                this.conditionCollection = (ConditionCollection)xMLableReader.readXMLObject(new ConditionCollection());
            } else if ("ConditionCollection".equals(string)) {
                this.readerCollection(xMLableReader);
            } else if ("Legend".equals(string)) {
                this.legend = (Legend)xMLableReader.readXMLObject(new Legend());
            } else if ("DataSheet".equals(string)) {
                this.dataSheet = (DataSheet)xMLableReader.readXMLObject(new DataSheet());
            } else if (this.isHyperlink(string)) {
                this.hotHyperLink = (NameJavaScriptGroup)xMLableReader.readXMLObject(new NameJavaScriptGroup());
            } else if (string.equals("Attr")) {
                this.readerAttr(xMLableReader);
            } else if (string.equals("Shadow")) {
                Shadow shadow = (Shadow)xMLableReader.readXMLObject(new Shadow());
                if (shadow.getShadowColor() != null) {
                    this.plotStyle = 2;
                }
            } else if (string.equals("OuterLight")) {
                OuterLight outerLight = (OuterLight)xMLableReader.readXMLObject(new OuterLight());
                if (outerLight.isNoOuterLight()) {
                    this.plotStyle = 2;
                }
            } else if (string.equals("newHotTooltipStyle") || string.equals("HotTooltipStyle")) {
                this.readHotTipStyle(xMLableReader, string);
            } else if (string.equals("newPlotFillStyle")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            Plot.this.plotFillStyle = (AttrFillStyle)xMLableReader.readXMLObject(new AttrFillStyle());
                        }
                    }
                });
            }
        }
    }

    private boolean isHyperlink(String string) {
        return ComparatorUtils.equals("NameJavaScriptGroup", string) || ComparatorUtils.equals("NameHyperlinks", string) || ComparatorUtils.equals("HyperlinkMap", string);
    }

    private void readerCollection(XMLableReader xMLableReader) {
        DataSeriesCondition dataSeriesCondition;
        this.conditionCollection = (ConditionCollection)xMLableReader.readXMLObject(new ConditionCollection());
        AttrFillStyle attrFillStyle = this.conditionCollection.getDefaultAttr().getExisted(AttrFillStyle.class);
        if (attrFillStyle != null) {
            this.setPlotFillStyle(attrFillStyle);
            this.conditionCollection.getDefaultAttr().remove(attrFillStyle);
        }
        if (!(this instanceof RadarPlot) && (dataSeriesCondition = this.conditionCollection.getDefaultAttr().getExisted(AttrAlpha.class)) != null && ((AttrAlpha)dataSeriesCondition).getAlpha() != 0.0f) {
            this.conditionCollection.getDefaultAttr().remove(dataSeriesCondition);
        }
        if ((dataSeriesCondition = this.conditionCollection.getDefaultAttr().getExisted(AttrBorder.class)) != null && !(this instanceof PiePlot)) {
            this.conditionCollection.getDefaultAttr().remove(dataSeriesCondition);
        }
    }

    protected void readerAttr(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("hotTooltip", null);
        if (string != null && this.isUseOldTip(string)) {
            this.hotTooltipStyle = this.getDefaultTooltipStyle();
        }
        this.isNullValueBreak = xMLableReader.getAttrAsBoolean("isNullValueBreak", true);
        this.combinedSize = xMLableReader.getAttrAsDouble("combinedSize", 50.0);
        this.autoRefreshPerSecond = xMLableReader.getAttrAsInt("autoRefreshPerSecond", 0);
        this.seriesDragEnable = xMLableReader.getAttrAsBoolean("seriesDragEnable", false);
        this.plotStyle = xMLableReader.getAttrAsInt("plotStyle", 0);
        this.showUnit = xMLableReader.getAttrAsString("showUnit", null);
        this.secondShowUnit = xMLableReader.getAttrAsString("secondShowUnit", null);
        if (xMLableReader.getAttrAsBoolean("isHighChart", false)) {
            this.plotStyle = 2;
        }
    }

    private void readHotTipStyle(XMLableReader xMLableReader, String string) {
        if (string.equals("newHotTooltipStyle")) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        AttrContents attrContents = (AttrContents)xMLableReader.readXMLObject(new AttrContents());
                        String string = attrContents.getSeriesLabel();
                        if (Plot.this.isUseOldTip(string)) {
                            attrContents = Plot.this.getDefaultTooltipStyle();
                        }
                        Plot.this.hotTooltipStyle = attrContents;
                    }
                }
            });
        } else if (string.equals("HotTooltipStyle")) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        AttrContents attrContents = (AttrContents)xMLableReader.readXMLObject(new AttrContents());
                        attrContents.setSeriesLabel(Plot.this.hotTooltipStyle.getSeriesLabel());
                        Plot.this.hotTooltipStyle = attrContents;
                    }
                }
            });
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("isNullValueBreak", this.isNullValueBreak).attr("autoRefreshPerSecond", this.autoRefreshPerSecond).attr("seriesDragEnable", this.seriesDragEnable).attr("plotStyle", this.plotStyle).attr("showUnit", this.showUnit).attr("secondShowUnit", this.secondShowUnit).attr("combinedSize", this.combinedSize).end();
        if (this.hotTooltipStyle != null) {
            xMLPrintWriter.startTAG("newHotTooltipStyle");
            this.hotTooltipStyle.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.getConditionCollection() != null) {
            this.getConditionCollection().writeXML(xMLPrintWriter);
        }
        if (this.legend != null) {
            this.legend.writeXML(xMLPrintWriter);
        }
        if (this.dataSheet != null) {
            this.dataSheet.writeXML(xMLPrintWriter);
        }
        if (this.hotHyperLink != null) {
            this.hotHyperLink.writeXML(xMLPrintWriter);
        }
        if (this.dataProcessor != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.dataProcessor, "DataProcessor");
        }
        if (this.plotFillStyle != null) {
            xMLPrintWriter.startTAG("newPlotFillStyle");
            this.plotFillStyle.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Plot plot = (Plot)super.clone();
        if (this.getConditionCollection() != null) {
            plot.setConditionCollection((ConditionCollection)this.getConditionCollection().clone());
        }
        if (this.legend != null) {
            plot.legend = (Legend)this.legend.clone();
        }
        if (this.hotHyperLink != null) {
            plot.hotHyperLink = (NameJavaScriptGroup)this.hotHyperLink.clone();
        }
        if (this.dataSheet != null) {
            plot.dataSheet = (DataSheet)this.dataSheet.clone();
        }
        if (this.hotTooltipStyle != null) {
            plot.hotTooltipStyle = (AttrContents)this.hotTooltipStyle.clone();
        }
        if (this.plotFillStyle != null) {
            plot.plotFillStyle = (AttrFillStyle)this.plotFillStyle.clone();
        }
        plot.isNullValueBreak = this.isNullValueBreak();
        plot.setDataProcessor((DataProcessor)this.getDataProcessor().clone());
        return plot;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Plot && ComparatorUtils.equals(object.getClass().getName(), this.getClass().getName()) && ComparatorUtils.equals(((Plot)object).hotHyperLink, this.hotHyperLink) && ComparatorUtils.equals(this.hotTooltipStyle, ((Plot)object).hotTooltipStyle) && ComparatorUtils.equals(((Plot)object).getDataSheet(), this.getDataSheet()) && ComparatorUtils.equals(((Plot)object).getLegend(), this.getLegend()) && ComparatorUtils.equals(((Plot)object).getConditionCollection(), this.getConditionCollection()) && this.isNullValueBreak == ((Plot)object).isNullValueBreak && this.autoRefreshPerSecond == ((Plot)object).autoRefreshPerSecond && this.seriesDragEnable == ((Plot)object).seriesDragEnable && ComparatorUtils.equals(this.plotFillStyle, ((Plot)object).getPlotFillStyle()) && this.plotStyle == ((Plot)object).plotStyle && this.combinedSize == ((Plot)object).combinedSize && ComparatorUtils.equals(this.showUnit, ((Plot)object).showUnit) && ComparatorUtils.equals(this.secondShowUnit, ((Plot)object).secondShowUnit) && ComparatorUtils.equals(((Plot)object).getDataProcessor(), this.getDataProcessor()) && super.equals(object);
    }

    public boolean isMeterPlot() {
        return false;
    }

    public TextAttr getValueTextAttr() {
        return null;
    }

    public TextAttr getUnitTextAttr() {
        return null;
    }

    public TextAttr getCategoryNameTextAttr() {
        return null;
    }

    public void setValueTextAttr(TextAttr textAttr) {
    }

    public void setUnitTextAttr(TextAttr textAttr) {
    }

    public void setCategoryNameTextAttr(TextAttr textAttr) {
    }

    public void setShowCateName(boolean bl) {
    }

    public boolean isShowCateName() {
        return true;
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/column/0";
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.COLUMN;
    }

    public int getDetailType() {
        return 0;
    }

    protected boolean isSupportAxisLabelWrapShow() {
        return false;
    }

    public boolean isSupportTooltipSeriesType() {
        return false;
    }

    public boolean isSupportDelimiter() {
        return true;
    }

    public boolean isMapPlot() {
        return false;
    }

    public boolean isShowAllDataPointLabel() {
        return false;
    }

    public boolean isSupportPlotBackground() {
        return true;
    }

    public boolean isMapKindLabel() {
        return false;
    }

    public boolean isGisKindLabel() {
        return false;
    }

    public boolean isSupportLegend() {
        return true;
    }

    public boolean isSupportAxisLineStyle() {
        return true;
    }

    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(Plot.class, clazz);
    }

    public abstract FunctionProcessor getFunctionToRecord();
}

