/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.AttrPosition;
import com.fr.chart.base.AttrStyle;
import com.fr.chart.base.AttrTrendLine;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartdata.BubbleReportDefinition;
import com.fr.chart.chartdata.BubbleTableDefinition;
import com.fr.chart.chartdata.GanttReportDefinition;
import com.fr.chart.chartdata.GanttTableDefinition;
import com.fr.chart.chartdata.GisMapReportDefinition;
import com.fr.chart.chartdata.GisMapTableDefinition;
import com.fr.chart.chartdata.MapMoreLayerReportDefinition;
import com.fr.chart.chartdata.MapMoreLayerTableDefinition;
import com.fr.chart.chartdata.MapSingleLayerReportDefinition;
import com.fr.chart.chartdata.MapSingleLayerTableDefinition;
import com.fr.chart.chartdata.MeterReportDefinition;
import com.fr.chart.chartdata.MeterTableDefinition;
import com.fr.chart.chartdata.MoreNameCDDefinition;
import com.fr.chart.chartdata.NormalReportDataDefinition;
import com.fr.chart.chartdata.OneValueCDDefinition;
import com.fr.chart.chartdata.ScatterReportDefinition;
import com.fr.chart.chartdata.ScatterTableDefinition;
import com.fr.chart.chartdata.SeriesEntry;
import com.fr.chart.chartdata.StockReportDefinition;
import com.fr.chart.chartdata.StockTableDefinition;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.general.ComparatorUtils;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;

public abstract class ChartXMLCompatibleUtils {
    public static DataSeriesCondition read65SeriesAttr(XMLableReader xMLableReader) {
        String string;
        String string2;
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("Condition") && (string = xMLableReader.getAttrAsString("class", null)) != null) {
            if (string.endsWith("AttrAlpha")) {
                return new AttrAlpha();
            }
            if (string.endsWith("AttrBackground")) {
                return new AttrBackground();
            }
            if (string.endsWith("AttrBorder")) {
                return new AttrBorder();
            }
            if (string.endsWith("AttrColor")) {
                return new AttrColor();
            }
            if (string.endsWith("AttrContents")) {
                return new AttrContents();
            }
            if (string.endsWith("AttrPosition")) {
                return new AttrPosition();
            }
            if (string.endsWith("AttrLine")) {
                return new AttrLine();
            }
            if (string.endsWith("AttrMarkerType")) {
                return new AttrMarkerType();
            }
            if (string.endsWith("AttrStyle")) {
                return new AttrStyle();
            }
            if (string.endsWith("AttrTrendLine")) {
                return new AttrTrendLine();
            }
        }
        return null;
    }

    public static TopDefinition readDefinition(XMLableReader xMLableReader) {
        TopDefinition topDefinition = null;
        String string = xMLableReader.getTagName();
        if ("OneValueCDDefinition".equals(string)) {
            topDefinition = new OneValueCDDefinition();
        } else if ("MoreNameCDDefinition".equals(string)) {
            topDefinition = new MoreNameCDDefinition();
        } else if ("MeterTableDefinition".equals(string)) {
            topDefinition = new MeterTableDefinition();
        } else if ("ScatterTableDefinition".equals(string)) {
            topDefinition = new ScatterTableDefinition();
        } else if ("StockTableDefinition".equals(string)) {
            topDefinition = new StockTableDefinition();
        } else if ("BubbleTableDefinition".equals(string)) {
            topDefinition = new BubbleTableDefinition();
        } else if ("GanttTableDefinition".equals(string)) {
            topDefinition = new GanttTableDefinition();
        } else if ("NormalReportDataDefinition".equals(string) || "ReportDataDefinition".equals(string)) {
            topDefinition = new NormalReportDataDefinition();
        } else if ("BubbleReportDefinition".equals(string)) {
            topDefinition = new BubbleReportDefinition();
        } else if ("GanttReportDefinition".equals(string)) {
            topDefinition = new GanttReportDefinition();
        } else if ("StockReportDefinition".equals(string)) {
            topDefinition = new StockReportDefinition();
        } else if ("ScatterReportDefinition".equals(string)) {
            topDefinition = new ScatterReportDefinition();
        } else if ("MeterReportDefinition".equals(string)) {
            topDefinition = new MeterReportDefinition();
        } else {
            if ("SeriesListDefinition".equals(string)) {
                return ChartXMLCompatibleUtils.seriesListRead2ReportDefinition(xMLableReader, new NormalReportDataDefinition());
            }
            if ("MapSingleLayerTableDefinition".equals(string)) {
                topDefinition = new MapSingleLayerTableDefinition();
            } else if ("MapSingleLayerReportDefinition".equals(string)) {
                topDefinition = new MapSingleLayerReportDefinition();
            } else if ("MapMoreLayerReportDefinition".equals(string)) {
                topDefinition = new MapMoreLayerReportDefinition();
            } else if ("MapMoreLayerTableDefinition".equals(string)) {
                topDefinition = new MapMoreLayerTableDefinition();
            } else if ("GisMapTableDefinition".equals(string)) {
                topDefinition = new GisMapTableDefinition();
            } else if ("GisMapReportDefiniton".equals(string)) {
                topDefinition = new GisMapReportDefinition();
            }
        }
        if (topDefinition != null) {
            xMLableReader.readXMLObject(topDefinition);
        }
        return topDefinition;
    }

    private static TopDefinition seriesListRead2ReportDefinition(XMLableReader xMLableReader, final NormalReportDataDefinition normalReportDataDefinition) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (ComparatorUtils.equals(string, "Top")) {
                        normalReportDataDefinition.setTopCate(xMLableReader.getAttrAsInt("topCate", -1));
                        normalReportDataDefinition.setTopSeries(xMLableReader.getAttrAsInt("topValue", -1));
                    }
                    if ("CategoryList".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(){

                            public void readXML(XMLableReader xMLableReader) {
                                String string;
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttrAsString("value", null)) != null) {
                                    normalReportDataDefinition.setCategoryName(ChartUtils.string2FormulaStr(string));
                                }
                            }
                        });
                    } else if ("SeriesList".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(){

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "SeriesEntry".equals(xMLableReader.getTagName())) {
                                    normalReportDataDefinition.add((SeriesEntry)xMLableReader.readXMLObject(new SeriesEntry()));
                                }
                            }
                        });
                    }
                }
            }
        });
        return normalReportDataDefinition;
    }

    public static void changeAttrNone(ConditionCollection conditionCollection, boolean bl) {
        if (bl) {
            ChartXMLCompatibleUtils.changeAttrLineStyleNone(conditionCollection.getDefaultAttr(), true);
        } else {
            ChartXMLCompatibleUtils.changeAttrMarkerNone(conditionCollection.getDefaultAttr(), true);
        }
        int n2 = conditionCollection.getConditionAttrSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            ConditionAttr conditionAttr = conditionCollection.getConditionAttr(i2);
            if (bl) {
                ChartXMLCompatibleUtils.changeAttrLineStyleNone(conditionAttr, false);
                continue;
            }
            ChartXMLCompatibleUtils.changeAttrMarkerNone(conditionAttr, false);
        }
    }

    private static void changeAttrMarkerNone(ConditionAttr conditionAttr, boolean bl) {
        AttrMarkerType attrMarkerType = (AttrMarkerType)conditionAttr.getConditionInType("AttrMarkerType");
        if (attrMarkerType != null || bl) {
            if (attrMarkerType != null) {
                conditionAttr.remove(attrMarkerType);
            }
            conditionAttr.addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        }
    }

    private static void changeAttrLineStyleNone(ConditionAttr conditionAttr, boolean bl) {
        AttrLineStyle attrLineStyle = (AttrLineStyle)conditionAttr.getConditionInType("AttrLineStyle");
        if (attrLineStyle != null || bl) {
            if (attrLineStyle != null) {
                conditionAttr.remove(attrLineStyle);
            }
            conditionAttr.addDataSeriesCondition(new AttrLineStyle(0));
        }
    }
}

