/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.BarPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.Plot3D;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class Bar3DPlot
extends BarPlot
implements Plot3D {
    private static final long serialVersionUID = 3019714978415207642L;
    private static final int THREE_D_CHART = 3;
    private static final int THREE_D_HORIZON_DRAW_CHART = 4;
    private static final int THREE_D_STACK_CHART = 5;
    private static final int THREE_D_PERCENT_STACK_CHART = 6;
    private int deep = -1;
    private Projection projection = new Projection();
    private boolean horizontalDrawBar = false;
    private static final String[] BAR_3D = new String[]{"Cat", "Dog"};
    private static final String[] BAR_SERIES = new String[]{"Food", "Apple"};
    private static final String[][] BAR_VALUE = new String[][]{{"10", "10"}, {"20", "20"}};
    private static final NormalChartData BAR_DATA = new NormalChartData(BAR_3D, BAR_SERIES, BAR_VALUE);

    public Bar3DPlot() {
    }

    public Bar3DPlot(boolean bl) {
        this.isStacked = bl;
        this.setSeriesOverlapPercent(1.0);
    }

    public String getPlotName() {
        String string = super.getPlotName();
        if (this.isHorizontalDrawBar()) {
            string = string + "(" + Inter.getLocText("Utils-Left_to_Right") + ")";
        }
        return Inter.getLocText("FR-Chart-Chart_3D") + string;
    }

    public int getDetailType() {
        boolean bl = this.getyAxis().isPercentage();
        if (this.isHorizontalDrawBar()) {
            return 4;
        }
        if (!this.isStacked() && !bl) {
            return 3;
        }
        if (this.isStacked() && !bl) {
            return 5;
        }
        if (this.isStacked() && bl) {
            return 6;
        }
        return 3;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Bar3DPlotGlyph bar3DPlotGlyph = new Bar3DPlotGlyph();
        this.install4PlotGlyph(bar3DPlotGlyph, chartData);
        this.installAxisGlyph(bar3DPlotGlyph, chartData);
        bar3DPlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return bar3DPlotGlyph;
    }

    public void install4PlotGlyph(Bar3DPlotGlyph bar3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(bar3DPlotGlyph, chartData);
        bar3DPlotGlyph.setDeep(this.deep);
        bar3DPlotGlyph.setProjection(this.projection);
        bar3DPlotGlyph.setHorizontalDrawBar(this.horizontalDrawBar);
    }

    public boolean isSupport3D() {
        return true;
    }

    public boolean isSupportBorder() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    public boolean match4GUI(Plot plot) {
        return plot instanceof Bar3DPlot && super.match4GUI(plot) && this.horizontalDrawBar == ((Bar3DPlot)plot).horizontalDrawBar;
    }

    public ChartData defaultChartData() {
        return BAR_DATA;
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean isSupportAxisReverse() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr3D".equals(string)) {
                this.horizontalDrawBar = xMLableReader.getAttrAsBoolean("horizontalDrawBar", false);
                this.setDeep(xMLableReader.getAttrAsInt("deep", -1));
            } else if ("Projection".equals(string)) {
                this.setProjection((Projection)xMLableReader.readXMLObject(new Projection()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr3D").attr("horizontalDrawBar", this.horizontalDrawBar);
        if (this.deep != -1) {
            xMLPrintWriter.attr("deep", this.deep);
        }
        xMLPrintWriter.end();
        if (this.getProjection() != null) {
            this.getProjection().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlot bar3DPlot = (Bar3DPlot)super.clone();
        if (this.projection != null) {
            bar3DPlot.projection = (Projection)this.projection.clone();
        }
        return bar3DPlot;
    }

    public boolean equals(Object object) {
        return object instanceof Bar3DPlot && super.equals(object) && ((Bar3DPlot)object).isHorizontalDrawBar() == this.horizontalDrawBar && ((Bar3DPlot)object).getDeep() == this.deep && ComparatorUtils.equals(((Bar3DPlot)object).getProjection(), this.projection);
    }

    public boolean isSupportAxisLineStyle() {
        return false;
    }
}

