/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.Area3DPlot;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AreaPlotGlyph;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class AreaPlot
extends CategoryPlot {
    private static final long serialVersionUID = -6892583553529732086L;
    private static final int STACK_AREA_CHART = 0;
    private static final int PERCENT_AREA_LINE_CHART = 1;
    private static final Object[] AREA_SERIES_NAME = new Object[]{"Jane", "King"};
    private static final Object[][] AREA_VALUE = new Object[][]{{"14", "20", "15", "18", "16", "22"}, {"6", "9", "12", "8", "13", "18"}};
    public static final ChartData AREACHARTDATA = new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, AREA_SERIES_NAME, AREA_VALUE);
    private boolean isCurve = false;

    public AreaPlot() {
        this.setStacked(true);
    }

    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public boolean isSupportAxisReverse() {
        return true;
    }

    public String getPlotName() {
        String string = Inter.getLocText("I-AreaStyle_Normal");
        if (this.isStacked()) {
            string = Inter.getLocText("FR-Chart-Type_Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText("Chart-Use_Percent") + string;
        }
        return string;
    }

    public String getPlotSmallIconPath() {
        return this.getBaseIconPath() + this.getDetailType();
    }

    public int getDetailType() {
        if (this.isStacked()) {
            return 0;
        }
        if (this.getyAxis().isPercentage()) {
            return 1;
        }
        return 0;
    }

    private String getBaseIconPath() {
        return "com/fr/design/images/toolbar/area/";
    }

    protected DataSeries createDataSeries(int n2) {
        return new DataSeries4Area(n2);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        AreaPlotGlyph areaPlotGlyph = new AreaPlotGlyph();
        this.install4PlotGlyph(areaPlotGlyph, chartData);
        this.installAxisGlyph(areaPlotGlyph, chartData);
        areaPlotGlyph.getxAxisGlyph().setDrawBetweenTick(false);
        return areaPlotGlyph;
    }

    public void install4PlotGlyph(AreaPlotGlyph areaPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(areaPlotGlyph, chartData);
        areaPlotGlyph.setCurve(this.isCurve);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof Area3DPlot || plot instanceof AreaPlot;
    }

    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.LONG_CATEGORY_DATE, AREA_SERIES_NAME, AREA_VALUE) : new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, AREA_SERIES_NAME, AREA_VALUE);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("AreaAttr".equals(string)) {
                this.setCurve(xMLableReader.getAttrAsBoolean("Curve", false));
            } else if ("Attr".equals(string)) {
                this.setCurve(xMLableReader.getAttrAsBoolean("Curve", false));
            }
            this.setStacked(true);
        }
    }

    public boolean isSupportSeriesDrag() {
        return true;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("AreaAttr").attr("Curve", this.isCurve).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AreaPlot && super.equals(object) && ((AreaPlot)object).isCurve() == this.isCurve;
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.AREA;
    }

    protected boolean isSupportAxisLabelWrapShow() {
        return true;
    }

    public boolean isSupportTooltipSeriesType() {
        return true;
    }

    public String getPlotID() {
        return "FineReportAreaChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.AREA_CHART;
    }
}

