/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class AttrLine
extends DataSeriesCondition {
    private static final long serialVersionUID = 8393504378490600313L;
    public static final String XML_TAG = "AttrLine";
    private int seriesLineStyle = 1;
    private Color seriesLineColor = Color.red;

    public AttrLine() {
    }

    public AttrLine(Color color, int n2) {
        this.seriesLineStyle = n2;
        this.seriesLineColor = color;
    }

    public void draw(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        if (this.getSeriesLineColor() != null) {
            GraphHelper.setStroke(graphics2D, (BasicStroke)GraphHelper.getStroke(this.seriesLineStyle));
            graphics2D.setPaint(this.getSeriesLineColor());
            graphics2D.draw(shape);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    public int getSeriesLineStyle() {
        return this.seriesLineStyle;
    }

    public Color getSeriesLineColor() {
        return this.seriesLineColor;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            Background background;
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.seriesLineStyle = xMLableReader.getAttrAsInt("lineStyle", 1);
                this.seriesLineColor = xMLableReader.getAttrAsColor("lineColor", Color.black);
            } else if (string.equals("newAttr")) {
                this.seriesLineStyle = xMLableReader.getAttrAsInt("lineStyle", 1);
            } else if (string.equals("Background") && (background = BaseXMLUtils.readBackground(xMLableReader)) instanceof ColorBackground) {
                this.seriesLineColor = ((ColorBackground)background).getColor();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("newAttr").attr("lineStyle", this.seriesLineStyle).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrLine && ((AttrLine)object).seriesLineStyle == this.seriesLineStyle && ComparatorUtils.equals(((AttrLine)object).seriesLineColor, this.seriesLineColor);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("seriesLineStyle", this.seriesLineStyle);
        if (this.seriesLineColor != null) {
            jSONObject.put("seriesLineColor", StableUtils.javaColorToCSSColor(this.seriesLineColor));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

