/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class AttrBarSeries
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrBarSeries";
    private static final double STA_SERIES_GAP = -0.25;
    private ChartAxisPosition axisPosition = ChartAxisPosition.AXIS_RIGHT;
    private double seriesOverlapPercent = -0.25;
    private double categoryIntervalPercent = 1.0;

    public AttrBarSeries(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public AttrBarSeries() {
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.setAxisPosition(ChartAxisPosition.parse(xMLableReader.getAttrAsString("axisPosition", ChartAxisPosition.AXIS_LEFT.getAxisPosition())));
            this.setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("seriesOverlapPercent", -0.25));
            this.setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("categoryIntervalPercent", 1.0));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("seriesOverlapPercent", this.seriesOverlapPercent).attr("categoryIntervalPercent", this.categoryIntervalPercent).attr("axisPosition", this.axisPosition.getAxisPosition()).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrBarSeries && ((AttrBarSeries)object).seriesOverlapPercent == this.seriesOverlapPercent && ((AttrBarSeries)object).categoryIntervalPercent == this.categoryIntervalPercent && ComparatorUtils.equals((Object)((AttrBarSeries)object).axisPosition, (Object)this.axisPosition);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        jSONObject.put("axisPosition", this.axisPosition.getAxisPosition());
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }

    public void setSeriesOverlapPercent(double d2) {
        this.seriesOverlapPercent = d2;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d2) {
        this.categoryIntervalPercent = d2;
    }

    public ChartAxisPosition getAxisPosition() {
        return this.axisPosition;
    }

    public void setAxisPosition(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }
}

