/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaColor
implements XMLable {
    private static final int DEFAULT_MAX = 100;
    public static final String XML_TAG = "AreaColor";
    private Formula minValue = new Formula("0");
    private Formula maxValue = new Formula("100");
    private Color color = Color.blue;

    public AreaColor() {
    }

    public AreaColor(Formula formula, Formula formula2, Color color) {
        this.minValue = formula;
        this.maxValue = formula2;
        this.color = color;
    }

    public AreaColor(double d2, double d3, Color color) {
        this.minValue = new Formula(new Double(d2).toString());
        this.maxValue = new Formula(new Double(d3).toString());
        this.color = color;
    }

    public double getMinNum() {
        Number number = ChartBaseUtils.formula2Number(this.minValue);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public double getMaxNum() {
        Number number = ChartBaseUtils.formula2Number(this.maxValue);
        if (number != null) {
            return number.doubleValue();
        }
        return 100.0;
    }

    public Formula getMin() {
        return this.minValue;
    }

    public void setMinValue(Formula formula) {
        this.minValue = formula;
    }

    public void setMaxValue(Formula formula) {
        this.maxValue = formula;
    }

    public Formula getMax() {
        return this.maxValue;
    }

    public Color getAreaColor() {
        return this.color;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("minValue", ChartBaseUtils.formula2Number(this.minValue));
        jSONObject.put("maxValue", ChartBaseUtils.formula2Number(this.maxValue));
        jSONObject.put("color", StableUtils.javaColor2JSColorWithAlpha(this.color));
        return jSONObject;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), "AC_Attr")) {
            this.minValue = new Formula(xMLableReader.getAttrAsString("minValue", "0"));
            this.maxValue = new Formula(xMLableReader.getAttrAsString("maxValue", "100"));
            this.color = xMLableReader.getAttrAsColor("color", Color.blue);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("AC_Attr");
        xMLPrintWriter.attr("minValue", this.minValue == null ? "0" : this.minValue.toString()).attr("maxValue", this.maxValue == null ? "100" : this.maxValue.toString());
        if (this.color != null) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AreaColor areaColor = (AreaColor)super.clone();
        areaColor.minValue = (Formula)this.minValue.clone();
        areaColor.maxValue = (Formula)this.maxValue.clone();
        areaColor.color = this.color;
        return areaColor;
    }

    public boolean equals(Object object) {
        return object instanceof AreaColor && ComparatorUtils.equals(((AreaColor)object).color, this.color) && ComparatorUtils.equals(((AreaColor)object).minValue, this.minValue) && ComparatorUtils.equals(((AreaColor)object).maxValue, this.maxValue);
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.minValue != null) {
            list.addAll(Arrays.asList(this.minValue.dependence(calculatorProvider)));
        }
        if (this.maxValue != null) {
            list.addAll(Arrays.asList(this.maxValue.dependence(calculatorProvider)));
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.minValue != null) {
            Utils.dealFormulaValue(this.minValue, calculator);
        }
        if (this.maxValue != null) {
            Utils.dealFormulaValue(this.maxValue, calculator);
        }
    }
}

