/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.MappedByteBufferList;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import java.io.File;
import java.util.List;

public class MappedByteBufferTable {
    private File diskDirectory = null;
    private transient List[] mappedByteBufferLists = null;
    private int MEM_SIZE = ManagerFactory.getCacheProvider().getMaxMemSize();

    public MappedByteBufferTable(int n2) {
        this.mappedByteBufferLists = new MappedByteBufferList[n2];
        this.diskDirectory = this.getCacheDirectory();
        int n3 = 0x2FFFFF;
        if (n2 > 0) {
            n3 = this.MEM_SIZE / n2;
        }
        for (int i2 = 0; i2 < this.mappedByteBufferLists.length; ++i2) {
            String string = "MBB_Column";
            File file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n4 = 0;
            while (file.exists()) {
                file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n4);
                ++n4;
            }
            file.deleteOnExit();
            this.mappedByteBufferLists[i2] = new MappedByteBufferList(file, n3);
        }
    }

    public int getAssignLength(int n2) {
        return this.mappedByteBufferLists[n2].size();
    }

    public void addValueAt(int n2, Object object) {
        this.mappedByteBufferLists[n2].add(object);
    }

    public Object getValueAt(int n2, int n3) {
        if (n2 > this.columnCount() && n2 >= 0) {
            FRLogger.getLogger().error("Index out of bounds");
            return null;
        }
        return this.mappedByteBufferLists[n2].get(n3);
    }

    public int columnCount() {
        return this.mappedByteBufferLists.length;
    }

    public int rowCount() {
        return this.mappedByteBufferLists[0].size();
    }

    public void clear() {
        if (this.mappedByteBufferLists != null) {
            for (int i2 = 0; i2 < this.mappedByteBufferLists.length; ++i2) {
                if (this.mappedByteBufferLists[i2] == null) continue;
                this.mappedByteBufferLists[i2].clear();
            }
        }
        System.gc();
        if (this.diskDirectory != null && !StableUtils.deleteFile(this.diskDirectory)) {
            FRLogger.getLogger().error(Inter.getLocText("WARNING-Fail_to_Delete_Cache_File"));
        }
    }

    private File getCacheDirectory() {
        if (this.diskDirectory == null) {
            this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n2 = 0;
            while (this.diskDirectory.exists()) {
                this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n2);
                ++n2;
            }
            StableUtils.mkdirs(this.diskDirectory);
            this.diskDirectory.deleteOnExit();
        }
        return this.diskDirectory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

