/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.CacheException;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Unity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9068644761950510725L;
    private static final long ONE_SECOND = 1000L;
    private final Object key;
    private Object value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    private int timeToLive;
    private int timeToIdle;
    private long lastUpdateTime;
    private boolean lifespanSet;

    public Unity(Object object, Object object2, long l2) {
        this.key = object;
        this.value = object2;
        this.version = l2;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Unity(Object object, Object object2) {
        this(object, object2, 1L);
    }

    public final Serializable getKey() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.key;
        }
        catch (Exception exception) {
            throw new CacheException("The key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectKey() {
        return this.key;
    }

    public final Serializable getValue() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.value;
        }
        catch (Exception exception) {
            throw new CacheException("The value " + this.value + " for key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectValue() {
        return this.value;
    }

    public final boolean equals(Object object) {
        return object instanceof Unity && this.key != null && ((Unity)object).key != null && ComparatorUtils.equals(((Unity)object).key, this.key);
    }

    public void setTimeToLive(int n2) {
        this.timeToLive = n2;
        this.lifespanSet = true;
    }

    public void setTimeToIdle(int n2) {
        this.timeToIdle = n2;
        this.lifespanSet = true;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public final void updateUpdateStatistics() {
        this.version = this.lastUpdateTime = System.currentTimeMillis();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.creationTime).append(", LastAccessTime = ").append(this.lastAccessTime).append(" ]");
        return stringBuffer.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Unity unity = new Unity(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        unity.creationTime = this.creationTime;
        unity.lastAccessTime = this.lastAccessTime;
        unity.nextToLastAccessTime = this.nextToLastAccessTime;
        unity.hitCount = this.hitCount;
        return unity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deepCopy(Object object) {
        Serializable serializable = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().infoWithServerLevel("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().infoWithServerLevel("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().infoWithServerLevel("Error closing Stream");
            }
        }
        return serializable;
    }

    public boolean isExpired() {
        long l2;
        if (!this.lifespanSet) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        return l3 > (l2 = this.getExpirationTime());
    }

    public long getExpirationTime() {
        if (!this.lifespanSet || this.timeToLive == 0 && this.timeToIdle == 0) {
            return Long.MAX_VALUE;
        }
        long l2 = 0L;
        long l3 = this.creationTime + (long)this.timeToLive * 1000L;
        long l4 = Math.max(this.creationTime, this.nextToLastAccessTime);
        long l5 = l4 + (long)this.timeToIdle * 1000L;
        l2 = this.timeToLive != 0 && (this.timeToIdle == 0 || this.lastAccessTime == 0L) ? l3 : (this.timeToLive == 0 ? l5 : Math.min(l3, l5));
        return l2;
    }

    public boolean isLifespanSet() {
        return this.lifespanSet;
    }
}

