/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.MemoryStoreEvictionPolicy;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class CacheConfiguration
implements XMLable,
Cloneable {
    protected String name;
    protected int maxElementsInMemory = 10;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    protected long timeToIdleSeconds = 200L;
    protected long timeToLiveSeconds = 40L;

    public Object clone() throws CloneNotSupportedException {
        CacheConfiguration cacheConfiguration = (CacheConfiguration)super.clone();
        return cacheConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cache name cannot contain '/' characters.");
        }
        this.name = string;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public final void setMemoryStoreEvictionPolicy(String string) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(string);
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public final void setMaxElementsInMemory(int n2) {
        this.maxElementsInMemory = n2;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public final void setTimeToIdleSeconds(long l2) {
        this.timeToIdleSeconds = l2;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public final void setTimeToLiveSeconds(long l2) {
        this.timeToLiveSeconds = l2;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "CacheConfig".equals(string = xMLableReader.getTagName())) {
            this.setMaxElementsInMemory(xMLableReader.getAttrAsInt("maxElementsInMemory", 10));
            String string2 = xMLableReader.getAttrAsString("memoryStoreEvictionPolicy", null);
            if (string2 != null) {
                this.setMemoryStoreEvictionPolicy(string2);
            }
            this.setTimeToIdleSeconds(xMLableReader.getAttrAsLong("timeToIdleSeconds", 200L));
            this.setTimeToLiveSeconds(xMLableReader.getAttrAsLong("timeToLiveSeconds", 40L));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CacheConfig").attr("maxElementsInMemory", this.getMaxElementsInMemory()).attr("memoryStoreEvictionPolicy", this.getMemoryStoreEvictionPolicy().toString()).attr("timeToIdleSeconds", this.getTimeToIdleSeconds()).attr("timeToLiveSeconds", this.getTimeToLiveSeconds()).end();
    }
}

