/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.GraphHelper;
import com.fr.base.background.AbstractBackground;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class IntervalColorBackground
extends AbstractBackground {
    private static final long serialVersionUID = -3686146578900215327L;
    private Color bgColor;
    private int position = 2;
    private double intervalLength;

    public IntervalColorBackground() {
    }

    public IntervalColorBackground(Color color, int n2) {
        this.bgColor = color;
        this.position = n2;
    }

    public void paint(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        double d2 = this.getIntervalLength();
        if (d2 == 0.0) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            this.paintWithRectangle(graphics2D, (Rectangle2D)shape, d2);
        }
        graphics2D.setPaint(paint);
    }

    private void paintWithRectangle(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2) {
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getY() + d4;
        int n2 = (int)(d4 / d2);
        int n3 = (int)(d3 / d2);
        graphics2D.setPaint(this.bgColor);
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 % 2 != 0) continue;
                GraphHelper.fillRect(graphics2D, d5, d6 - (double)(i2 + 1) * d2, d3, d2);
            }
            if (n2 % 2 == 0) {
                GraphHelper.fillRect(graphics2D, d5, rectangle2D.getY(), d3, d4 - (double)n2 * d2);
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (i3 % 2 != 0) continue;
                GraphHelper.fillRect(graphics2D, d5 + (double)i3 * d2, rectangle2D.getY(), d2, d4);
            }
            if (n3 % 2 == 0) {
                GraphHelper.fillRect(graphics2D, d5 + (double)n3 * d2, rectangle2D.getY(), d3 - (double)n3 * d2, d4);
            }
        }
    }

    public Color getColor() {
        return this.bgColor;
    }

    public int getPosition() {
        return this.position;
    }

    public void setIntervalLength(double d2) {
        this.intervalLength = d2;
    }

    public double getIntervalLength() {
        return this.intervalLength;
    }

    public JSONObject toJSONObject() throws JSONException {
        return null;
    }

    public String getBackgroundType() {
        return null;
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
    }
}

