/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.background.AbstractBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class ColorBackground
extends AbstractBackground {
    private static final long serialVersionUID = -6930147321476711514L;
    private static Map initializeCBG = new HashMap();
    private Color color = null;

    public static ColorBackground getInstance() {
        return ColorBackground.getInstance(null);
    }

    public static ColorBackground getInstance(Color color) {
        if (color == null) {
            return new ColorBackground(null);
        }
        Object v2 = initializeCBG.get(color);
        if (v2 != null) {
            return (ColorBackground)v2;
        }
        ColorBackground colorBackground = new ColorBackground(color);
        initializeCBG.put(color, colorBackground);
        return colorBackground;
    }

    public ColorBackground() {
    }

    private ColorBackground(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(Graphics graphics, Shape shape) {
        Color color = this.getColor();
        if (color == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public JSONObject toJSONObject(Repository repository, Dimension dimension) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository, dimension);
        jSONObject.put("color", StableUtils.javaColorToCSSColor(this.color));
        return jSONObject;
    }

    protected BufferedImage createBufferedImage(int n2, int n3) {
        return null;
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
        Color color = this.getColor();
        if (color == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.draw(shape);
        graphics2D.setPaint(paint);
    }

    public boolean equals(Object object) {
        return object instanceof ColorBackground && ComparatorUtils.equals(((ColorBackground)object).color, this.color);
    }

    public int hashCode() {
        return this.color == null ? 0 : this.color.hashCode();
    }

    public int fixHashCode(int n2) {
        return n2 ^ this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        ColorBackground colorBackground = (ColorBackground)super.clone();
        return colorBackground;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        if (this.color != null) {
            jSONObject.put("color", StableUtils.javaColor2JSColorWithAlpha(this.color));
        }
        return jSONObject;
    }

    public String getBackgroundType() {
        return "ColorBackground";
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        ColorBackground colorBackground = null;
        colorBackground = xMLableReader.getAttrAsString("color", null) == null ? ColorBackground.getInstance(null) : ColorBackground.getInstance(xMLableReader.getAttrAsColor("color", Color.black));
        return colorBackground;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("name", "ColorBackground");
        if (this.getColor() != null) {
            xMLPrintWriter.attr("color", this.getColor().getRGB());
        }
    }
}

