/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ConfigProvider;
import com.fr.base.DataSetFunctionParameterMapNameSpace;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.SegmentHandler;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.script.Expression;
import com.fr.third.antlr.ANTLRException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class ParameterHelper {
    private static final List<String> FILTER_PARAMETER_NAME_LIST = new ArrayList<String>();

    private ParameterHelper() {
    }

    public static Parameter[] analyze4Parameters(String string, boolean bl) {
        Parameter[] parameterArray = null;
        if (ParameterProvider.DEPRECATEDPARAPATTERN.matcher(string).find()) {
            SegmentHandler.ParameterCollector parameterCollector = new SegmentHandler.ParameterCollector();
            ParameterHelper.analyzeParametersFromQuery(string, parameterCollector);
            parameterArray = parameterCollector.getParameters();
        } else if (ParameterProvider.PARAMETERPATTERN.matcher(string).find()) {
            parameterArray = ParameterHelper.parametersFromQuery(string, bl);
        }
        return parameterArray == null ? new Parameter[]{} : parameterArray;
    }

    public static Parameter[] analyze4ParametersFromFormula(String string) {
        Parameter[] parameterArray = new Parameter[]{};
        if (string == null) {
            return parameterArray;
        }
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        if (StringUtils.isBlank(string)) {
            return parameterArray;
        }
        try {
            String[] stringArray = Calculator.relatedParameters(string);
            parameterArray = new Parameter[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                parameterArray[i2] = new Parameter(stringArray[i2].substring(1));
            }
        }
        catch (ANTLRException aNTLRException) {
            FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
        }
        return parameterArray;
    }

    public static String analyze4Templatee(String string, ParameterProvider[] parameterProviderArray) {
        if (ArrayUtils.isEmpty(parameterProviderArray)) {
            return string;
        }
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(parameterProviderArray);
        calculator.pushNameSpace(parameterMapNameSpace);
        String string2 = TemplateUtils.renderTpl(calculator, string);
        calculator.removeNameSpace(parameterMapNameSpace);
        return string2;
    }

    public static String analyzeCurrentContextTableData4Templatee(String string, ParameterProvider[] parameterProviderArray) {
        Calculator calculator = Calculator.createCalculator();
        DataSetFunctionParameterMapNameSpace dataSetFunctionParameterMapNameSpace = DataSetFunctionParameterMapNameSpace.creat(parameterProviderArray);
        calculator.pushNameSpace(dataSetFunctionParameterMapNameSpace);
        String string2 = TemplateUtils.renderTpl(calculator, string);
        calculator.removeNameSpace(dataSetFunctionParameterMapNameSpace);
        return string2;
    }

    public static void analyzeParametersFromQuery(String string, SegmentHandler segmentHandler) {
        String string2;
        Matcher matcher = ParameterProvider.DEPRECATEDPARAPATTERN.matcher(string);
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            n3 = matcher.start();
            string2 = string.substring(n2, n3);
            if (StringUtils.isNotEmpty(string2)) {
                segmentHandler.stringSegment(string2);
            }
            n2 = matcher.end();
            String string3 = matcher.group();
            String string4 = string3.replaceAll("[\\[\\?\\?\\]]", "");
            String[] stringArray = string4.split("\\|");
            String string5 = stringArray[0].replaceAll("[\\r\\n, \\n]*", "");
            segmentHandler.parameterSegment(string5, stringArray.length > 1 ? stringArray[1] : null);
        }
        string2 = string.substring(n2);
        if (StringUtils.isNotBlank(string2)) {
            segmentHandler.stringSegment(string2);
        }
    }

    private static Parameter[] parametersFromQuery(String string, boolean bl) {
        Object object;
        Object object2;
        Matcher matcher = ParameterProvider.PARAMETERPATTERN.matcher(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            object2 = matcher.group();
            object = ((String)object2).substring(2, ((String)object2).length() - 1);
            if (StringUtils.isBlank((String)object)) continue;
            Expression expression = null;
            Calculator calculator = Calculator.createCalculator();
            try {
                expression = calculator.parse((String)object);
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
                return new Parameter[0];
            }
            String[] stringArray = bl ? expression.parserParameter() : expression.parserParameterNoColumnRow();
            if (stringArray == null) continue;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(stringArray[i2]);
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = new Parameter((String)object2.next());
            arrayList.add(object);
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public static void addGlobal_ParameterToSet(Set set) {
        ConfigProvider configProvider = ManagerFactory.getConfigProvider();
        ParameterProvider[] parameterProviderArray = configProvider.getGlobal_Parameters();
        if (parameterProviderArray != null) {
            set.addAll(Arrays.asList(parameterProviderArray));
        }
    }

    public static Parameter[] analyze4Parameters(String[] stringArray, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object[] objectArray;
                String string = stringArray[i2];
                if (!StringUtils.isNotBlank(string)) continue;
                Object[] objectArray2 = objectArray = bl ? ParameterHelper.analyze4ParametersFromFormula(string) : ParameterHelper.analyze4Parameters(string, false);
                if (ArrayUtils.isEmpty(objectArray)) continue;
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    if (arrayList.contains(objectArray[i3])) continue;
                    arrayList.add(objectArray[i3]);
                }
            }
        }
        for (int i4 = arrayList.size() - 1; i4 >= 0; --i4) {
            if (!FILTER_PARAMETER_NAME_LIST.contains(((Parameter)arrayList.get(i4)).getName().toLowerCase())) continue;
            arrayList.remove(i4);
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public static Parameter[] analyzeAndUnionParameters(String[] stringArray, Parameter[] parameterArray, boolean bl) {
        Object[] objectArray = ParameterHelper.analyze4Parameters(stringArray, bl);
        if (ArrayUtils.isEmpty(objectArray)) {
            return objectArray;
        }
        if (!ArrayUtils.isEmpty(parameterArray)) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                Parameter parameter = null;
                for (int i3 = 0; i3 < parameterArray.length; ++i3) {
                    if (!ComparatorUtils.equals(parameterArray[i3].getName(), ((Parameter)object).getName())) continue;
                    parameter = parameterArray[i3];
                    break;
                }
                if (parameter == null) continue;
                ((Parameter)object).setValue(parameter.getValue());
            }
        }
        return objectArray;
    }

    public static Parameter[] analyzeAndUnionSameParameters(String[] stringArray, Parameter[] parameterArray) {
        Object[] objectArray = ParameterHelper.analyze4Parameters(stringArray, false);
        if (ArrayUtils.isEmpty(objectArray)) {
            return objectArray;
        }
        if (!ArrayUtils.isEmpty(parameterArray)) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                Parameter parameter = null;
                for (int i3 = 0; i3 < parameterArray.length; ++i3) {
                    if (!ComparatorUtils.equals(parameterArray[i3].getName(), ((Parameter)object).getName())) continue;
                    parameter = parameterArray[i3];
                    break;
                }
                if (parameter == null) continue;
                ((Parameter)object).setValue(parameter.getValue());
            }
        }
        return objectArray;
    }

    static {
        FILTER_PARAMETER_NAME_LIST.add("fr_startrow");
        FILTER_PARAMETER_NAME_LIST.add("fr_pagenumber");
        FILTER_PARAMETER_NAME_LIST.add("fr_pagesize");
        FILTER_PARAMETER_NAME_LIST.add("fr_rowcount");
    }
}

