/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Parameter;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class MultiFieldParameter
extends Parameter {
    public static final String XML_TAG = "MultiFieldParameter";
    private List<ParameterProvider> parameterList = new ArrayList<ParameterProvider>();
    private transient String processName;

    public MultiFieldParameter() {
    }

    public MultiFieldParameter(String string) {
        this.setName(string);
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getFieldName() {
        return this.processName + "." + this.name;
    }

    public MultiFieldParameter parseValueJSON(JSONArray jSONArray) throws JSONException {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (StringUtils.isEmpty(jSONObject.getString("name"))) continue;
            Parameter parameter = Parameter.getParameterFromJson(jSONObject);
            this.parameterList.add(parameter);
        }
        this.setValue(this.parameterList);
        return this;
    }

    public Set getAllFiledName() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Parameter parameter : this.parameterList) {
            hashSet.add(parameter.getName());
        }
        return hashSet;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("name", null);
                if (string2 != null) {
                    this.setName(string2);
                }
            } else if ("Parameters".equals(string)) {
                ParameterProvider[] parameterProviderArray = StableXMLUtils.readParameters(xMLableReader);
                for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
                    this.parameterList.add(parameterProviderArray[i2]);
                }
                this.setValue(this.parameterList);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.getValue() != null) {
            StableXMLUtils.writeParameters(xMLPrintWriter, this.paraListToArray());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MultiFieldParameter multiFieldParameter = (MultiFieldParameter)super.clone();
        multiFieldParameter.parameterList = new ArrayList<ParameterProvider>();
        Iterator<ParameterProvider> iterator = this.parameterList.iterator();
        while (iterator.hasNext()) {
            multiFieldParameter.parameterList.add((ParameterProvider)iterator.next().clone());
        }
        return multiFieldParameter;
    }

    private Parameter[] paraListToArray() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    public Object getValue() {
        try {
            return Parameter.parameters2JSONString(this.paraListToArray());
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().log(Level.WARNING, jSONException.getMessage());
            return null;
        }
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterProvider parameterProvider : this.parameterList) {
            arrayList.addAll(Arrays.asList(parameterProvider.dependence(calculatorProvider)));
        }
        arrayList.add(this.getName());
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

